/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.curses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.favouriteless.enchanted.api.curses.Curse;
import net.favouriteless.enchanted.api.curses.CurseSavedData;
import net.favouriteless.enchanted.common.curses.CurseType;
import net.favouriteless.enchanted.common.network.packets.EnchantedSinkingCursePacket;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CurseManager {
    public static final int MAX_LEVEL = 2;
    public static final Map<UUID, List<Curse>> ACTIVE_CURSES = new HashMap<UUID, List<Curse>>();

    public static void createCurse(class_3218 level, CurseType<?> type, UUID targetUUID, UUID casterUUID, int curseLevel) {
        Object curse = type.create();
        ((Curse)curse).setTarget(targetUUID);
        ((Curse)curse).setCaster(casterUUID);
        ((Curse)curse).setLevel(curseLevel);
        CurseManager.addCurse(level, curse);
    }

    public static void addCurse(class_3218 level, Curse curse) {
        CurseSavedData data = CurseSavedData.get((class_1937)level);
        UUID uuid = curse.getTargetUUID();
        if (data.entries.containsKey(uuid)) {
            List<Curse> curseList = data.entries.get(uuid);
            if (curseList.stream().noneMatch(oldCurse -> oldCurse.getType() == curse.getType())) {
                curseList.add(curse);
            } else {
                for (int i = 0; i < curseList.size(); ++i) {
                    Curse oldCurse2 = curseList.get(i);
                    if (oldCurse2.getType() != curse.getType() || oldCurse2.getLevel() >= curse.getLevel()) continue;
                    curseList.set(i, curse);
                    break;
                }
            }
        } else {
            ArrayList<Curse> newList = new ArrayList<Curse>();
            newList.add(curse);
            data.entries.put(uuid, newList);
        }
        if (level.method_8503().method_3760().method_14602(uuid) != null) {
            ACTIVE_CURSES.put(uuid, data.entries.get(uuid));
        }
        data.method_80();
    }

    public static void removeCurse(class_3218 level, Curse curse) {
        CurseSavedData data = CurseSavedData.get((class_1937)level);
        UUID uuid = curse.getTargetUUID();
        if (data.entries.containsKey(uuid)) {
            data.entries.get(uuid).remove(curse);
            curse.onRemove(level);
            data.method_80();
        }
    }

    public static void tick(class_3218 level) {
        if (level.method_27983() == class_1937.field_25179) {
            for (List<Curse> curses : ACTIVE_CURSES.values()) {
                for (Curse curse : curses) {
                    curse.tick(level);
                }
            }
        }
    }

    public static void playerLoggedIn(class_3222 player) {
        CurseSavedData data = CurseSavedData.get(player.method_37908());
        UUID uuid = player.method_5667();
        if (data.entries.containsKey(uuid)) {
            ACTIVE_CURSES.put(uuid, data.entries.get(uuid));
        }
        data.method_80();
    }

    public static void playerLoggedOut(class_3222 player) {
        ACTIVE_CURSES.remove(player.method_5667());
        CommonServices.NETWORK.sendToPlayer(new EnchantedSinkingCursePacket(0.0), player);
    }
}

