/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.init.registry;

import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.common.altar.PowerProvider;

public class PowerProviderRegistry<T> {
    private final List<PowerProvider<T>> providers = new ArrayList<PowerProvider<T>>();

    public void register(PowerProvider<T> provider) {
        if (!this.providers.isEmpty()) {
            for (int i = 0; i < this.providers.size(); ++i) {
                PowerProvider<T> oldProvider = this.providers.get(i);
                if (provider.power() > oldProvider.power()) {
                    this.providers.add(i, provider);
                    break;
                }
                if (provider.power() == oldProvider.power()) {
                    if (provider.limit() <= oldProvider.limit()) continue;
                    this.providers.add(i, provider);
                    break;
                }
                if (i != this.providers.size() - 1) continue;
                this.providers.add(provider);
            }
        } else {
            this.providers.add(provider);
        }
    }

    public PowerProvider<T> get(T key) {
        for (PowerProvider<T> provider : this.providers) {
            if (!provider.is(key)) continue;
            return provider;
        }
        return null;
    }

    public List<PowerProvider<T>> getAll() {
        return this.providers;
    }

    public void reset() {
        this.providers.clear();
    }
}

