/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.multiblock.altar;

import javax.annotation.Nullable;
import net.favouriteless.enchanted.common.altar.AltarStateObserver;
import net.favouriteless.enchanted.common.blocks.altar.AltarBlock;
import net.favouriteless.enchanted.common.blocks.entity.AltarBlockEntity;
import net.favouriteless.enchanted.common.init.registry.EBlocks;
import net.favouriteless.enchanted.common.multiblock.IMultiBlockType;
import net.favouriteless.enchanted.common.multiblock.altar.AltarPartIndex;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class AltarMultiBlock
implements IMultiBlockType {
    public static AltarMultiBlock INSTANCE = new AltarMultiBlock();

    @Override
    public boolean isValidFormedBlock(class_1937 level, class_2338 pos, int dx, int dy, int dz) {
        class_2338 p = pos.method_10069(dx, dy, dz);
        class_2680 state = level.method_8320(p);
        if (AltarMultiBlock.isFormedAltar(state)) {
            AltarPartIndex index = (AltarPartIndex)((Object)state.method_11654(AltarBlock.FORMED));
            return index == AltarPartIndex.getIndex(dx, dz);
        }
        return false;
    }

    @Override
    public boolean isValidUnformedBlock(class_1937 level, class_2338 pos, int dx, int dy, int dz) {
        class_2338 p = pos.method_10069(dx, dy, dz);
        class_2680 state = level.method_8320(p);
        return AltarMultiBlock.isUnformedAltar(state);
    }

    @Override
    public void create(class_1937 world, class_2338 pos) {
        if (this.isValidUnformedMultiBlockX(world, pos)) {
            for (int dx = 0; dx < 3; ++dx) {
                for (int dz = 0; dz < 2; ++dz) {
                    if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                    this.formBlock(world, pos.method_10069(dx, 0, dz), dx, 0, dz, true);
                }
            }
        } else {
            for (int dx = 0; dx < 2; ++dx) {
                for (int dz = 0; dz < 3; ++dz) {
                    if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                    this.formBlock(world, pos.method_10069(dx, 0, dz), dx, 0, dz, false);
                }
            }
        }
    }

    @Override
    @Nullable
    public class_2338 getBottomLowerLeft(class_1937 level, class_2338 pos, class_2680 state) {
        if (AltarMultiBlock.isFormedAltar(state)) {
            AltarPartIndex index = (AltarPartIndex)((Object)state.method_11654(AltarBlock.FORMED));
            return pos.method_10069(-index.getDx(), -index.getDy(), -index.getDz());
        }
        return null;
    }

    @Override
    public void unformBlock(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        if (state.method_27852(EBlocks.ALTAR.get())) {
            if (state.method_11654(AltarBlock.FORMED) == AltarPartIndex.P000) {
                AltarStateObserver observer = (AltarStateObserver)StateObserverManager.get().getObserver(level, pos, AltarStateObserver.class);
                if (observer != null) {
                    StateObserverManager.get().removeObserver((StateObserver)observer);
                }
                if (level.method_8321(pos) instanceof AltarBlockEntity) {
                    level.method_8544(pos);
                }
            }
            level.method_8501(pos, EBlocks.ALTAR.get().method_9564());
        }
    }

    @Override
    public void formBlock(class_1937 level, class_2338 pos, int dx, int dy, int dz) {
        this.formBlock(level, pos, dx, dy, dz, false);
    }

    public void formBlock(class_1937 world, class_2338 pos, int dx, int dy, int dz, boolean facingX) {
        world.method_8501(pos, (class_2680)((class_2680)EBlocks.ALTAR.get().method_9564().method_11657(AltarBlock.FORMED, (Comparable)((Object)AltarPartIndex.getIndex(dx, dz)))).method_11657((class_2769)AltarBlock.FACING_X, (Comparable)Boolean.valueOf(facingX)));
    }

    @Override
    public boolean isValidUnformedMultiBlock(class_1937 world, class_2338 pos) {
        return this.isValidUnformedMultiBlockX(world, pos) || this.isValidUnformedMultiBlockZ(world, pos);
    }

    private boolean isValidUnformedMultiBlockX(class_1937 world, class_2338 pos) {
        if (!this.isValidUnformedBlock(world, pos, 0, 0, 0)) {
            return false;
        }
        int validCount = 0;
        for (int dx = 0; dx < 3; ++dx) {
            for (int dz = 0; dz < 2; ++dz) {
                if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        return validCount == 6;
    }

    private boolean isValidUnformedMultiBlockZ(class_1937 world, class_2338 pos) {
        if (!this.isValidUnformedBlock(world, pos, 0, 0, 0)) {
            return false;
        }
        int validCount = 0;
        for (int dx = 0; dx < 2; ++dx) {
            for (int dz = 0; dz < 3; ++dz) {
                if (!this.isValidUnformedBlock(world, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        return validCount == 6;
    }

    @Override
    public boolean isValidFormedMultiBlock(class_1937 level, class_2338 pos) {
        int dz;
        int dx;
        if (!this.isValidFormedBlock(level, pos, 0, 0, 0)) {
            return false;
        }
        int validCount = 0;
        for (dx = 0; dx < 3; ++dx) {
            for (dz = 0; dz < 2; ++dz) {
                if (!this.isValidFormedBlock(level, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        if (validCount == 6) {
            return true;
        }
        validCount = 0;
        for (dx = 0; dx < 2; ++dx) {
            for (dz = 0; dz < 3; ++dz) {
                if (!this.isValidFormedBlock(level, pos, dx, 0, dz)) continue;
                ++validCount;
            }
        }
        return validCount == 6;
    }

    private static boolean isUnformedAltar(class_2680 state) {
        return state.method_27852(EBlocks.ALTAR.get()) && state.method_11654(AltarBlock.FORMED) == AltarPartIndex.UNFORMED;
    }

    private static boolean isFormedAltar(class_2680 state) {
        return state.method_27852(EBlocks.ALTAR.get()) && state.method_11654(AltarBlock.FORMED) != AltarPartIndex.UNFORMED;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 3;
    }
}

