/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.entity.PoppetShelfBlockEntity;
import net.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import net.favouriteless.enchanted.common.poppet.PoppetUtils;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class PoppetShelfSavedData
extends class_18 {
    private static final String NAME = "enchanted_poppets";
    public final Map<UUID, List<PoppetEntry>> PLAYER_POPPETS = new HashMap<UUID, List<PoppetEntry>>();
    public final Map<String, PoppetShelfInventory> SHELF_STORAGE = new HashMap<String, PoppetShelfInventory>();
    public final class_3218 level;

    public PoppetShelfSavedData(class_3218 world) {
        this.level = world;
    }

    public static PoppetShelfSavedData get(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 overworld = world.method_8503().method_3847(class_1937.field_25179);
            class_26 storage = overworld.method_17983();
            return (PoppetShelfSavedData)storage.method_17924(nbt -> PoppetShelfSavedData.load(overworld, nbt), () -> new PoppetShelfSavedData(overworld), NAME);
        }
        throw new RuntimeException("Game attempted to load server-side poppet shelf data from a client-side world.");
    }

    public static PoppetShelfSavedData load(class_3218 level, class_2487 nbt) {
        PoppetShelfSavedData data = new PoppetShelfSavedData(level);
        for (String identifier : nbt.method_10541()) {
            class_3218 world = data.getLevelFromShelfIdentifier(identifier);
            class_2338 pos = data.getBlockPosFromShelfIdentifier(identifier);
            PoppetShelfInventory inventory = new PoppetShelfInventory((class_1937)world, pos);
            inventory.load((class_2487)nbt.method_10580(identifier));
            data.SHELF_STORAGE.put(identifier, inventory);
            data.setupPoppetUUIDs(identifier, inventory);
        }
        Enchanted.LOG.info("Loaded poppet shelves successfully");
        return data;
    }

    public class_2487 method_75(class_2487 nbt) {
        for (String identifier : this.SHELF_STORAGE.keySet()) {
            class_2487 tag = new class_2487();
            PoppetShelfInventory inventory = this.SHELF_STORAGE.get(identifier);
            inventory.save(tag);
            nbt.method_10566(identifier, (class_2520)tag);
        }
        Enchanted.LOG.info("Saved poppet shelves successfully");
        return nbt;
    }

    public void updateShelf(String identifier) {
        class_2338 pos;
        class_3218 level = this.getLevelFromShelfIdentifier(identifier);
        class_2586 blockEntity = level.method_8321(pos = this.getBlockPosFromShelfIdentifier(identifier));
        if (blockEntity instanceof PoppetShelfBlockEntity) {
            ((PoppetShelfBlockEntity)blockEntity).updateBlock();
        }
    }

    public void setupPoppetUUIDs(String identifier, PoppetShelfInventory inventory) {
        for (class_1799 item : inventory) {
            this.setupPoppetUUID(identifier, item);
        }
    }

    public void removePoppetUUIDs(String identifier, PoppetShelfInventory inventory) {
        for (class_1799 item : inventory) {
            this.removePoppetUUID(identifier, item);
        }
    }

    public void setupPoppetUUID(String identifier, class_1799 itemStack) {
        if (PoppetUtils.isBound(itemStack)) {
            UUID uuid = itemStack.method_7969().method_25926("boundPlayer");
            this.PLAYER_POPPETS.putIfAbsent(uuid, new ArrayList());
            this.PLAYER_POPPETS.get(uuid).add(new PoppetEntry(itemStack, identifier));
        }
    }

    public void removePoppetUUID(String identifier, class_1799 itemStack) {
        if (PoppetUtils.isBound(itemStack)) {
            UUID uuid = itemStack.method_7969().method_25926("boundPlayer");
            this.PLAYER_POPPETS.get(uuid).removeIf(entry -> entry.matches(itemStack, identifier));
        }
    }

    public static String getShelfIdentifier(class_2586 blockEntity) {
        class_2338 pos = blockEntity.method_11016();
        return String.format("%s+%s+%s+%s", blockEntity.method_10997().method_27983().method_29177(), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static String getShelfIdentifier(class_1937 level, class_2338 pos) {
        return String.format("%s+%s+%s+%s", level.method_27983().method_29177(), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_3218 getLevelFromShelfIdentifier(String shelfIdentifier) {
        String levelString = shelfIdentifier.substring(0, shelfIdentifier.indexOf("+"));
        return this.level.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(levelString)));
    }

    public class_2338 getBlockPosFromShelfIdentifier(String shelfIdentifier) {
        String[] strings = shelfIdentifier.substring(shelfIdentifier.indexOf("+") + 1).split("\\+");
        return new class_2338(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
    }

    public record PoppetEntry(class_1799 item, String shelfIdentifier) {
        public boolean matches(class_1799 stack, String shelfIdentifier) {
            return stack.equals(this.item) && shelfIdentifier.equals(this.shelfIdentifier);
        }
    }
}

