/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.poppet;

import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Predicate;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.items.poppets.DeathPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.ItemProtectionPoppetItem;
import net.favouriteless.enchanted.common.items.poppets.PoppetItem;
import net.favouriteless.enchanted.common.network.packets.EnchantedPoppetAnimationPacket;
import net.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import net.favouriteless.enchanted.common.poppet.PoppetShelfManager;
import net.favouriteless.enchanted.common.poppet.PoppetShelfSavedData;
import net.favouriteless.enchanted.common.poppet.PoppetUseResult;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoppetUtils {
    public static boolean tryVoodooPlayer(class_3222 target, class_3222 attacker, class_1799 poppet) {
        PoppetUseResult result = PoppetUtils.tryUseItems(PoppetUtils.getPoppetQueue((class_1657)target, EItems::isVoodooProtectionPoppet), (class_1657)target, null);
        if (!result.isSuccess() && result.type() != PoppetUseResult.ResultType.FAIL) {
            result = PoppetUtils.tryUseEntries(PoppetUtils.getPoppetQueue(PoppetShelfManager.getEntriesFor((class_1657)target), (PoppetShelfSavedData.PoppetEntry entry) -> EItems.isVoodooProtectionPoppet(entry.item().method_7909())), (class_1657)target, null);
        }
        if (result.isSuccess()) {
            if (attacker != null) {
                class_3218 level = attacker.method_51469();
                if (result.poppet() == EItems.VOODOO_PROTECTION_POPPET_INFUSED.get()) {
                    class_1538 lightningBolt = (class_1538)class_1299.field_6112.method_5883((class_1937)level);
                    lightningBolt.method_24203(attacker.method_23317(), attacker.method_23318(), attacker.method_23321());
                    level.method_8649((class_1297)lightningBolt);
                    attacker.method_6092(new class_1293(class_1294.field_5920, 200, 0));
                }
                level.method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14671, class_3419.field_15250, 1.0f, 1.0f);
            }
            poppet.method_7934(1);
            return false;
        }
        return true;
    }

    public static Queue<class_1799> getPoppetQueue(class_1657 player, Predicate<PoppetItem> validPoppet) {
        PriorityQueue<class_1799> poppetQueue = new PriorityQueue<class_1799>(new PoppetComparator());
        for (class_1799 stack : player.method_31548().field_7547) {
            PoppetItem poppet;
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof PoppetItem) || !validPoppet.test(poppet = (PoppetItem)class_17922)) continue;
            poppetQueue.add(stack);
        }
        return poppetQueue;
    }

    public static Queue<PoppetShelfSavedData.PoppetEntry> getPoppetQueue(List<PoppetShelfSavedData.PoppetEntry> entries, Predicate<PoppetShelfSavedData.PoppetEntry> validPoppet) {
        PriorityQueue<PoppetShelfSavedData.PoppetEntry> poppetQueue = new PriorityQueue<PoppetShelfSavedData.PoppetEntry>(new PoppetEntryComparator());
        for (PoppetShelfSavedData.PoppetEntry entry : entries) {
            if (!validPoppet.test(entry)) continue;
            poppetQueue.add(entry);
        }
        return poppetQueue;
    }

    public static boolean isBound(class_1799 item) {
        if (item.method_7985()) {
            return item.method_7909() instanceof PoppetItem && item.method_7969().method_25928("boundPlayer");
        }
        return false;
    }

    public static boolean belongsTo(class_1799 item, class_1657 player) {
        return PoppetUtils.belongsTo(item, player.method_5667());
    }

    public static boolean belongsTo(class_1799 item, UUID uuid) {
        class_2487 tag;
        if (item.method_7985() && item.method_7909() instanceof PoppetItem && (tag = item.method_7969()).method_25928("boundPlayer")) {
            return tag.method_25926("boundPlayer").equals(uuid);
        }
        return false;
    }

    public static class_3222 getBoundPlayer(class_1799 item, class_3218 level) {
        if (PoppetUtils.isBound(item)) {
            return level.method_8503().method_3760().method_14602(item.method_7969().method_25926("boundPlayer"));
        }
        return null;
    }

    public static String getBoundName(class_1799 item) {
        if (PoppetUtils.isBound(item)) {
            return item.method_7969().method_10558("boundName");
        }
        return "None";
    }

    public static void bind(class_1799 item, class_1657 player) {
        if (item.method_7909() instanceof PoppetItem) {
            class_2487 tag = item.method_7948();
            tag.method_25927("boundPlayer", player.method_5667());
            tag.method_10582("boundName", player.method_5476().getString());
            item.method_7980(tag);
        }
    }

    public static void unbind(class_1799 item) {
        if (item.method_7909() instanceof PoppetItem && item.method_7985()) {
            class_2487 tag = item.method_7969();
            tag.method_10551("boundPlayer");
            tag.method_10551("boundName");
            item.method_7980(tag);
        }
    }

    private static PoppetUseResult tryUsePoppet(@NotNull class_1657 owner, @NotNull class_1799 poppetStack, @Nullable class_1799 protectStack, @Nullable String shelfIdentifier) {
        class_1792 class_17922 = poppetStack.method_7909();
        if (class_17922 instanceof PoppetItem) {
            PoppetItem poppet = (PoppetItem)class_17922;
            class_17922 = owner.method_37908();
            if (class_17922 instanceof class_3218) {
                class_3218 level = (class_3218)class_17922;
                if (Enchanted.RANDOM.nextFloat() > poppet.getFailRate()) {
                    class_1792 class_17923;
                    if (protectStack != null && (class_17923 = poppetStack.method_7909()) instanceof ItemProtectionPoppetItem) {
                        ItemProtectionPoppetItem protection = (ItemProtectionPoppetItem)class_17923;
                        protection.protect(protectStack);
                    } else {
                        class_17923 = poppetStack.method_7909();
                        if (class_17923 instanceof DeathPoppetItem) {
                            DeathPoppetItem death = (DeathPoppetItem)class_17923;
                            death.protect(owner);
                        }
                    }
                    level.method_43128(null, owner.method_23317(), owner.method_23318(), owner.method_23321(), class_3417.field_14931, class_3419.field_15248, 0.5f, 1.0f);
                    return PoppetUseResult.of(poppetStack.method_7909(), PoppetUtils.damagePoppet(poppetStack, level, shelfIdentifier));
                }
                return PoppetUseResult.fail(poppetStack.method_7909());
            }
        }
        return PoppetUseResult.pass();
    }

    public static PoppetUseResult handleTryUsePoppet(@NotNull class_1657 owner, @NotNull class_1799 poppetStack, @Nullable class_1799 protectStack, @Nullable String shelfIdentifier) {
        class_1799 original = poppetStack.method_7972();
        return PoppetUtils.trySendAnimation(PoppetUtils.tryUsePoppet(owner, poppetStack, protectStack, shelfIdentifier), original, owner);
    }

    public static PoppetUseResult tryUseItems(@NotNull Queue<class_1799> queue, @NotNull class_1657 owner) {
        return PoppetUtils.tryUseItems(queue, owner, null);
    }

    public static PoppetUseResult tryUseItems(@NotNull Queue<class_1799> queue, @NotNull class_1657 owner, @Nullable class_1799 protectStack) {
        while (!queue.isEmpty()) {
            PoppetUseResult result = PoppetUtils.handleTryUsePoppet(owner, queue.remove(), protectStack, null);
            if (!result.isSuccess() && result.type() != PoppetUseResult.ResultType.FAIL) continue;
            return result;
        }
        return PoppetUseResult.pass();
    }

    public static PoppetUseResult tryUseEntries(@NotNull Queue<PoppetShelfSavedData.PoppetEntry> queue, @NotNull class_1657 owner) {
        return PoppetUtils.tryUseEntries(queue, owner, null);
    }

    public static PoppetUseResult tryUseEntries(@NotNull Queue<PoppetShelfSavedData.PoppetEntry> queue, @NotNull class_1657 owner, @Nullable class_1799 protectStack) {
        while (!queue.isEmpty()) {
            PoppetShelfSavedData.PoppetEntry entry = queue.remove();
            PoppetUseResult result = PoppetUtils.handleTryUsePoppet(owner, entry.item(), protectStack, entry.shelfIdentifier());
            if (!result.isSuccess() && result.type() != PoppetUseResult.ResultType.FAIL) continue;
            return result;
        }
        return PoppetUseResult.pass();
    }

    public static boolean damagePoppet(class_1799 item, class_3218 level, String shelfIdentifier) {
        item.method_7974(item.method_7919() + 1);
        if (item.method_7919() >= item.method_7936()) {
            item.method_7934(1);
            if (shelfIdentifier != null && item.method_7947() <= 0) {
                PoppetShelfSavedData data = PoppetShelfSavedData.get((class_1937)level);
                PoppetShelfInventory inventory = data.SHELF_STORAGE.get(shelfIdentifier);
                for (int i = 0; i < inventory.method_5439(); ++i) {
                    if (!inventory.get(i).equals(item)) continue;
                    inventory.set(i, class_1799.field_8037);
                }
                data.updateShelf(shelfIdentifier);
            }
            return true;
        }
        return false;
    }

    private static PoppetUseResult trySendAnimation(PoppetUseResult result, class_1799 poppetItemOriginal, class_1657 player) {
        if (result.isSuccess() && !player.method_37908().field_9236) {
            CommonServices.NETWORK.sendToAllPlayers(new EnchantedPoppetAnimationPacket(result.type(), poppetItemOriginal, player.method_5628()), player.method_37908().method_8503());
        }
        return result;
    }

    private static class PoppetComparator
    implements Comparator<class_1799> {
        private PoppetComparator() {
        }

        @Override
        public int compare(class_1799 o1, class_1799 o2) {
            if (!(o1.method_7909() instanceof PoppetItem) || !(o1.method_7909() instanceof PoppetItem)) {
                throw new IllegalStateException("Non-poppet item inside the poppet use queue");
            }
            return Math.round(Math.signum(((PoppetItem)o1.method_7909()).getFailRate() - ((PoppetItem)o2.method_7909()).getFailRate()));
        }
    }

    private static class PoppetEntryComparator
    implements Comparator<PoppetShelfSavedData.PoppetEntry> {
        private PoppetEntryComparator() {
        }

        @Override
        public int compare(PoppetShelfSavedData.PoppetEntry o1, PoppetShelfSavedData.PoppetEntry o2) {
            return Math.round(Math.signum(((PoppetItem)o1.item().method_7909()).getFailRate() - ((PoppetItem)o2.item().method_7909()).getFailRate()));
        }
    }
}

