/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes;

import com.google.gson.JsonObject;
import net.favouriteless.enchanted.common.init.registry.ERecipeTypes;
import net.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.favouriteless.enchanted.common.util.JsonHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class KettleRecipe
extends CauldronTypeRecipe {
    public KettleRecipe(class_2960 id, class_2371<class_1799> itemsIn, class_1799 itemOut, int power, int[] cookingColour, int[] finalColour) {
        super(ERecipeTypes.KETTLE.get(), id, itemsIn, itemOut, power, cookingColour, finalColour);
    }

    public class_1865<?> method_8119() {
        return ERecipeTypes.KETTLE_SERIALIZER.get();
    }

    public static class Serializer
    implements class_1865<KettleRecipe> {
        public KettleRecipe fromJson(class_2960 id, JsonObject json) {
            class_2371<class_1799> itemsIn = JsonHelper.readItemStackList(class_3518.method_15261((JsonObject)json, (String)"ingredients"), true);
            class_1799 itemOut = ItemUtils.fromJson(class_3518.method_15296((JsonObject)json, (String)"result"), true);
            int power = class_3518.method_15260((JsonObject)json, (String)"power");
            int[] cookingColour = JsonHelper.readRgb(class_3518.method_15261((JsonObject)json, (String)"cookingColor"));
            int[] finalColour = JsonHelper.readRgb(class_3518.method_15261((JsonObject)json, (String)"finalColor"));
            return new KettleRecipe(id, itemsIn, itemOut, power, cookingColour, finalColour);
        }

        public KettleRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            int inSize = buffer.readInt();
            class_2371 itemsIn = class_2371.method_10211();
            for (int x = 0; x < inSize; ++x) {
                itemsIn.add((Object)buffer.method_10819());
            }
            class_1799 itemOut = buffer.method_10819();
            int power = buffer.readInt();
            int[] cookingColour = new int[]{buffer.readShort(), buffer.readShort(), buffer.readShort()};
            int[] finalColour = new int[]{buffer.readShort(), buffer.readShort(), buffer.readShort()};
            return new KettleRecipe(id, (class_2371<class_1799>)itemsIn, itemOut, power, cookingColour, finalColour);
        }

        public void toNetwork(class_2540 buffer, KettleRecipe recipe) {
            buffer.writeInt(recipe.itemsIn.size());
            for (class_1799 item : recipe.itemsIn) {
                buffer.method_10793(item);
            }
            buffer.method_10793(recipe.itemOut);
            buffer.writeInt(recipe.getPower());
            buffer.writeShort(recipe.getCookRed());
            buffer.writeShort(recipe.getCookGreen());
            buffer.writeShort(recipe.getCookBlue());
            buffer.writeShort(recipe.getFinalRed());
            buffer.writeShort(recipe.getFinalGreen());
            buffer.writeShort(recipe.getFinalBlue());
        }
    }
}

