/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.recipes;

import com.google.gson.JsonObject;
import net.favouriteless.enchanted.common.init.registry.ERecipeTypes;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.favouriteless.enchanted.common.util.JsonHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class SpinningRecipe
implements class_1860<class_1263> {
    protected final class_3956<?> type = ERecipeTypes.SPINNING.get();
    protected final class_2960 id;
    protected final class_2371<class_1799> itemsIn;
    protected final class_1799 result;
    protected final int power;
    protected final int duration;

    public SpinningRecipe(class_2960 id, class_2371<class_1799> itemsIn, class_1799 result, int power, int duration) {
        this.id = id;
        this.itemsIn = itemsIn;
        this.result = result;
        this.power = power;
        this.duration = duration;
    }

    public boolean method_8115(class_1263 inv, class_1937 level) {
        class_1799 mainIn = inv.method_5438(0);
        if (!class_1799.method_7984((class_1799)mainIn, (class_1799)((class_1799)this.itemsIn.get(0))) || mainIn.method_7947() < ((class_1799)this.itemsIn.get(0)).method_7947()) {
            return false;
        }
        for (int i = 1; i < this.itemsIn.size(); ++i) {
            class_1799 itemNeeded = ((class_1799)this.itemsIn.get(i)).method_7972();
            if (ItemUtils.isSameItemPartial(inv.method_5438(1), itemNeeded)) {
                itemNeeded.method_7934(inv.method_5438(1).method_7947());
            }
            if (ItemUtils.isSameItemPartial(inv.method_5438(2), itemNeeded)) {
                itemNeeded.method_7934(inv.method_5438(2).method_7947());
            }
            if (itemNeeded.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_1263 inv, class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 4;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ERecipeTypes.SPINNING_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public boolean method_8118() {
        return true;
    }

    public class_2371<class_1799> getItemsIn() {
        class_2371 in = class_2371.method_10213((int)this.itemsIn.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.itemsIn.size(); ++i) {
            in.set(i, (Object)((class_1799)this.itemsIn.get(i)).method_7972());
        }
        return in;
    }

    public int getPower() {
        return this.power;
    }

    public int getDuration() {
        return this.duration;
    }

    public static class Serializer
    implements class_1865<SpinningRecipe> {
        public SpinningRecipe fromJson(class_2960 recipeId, JsonObject json) {
            class_2371<class_1799> itemsIn = JsonHelper.readItemStackList(class_3518.method_15261((JsonObject)json, (String)"ingredients"), true);
            class_1799 result = ItemUtils.fromJson(class_3518.method_15296((JsonObject)json, (String)"result"), true);
            int power = class_3518.method_15282((JsonObject)json, (String)"power", (int)0);
            int duration = class_3518.method_15282((JsonObject)json, (String)"duration", (int)0);
            return new SpinningRecipe(recipeId, itemsIn, result, power, duration);
        }

        public SpinningRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int ingredientSize = buffer.readInt();
            class_2371 itemsIn = class_2371.method_10211();
            for (int i = 0; i < ingredientSize; ++i) {
                itemsIn.add((Object)buffer.method_10819());
            }
            class_1799 result = buffer.method_10819();
            int power = buffer.readInt();
            int duration = buffer.readInt();
            return new SpinningRecipe(recipeId, (class_2371<class_1799>)itemsIn, result, power, duration);
        }

        public void toNetwork(class_2540 buffer, SpinningRecipe recipe) {
            buffer.writeInt(recipe.itemsIn.size());
            recipe.itemsIn.forEach(arg_0 -> ((class_2540)buffer).method_10793(arg_0));
            buffer.method_10793(recipe.result);
            buffer.writeInt(recipe.getPower());
            buffer.writeInt(recipe.getDuration());
        }
    }
}

