/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_3518;

public class JsonHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static class_2371<class_1799> readItemStackList(JsonArray array, boolean readNbt) {
        class_2371 out = class_2371.method_10211();
        for (int i = 0; i < array.size(); ++i) {
            out.add((Object)ItemUtils.fromJson(array.get(i).getAsJsonObject(), readNbt));
        }
        return out;
    }

    public static class_2371<class_1856> readIngredientList(JsonArray array) {
        class_2371 out = class_2371.method_10211();
        for (int i = 0; i < array.size(); ++i) {
            out.add((Object)class_1856.method_52177((JsonElement)array.get(i)));
        }
        return out;
    }

    public static class_2371<class_1792> readItemList(JsonArray array) {
        class_2371 out = class_2371.method_10211();
        for (int i = 0; i < array.size(); ++i) {
            out.add((Object)ItemUtils.fromJson(array.get(i).getAsJsonObject(), false).method_7909());
        }
        return out;
    }

    public static int[] readRgb(JsonArray json) {
        if (json.size() != 3) {
            throw new JsonParseException("Invalid colour in json");
        }
        return new int[]{json.get(0).getAsInt(), json.get(1).getAsInt(), json.get(2).getAsInt()};
    }

    public static JsonArray rgbAsJson(int red, int green, int blue) {
        JsonArray out = new JsonArray();
        out.add((Number)red);
        out.add((Number)green);
        out.add((Number)blue);
        return out;
    }

    public static JsonArray rgbAsJson(int[] rgb) {
        JsonArray out = new JsonArray();
        out.add((Number)rgb[0]);
        out.add((Number)rgb[1]);
        out.add((Number)rgb[2]);
        return out;
    }

    public static class_2487 readTag(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + exception);
        }
    }
}

