/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.favouriteless.enchanted.client.screens.DistilleryScreen;
import net.favouriteless.enchanted.client.screens.SpinningWheelScreen;
import net.favouriteless.enchanted.client.screens.WitchOvenScreen;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.init.registry.EMenuTypes;
import net.favouriteless.enchanted.common.init.registry.ERecipeTypes;
import net.favouriteless.enchanted.common.menus.SpinningWheelMenu;
import net.favouriteless.enchanted.common.menus.WitchOvenMenu;
import net.favouriteless.enchanted.common.util.RecipeUtils;
import net.favouriteless.enchanted.integrations.jei.DistilleryTransferInfo;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.favouriteless.enchanted.integrations.jei.categories.ByproductCategory;
import net.favouriteless.enchanted.integrations.jei.categories.CauldronCategory;
import net.favouriteless.enchanted.integrations.jei.categories.DistillingCategory;
import net.favouriteless.enchanted.integrations.jei.categories.KettleCategory;
import net.favouriteless.enchanted.integrations.jei.categories.MutandisCategory;
import net.favouriteless.enchanted.integrations.jei.categories.RiteCategory;
import net.favouriteless.enchanted.integrations.jei.categories.SpinningCategory;
import net.favouriteless.enchanted.integrations.jei.container_handlers.DistilleryContainerHandler;
import net.favouriteless.enchanted.integrations.jei.container_handlers.SpinningWheelContainerHandler;
import net.favouriteless.enchanted.integrations.jei.container_handlers.WitchOvenContainerHandler;
import net.favouriteless.enchanted.integrations.jei.recipes.JeiMutandisRecipe;
import net.favouriteless.enchanted.integrations.jei.recipes.JeiRiteRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@JeiPlugin
public class EJeiPlugin
implements IModPlugin {
    public static final class_2960 ID = Enchanted.id("jei_plugin");

    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers helpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ByproductCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SpinningCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DistillingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RiteCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new KettleCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MutandisCategory(guiHelper, EJeiRecipeTypes.MUTANDIS, EItems.MUTANDIS.get(), (class_2561)class_2561.method_43471((String)"jei.enchanted.mutandis"))});
        registration.addRecipeCategories(new IRecipeCategory[]{new MutandisCategory(guiHelper, EJeiRecipeTypes.MUTANDIS_EXTREMIS, EItems.MUTANDIS_EXTREMIS.get(), (class_2561)class_2561.method_43471((String)"jei.enchanted.mutandis_extremis"))});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(EJeiRecipeTypes.BYPRODUCT, RecipeUtils.getRecipes(ERecipeTypes.BYPRODUCT.get()));
        registration.addRecipes(EJeiRecipeTypes.SPINNING, RecipeUtils.getRecipes(ERecipeTypes.SPINNING.get()));
        registration.addRecipes(EJeiRecipeTypes.CAULDRON, RecipeUtils.getRecipes(ERecipeTypes.WITCH_CAULDRON.get()));
        registration.addRecipes(EJeiRecipeTypes.KETTLE, RecipeUtils.getRecipes(ERecipeTypes.KETTLE.get()));
        registration.addRecipes(EJeiRecipeTypes.DISTILLING, RecipeUtils.getRecipes(ERecipeTypes.DISTILLING.get()));
        JeiRiteRecipe.register(registration, (class_2378<RiteType>)((class_2378)class_310.method_1551().method_1562().method_29091().method_33310(EData.RITE_TYPES_REGISTRY).get()));
        JeiMutandisRecipe.register(registration);
        registration.addIngredientInfo((Object)new class_1799((class_1935)EItems.CHALICE_FILLED.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new class_2561[]{class_2561.method_43471((String)"jei.enchanted.chalice_filled")});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(WitchOvenMenu.class, EMenuTypes.WITCH_OVEN.get(), EJeiRecipeTypes.BYPRODUCT, 0, 1, 5, 36);
        registration.addRecipeTransferHandler(SpinningWheelMenu.class, EMenuTypes.SPINNING_WHEEL.get(), EJeiRecipeTypes.SPINNING, 0, 3, 4, 36);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new DistilleryTransferInfo());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(EItems.WITCH_OVEN.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.BYPRODUCT});
        registration.addRecipeCatalyst(EItems.SPINNING_WHEEL.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.SPINNING});
        registration.addRecipeCatalyst(EItems.WITCH_CAULDRON.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.CAULDRON});
        registration.addRecipeCatalyst(EItems.KETTLE.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.KETTLE});
        registration.addRecipeCatalyst(EItems.DISTILLERY.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.DISTILLING});
        registration.addRecipeCatalyst(EItems.GOLDEN_CHALK.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.RITE});
        registration.addRecipeCatalyst(EItems.MUTANDIS.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.MUTANDIS});
        registration.addRecipeCatalyst(EItems.MUTANDIS_EXTREMIS.get().method_7854(), new RecipeType[]{EJeiRecipeTypes.MUTANDIS_EXTREMIS});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(DistilleryScreen.class, (IGuiContainerHandler)new DistilleryContainerHandler());
        registration.addGenericGuiContainerHandler(SpinningWheelScreen.class, (IGuiContainerHandler)new SpinningWheelContainerHandler());
        registration.addGenericGuiContainerHandler(WitchOvenScreen.class, (IGuiContainerHandler)new WitchOvenContainerHandler());
    }
}

