/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.recipes.WitchCauldronRecipe;
import net.favouriteless.enchanted.common.util.RecipeUtils;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CauldronCategory
implements IRecipeCategory<WitchCauldronRecipe> {
    private final IGuiHelper guiHelper;
    private final int GUI_WIDTH = 140;
    private final IDrawableAnimated arrow;

    public CauldronCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        IDrawableStatic arrow = guiHelper.createDrawable(Enchanted.id("textures/gui/witch_oven.png"), 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrow, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(WitchCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 gui, double mouseX, double mouseY) {
        this.arrow.draw(gui, 85, 29);
        this.drawPowerCost(class_310.method_1551(), gui, "Required Altar Power : " + recipe.getPower(), -1);
    }

    private void drawPowerCost(class_310 minecraft, class_332 gui, String text, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.field_1772.method_1727(text);
        int x = 70 - width / 2 - 1;
        int y = 55;
        gui.method_51433(minecraft.field_1772, text, x + 1, y, shadowColor, false);
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.enchanted.witch_cauldron");
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(Enchanted.id("textures/gui/jei/witch_cauldron.png"), 4, 4, 140, 70);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WitchCauldronRecipe recipe, IFocusGroup focuses) {
        int offset = 0;
        for (class_1799 i : recipe.getItemsIn()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 5 + offset, 5).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 20;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 30).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)RecipeUtils.getResultItem(recipe));
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EItems.WITCH_CAULDRON.get()));
    }

    public RecipeType<WitchCauldronRecipe> getRecipeType() {
        return EJeiRecipeTypes.CAULDRON;
    }
}

