/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.recipes.DistillingRecipe;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class DistillingCategory
implements IRecipeCategory<DistillingRecipe> {
    private final IGuiHelper helper;
    private final IDrawableAnimated bubbles;
    private final IDrawableAnimated arrow;

    public DistillingCategory(IGuiHelper helper) {
        this.helper = helper;
        IDrawableStatic bubbles = helper.createDrawable(Enchanted.id("textures/gui/distillery.png"), 176, 0, 12, 29);
        this.bubbles = helper.createAnimatedDrawable(bubbles, 120, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic arrow = helper.createDrawable(Enchanted.id("textures/gui/distillery.png"), 176, 29, 57, 61);
        this.arrow = helper.createAnimatedDrawable(arrow, 120, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(DistillingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 gui, double mouseX, double mouseY) {
        this.bubbles.draw(gui, 88, 22);
        this.arrow.draw(gui, 65, 8);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DistillingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 30).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((class_1799)recipe.getItemsIn().get(0)));
        int offset = 0;
        for (class_1799 i : recipe.getItemsIn()) {
            if (offset != 0) {
                builder.addSlot(RecipeIngredientRole.INPUT, 50, offset).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            }
            offset += 20;
        }
        offset = 0;
        for (class_1799 i : recipe.getItemsOut()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 2 + offset).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            offset += 19;
        }
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"container.enchanted.distillery");
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(Enchanted.id("textures/gui/distillery.png"), 4, 5, 146, 75);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EItems.DISTILLERY.get()));
    }

    public RecipeType<DistillingRecipe> getRecipeType() {
        return EJeiRecipeTypes.DISTILLING;
    }
}

