/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.favouriteless.enchanted.integrations.jei.recipes.JeiRiteRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class RiteCategory
implements IRecipeCategory<JeiRiteRecipe> {
    private static final int CIRCLE_SIZE = 110;
    private static final int START_RADIUS = 15;
    private static final int RADIUS_INCREMENT = 15;
    private final IGuiHelper helper;
    private final IDrawableStatic background;
    private final IDrawableStatic glyph_golden;
    private final IDrawable icon;
    private final List<IDrawableStatic> circles = new ArrayList<IDrawableStatic>();

    public RiteCategory(IGuiHelper helper) {
        this.helper = helper;
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EItems.RITUAL_CHALK.get()));
        this.background = helper.createDrawable(Enchanted.id("textures/gui/jei/circle_magic.png"), 0, 0, 180, 120);
        this.glyph_golden = this.buildTexture(Enchanted.id("textures/gui/jei/gold_glyph.png"), 110, 110);
    }

    public void draw(JeiRiteRecipe recipe, IRecipeSlotsView slots, class_332 graphics, double mouseX, double mouseY) {
        this.background.draw(graphics);
        for (IDrawableStatic drawable : this.circles) {
            drawable.draw(graphics, 0, 14);
        }
        this.glyph_golden.draw(graphics, 0, 14);
        class_2960 riteName = recipe.id();
        String nameText = class_2561.method_43471((String)("rite." + riteName.method_12836() + "." + riteName.method_12832())).getString();
        this.drawText(graphics, nameText, 180, 0);
        this.drawText(graphics, "Required Altar Power : " + recipe.rite().getPower(), 180, 112);
    }

    public RecipeType<JeiRiteRecipe> getRecipeType() {
        return EJeiRecipeTypes.RITE;
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.enchanted.circle_magic");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiRiteRecipe recipe, IFocusGroup focuses) {
        List<class_1799> itemsOut = recipe.rite().getOutputs();
        if (itemsOut == null) {
            return;
        }
        ArrayList<class_1799> itemList = new ArrayList<class_1799>(recipe.rite().getItems());
        int circleNum = 1;
        int itemsRemaining = itemList.size();
        while (itemsRemaining > 0) {
            int radius = 15 + (circleNum - 1) * 15;
            int limit = (int)Math.round(Math.pow(6.0, circleNum));
            int itemCount = Math.min(itemsRemaining, limit);
            for (int i = 0; i < itemCount; ++i) {
                class_1799 stack = (class_1799)itemList.get(0);
                itemList.remove(stack);
                float angle = (float)i * ((float)Math.PI * 2) / (float)itemCount + (float)Math.PI;
                int cx = Math.round(class_3532.method_15374((float)(-angle)) * (float)radius) - 8;
                int cy = Math.round(class_3532.method_15362((float)(-angle)) * (float)radius) - 8;
                builder.addSlot(RecipeIngredientRole.INPUT, 47 + cx, 60 + cy).addItemStack(stack);
                --itemsRemaining;
            }
            ++circleNum;
        }
        int numRows = (int)Math.ceil((float)itemsOut.size() / 3.0f);
        int height = numRows * 17;
        int startX = 119;
        int startY = 61 - Math.round((float)height / 2.0f);
        for (int i = 0; i < itemsOut.size(); ++i) {
            class_1799 stack = itemsOut.get(i);
            builder.addSlot(RecipeIngredientRole.OUTPUT, startX + i % 3 * 17, startY + i / 3 * 17).addItemStack(stack);
        }
        this.circles.clear();
        for (Map.Entry<class_5321<CircleMagicShape>, class_2248> entry : recipe.rite().getShapes().entrySet()) {
            CircleMagicShape shapeKey = (CircleMagicShape)class_310.method_1551().field_1687.method_30349().method_30530(EData.CIRCLE_SHAPE_REGISTRY).method_29107(entry.getKey());
            if (shapeKey == null) {
                return;
            }
            class_2960 location = entry.getKey().method_29177();
            class_2960 texture = class_2960.method_43902((String)location.method_12836(), (String)String.format("textures/gui/circle_magic_shapes/%s_%s.png", location.method_12832(), class_7923.field_41175.method_10221((Object)entry.getValue()).method_12832()));
            if (!class_310.method_1551().method_1478().method_14486(texture).isPresent()) continue;
            this.circles.add(this.buildTexture(texture, 110, 110));
        }
    }

    private void drawText(class_332 graphics, String text, int x, int y) {
        class_310 mc = class_310.method_1551();
        int width = mc.field_1772.method_1727(text);
        int cx = x / 2 - width / 2 - 1;
        graphics.method_51433(mc.field_1772, text, cx + 1, y, Color.DARK_GRAY.getRGB(), false);
    }

    private IDrawableStatic buildTexture(class_2960 id, int width, int height) {
        return this.helper.drawableBuilder(id, 0, 0, width, height).setTextureSize(width, height).build();
    }
}

