/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.integrations.jei.categories;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.init.registry.EItems;
import net.favouriteless.enchanted.common.recipes.SpinningRecipe;
import net.favouriteless.enchanted.common.util.RecipeUtils;
import net.favouriteless.enchanted.integrations.jei.EJeiRecipeTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class SpinningCategory
implements IRecipeCategory<SpinningRecipe> {
    private final IGuiHelper guiHelper;
    private final int GUI_WIDTH = 140;
    private final IDrawableAnimated leftArrow;
    private final IDrawableAnimated rightArrow;
    private final IDrawableStatic background;

    public SpinningCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        IDrawableStatic leftArrow = guiHelper.createDrawable(Enchanted.id("textures/gui/spinning_wheel.png"), 176, 0, 15, 20);
        this.leftArrow = guiHelper.createAnimatedDrawable(leftArrow, 120, IDrawableAnimated.StartDirection.BOTTOM, false);
        IDrawableStatic rightArrow = guiHelper.createDrawable(Enchanted.id("textures/gui/spinning_wheel.png"), 176, 20, 15, 20);
        this.rightArrow = guiHelper.createAnimatedDrawable(rightArrow, 120, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.background = guiHelper.createDrawable(Enchanted.id("textures/gui/spinning_wheel.png"), 20, 10, 140, 60);
    }

    public void draw(SpinningRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 gui, double mouseX, double mouseY) {
        this.background.draw(gui);
        this.leftArrow.draw(gui, 7, 16);
        this.rightArrow.draw(gui, 44, 16);
        this.drawPowerCost(class_310.method_1551(), gui, "Required Altar Power : " + recipe.getPower(), -1);
    }

    private void drawPowerCost(class_310 minecraft, class_332 gui, String text, int mainColor) {
        int shadowColor = 0xFF000000 | (mainColor & 0xFCFCFC) >> 2;
        int width = minecraft.field_1772.method_1727(text);
        int x = 70 - width / 2 - 1;
        int y = 65;
        gui.method_51433(minecraft.field_1772, text, x + 1, y, shadowColor, false);
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"container.enchanted.spinning_wheel");
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(140, 80);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)EItems.SPINNING_WHEEL.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpinningRecipe recipe, IFocusGroup focuses) {
        class_2371<class_1799> inputs = recipe.getItemsIn();
        int[][] positions = new int[][]{{25, 13}, {13, 37}, {37, 37}};
        int pos = 0;
        for (class_1799 i : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, positions[pos][0], positions[pos][1]).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)i);
            ++pos;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 25).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)RecipeUtils.getResultItem(recipe));
    }

    public RecipeType<SpinningRecipe> getRecipeType() {
        return EJeiRecipeTypes.SPINNING;
    }
}

