/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.patchouli.components;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.registry.EBlocks;
import net.favouriteless.enchanted.common.util.Vector2i;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class RiteRequirementsComponent
implements ICustomComponent {
    public static final String PATH = "textures/patchouli/";
    public static final String FILE_END = ".png";
    public static final int IMAGE_SIZE = 110;
    public static final int TEXTURE_SIZE = 128;
    public static final float IMAGE_OFFSET = 55.0f;
    public static final HashMap<class_2248, String> BLOCK_IMAGES = new HashMap();
    public int startRadius;
    public float scale;
    public int itemsFirstCircle;
    @SerializedName(value="rite")
    public IVariable riteName;
    private transient BookTextRenderer powerTextRenderer;
    private transient RiteType rite;
    private final transient List<ItemRing> itemRings = new ArrayList<ItemRing>();
    private transient int x;
    private transient int y;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
        if (this.rite != null) {
            this.itemRings.clear();
            List<class_1799> items = this.rite.getItems();
            int index = 0;
            int currentItems = this.itemsFirstCircle;
            int currentRadius = this.startRadius;
            while (true) {
                List<class_1799> subList = items.subList(index, Math.min(items.size(), index + currentItems));
                this.itemRings.add(new ItemRing(subList, this.x, this.y, currentRadius, this.scale));
                if ((index += currentItems) >= items.size()) break;
                currentItems *= 2;
                currentRadius += 17;
            }
        }
    }

    public void render(class_332 guiGraphics, IComponentRenderContext context, float partialticks, int mouseX, int mouseY) {
        Object object;
        if (this.rite != null && (object = context.getGui()) instanceof GuiBook) {
            GuiBook gui = (GuiBook)object;
            this.renderCircles(guiGraphics);
            for (ItemRing ring : this.itemRings) {
                ring.render(guiGraphics, gui, mouseX, mouseY);
            }
            this.powerTextRenderer.render(guiGraphics, mouseX, mouseY);
        }
    }

    public void onDisplayed(IComponentRenderContext context) {
        class_437 gui = context.getGui();
        if (gui instanceof GuiBookEntry) {
            GuiBookEntry entry = (GuiBookEntry)gui;
            this.powerTextRenderer = new BookTextRenderer((GuiBook)entry, (class_2561)class_2561.method_43470((String)(this.rite.getPower() + " Power Required")), 2, 140, 116, 9, 0);
        }
    }

    private void renderCircles(class_332 guiGraphics) {
        class_4587 poseStack1 = guiGraphics.method_51448();
        poseStack1.method_22903();
        poseStack1.method_46416((float)this.x - 55.0f, (float)this.y - 55.0f, 0.0f);
        RenderSystem.enableBlend();
        guiGraphics.method_25290(Enchanted.id("textures/gui/jei/gold_glyph.png"), 0, 0, 0.0f, 0.0f, 110, 110, 128, 128);
        poseStack1.method_22909();
        for (Map.Entry<class_5321<CircleMagicShape>, class_2248> entry : this.rite.getShapes().entrySet()) {
            CircleMagicShape shapeKey = (CircleMagicShape)class_310.method_1551().field_1687.method_30349().method_30530(EData.CIRCLE_SHAPE_REGISTRY).method_29107(entry.getKey());
            if (shapeKey == null) {
                return;
            }
            class_2960 location = entry.getKey().method_29177();
            class_2960 texture = class_2960.method_43902((String)location.method_12836(), (String)String.format("textures/gui/circle_magic_shapes/%s_%s.png", location.method_12832(), class_7923.field_41175.method_10221((Object)entry.getValue()).method_12832()));
            if (!class_310.method_1551().method_1478().method_14486(texture).isPresent()) continue;
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416((float)this.x - 55.0f, (float)this.y - 55.0f, 0.0f);
            RenderSystem.enableBlend();
            guiGraphics.method_25290(texture, 0, 0, 0.0f, 0.0f, 110, 110, 128, 128);
            poseStack.method_22909();
        }
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        class_638 level = class_310.method_1551().field_1687;
        Optional optional = level.method_30349().method_33310(EData.RITE_TYPES_REGISTRY);
        RiteType riteType = this.rite = optional.isPresent() ? (RiteType)((class_2378)optional.get()).method_10223(new class_2960(((IVariable)lookup.apply(this.riteName)).asString())) : null;
        if (this.rite == null) {
            throw new IllegalStateException();
        }
    }

    static {
        BLOCK_IMAGES.put(EBlocks.RITUAL_CHALK.get(), "textures/patchouli/white");
        BLOCK_IMAGES.put(EBlocks.NETHER_CHALK.get(), "textures/patchouli/red");
        BLOCK_IMAGES.put(EBlocks.OTHERWHERE_CHALK.get(), "textures/patchouli/purple");
    }

    private static class ItemRing {
        private final List<class_1799> items;
        private final float scale;
        private final Vector2i[] scaledPositions;
        private final Vector2i[] absPositions;
        private final int itemSize;

        private ItemRing(List<class_1799> items, int x, int y, float radius, float scale) {
            this.items = items;
            this.itemSize = Math.round(16.0f * scale);
            this.scaledPositions = new Vector2i[items.size()];
            this.absPositions = new Vector2i[items.size()];
            this.scale = scale;
            this.recalculatePositions(x, y, radius);
        }

        private void recalculatePositions(int x, int y, float radius) {
            double xLocal = 0.0;
            double yLocal = -radius / this.scale;
            double angle = Math.toRadians(360.0 / (double)this.items.size());
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            for (int i = 0; i < this.scaledPositions.length; ++i) {
                this.scaledPositions[i] = new Vector2i((int)Math.round(xLocal + (double)((float)x / this.scale) - 8.0), (int)Math.round(yLocal + (double)((float)y / this.scale) - 8.0));
                this.absPositions[i] = new Vector2i((int)Math.round(xLocal * (double)this.scale + (double)x - (double)(8.0f * this.scale)), (int)Math.round(yLocal * (double)this.scale + (double)y - (double)(8.0f * this.scale)));
                class_243 newLocalPos = new class_243(cos * xLocal - sin * yLocal, sin * xLocal + cos * yLocal, 0.0);
                xLocal = newLocalPos.field_1352;
                yLocal = newLocalPos.field_1351;
            }
        }

        private void render(class_332 graphics, GuiBook gui, int mouseX, int mouseY) {
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_22905(this.scale, this.scale, this.scale);
            for (int i = 0; i < this.items.size(); ++i) {
                class_1799 item = this.items.get(i);
                Vector2i scaledPos = this.scaledPositions[i];
                Vector2i absPos = this.absPositions[i];
                class_310 mc = class_310.method_1551();
                graphics.method_51427(item, scaledPos.x, scaledPos.y);
                graphics.method_51431(mc.field_1772, item, scaledPos.x, scaledPos.y);
                if (!gui.isMouseInRelativeRange((double)mouseX, (double)mouseY, absPos.x, absPos.y, this.itemSize, this.itemSize)) continue;
                gui.setTooltipStack(item);
            }
            poseStack.method_22909();
        }
    }
}

