/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.helper;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class VoxelShapeHelper {
    public static class_265 combineAll(Collection<class_265> shapes) {
        class_265 result = class_259.method_1073();
        for (class_265 shape : shapes) {
            result = class_259.method_1072((class_265)result, (class_265)shape, (class_247)class_247.field_1366);
        }
        return result.method_1097();
    }

    public static class_265 combineAll(class_265 ... shapes) {
        class_265 result = class_259.method_1073();
        for (class_265 shape : shapes) {
            result = class_259.method_1072((class_265)result, (class_265)shape, (class_247)class_247.field_1366);
        }
        return result.method_1097();
    }

    public static Map<class_2350, class_265> getRotatedShapes(class_265 shape) {
        return Arrays.stream(class_2350.values()).collect(Collectors.toMap(Function.identity(), direction -> VoxelShapeHelper.rotateShape(shape, direction)));
    }

    public static Map<class_2350, class_265> getHorizontalRotatedShapes(class_265 shape) {
        return (Map)class_156.method_654(new EnumMap(class_2350.class), map -> {
            map.put(class_2350.field_11043, shape);
            map.put(class_2350.field_11034, VoxelShapeHelper.rotateShapeHorizontal(shape, class_2350.field_11034));
            map.put(class_2350.field_11035, VoxelShapeHelper.rotateShapeHorizontal(shape, class_2350.field_11035));
            map.put(class_2350.field_11039, VoxelShapeHelper.rotateShapeHorizontal(shape, class_2350.field_11039));
        });
    }

    public static class_265 rotateShape(class_265 shape, class_2350 direction) {
        ArrayList rotatedPieces = new ArrayList();
        class_243 vec3 = new class_243(-0.5, -0.5, -0.5);
        shape.method_1090().forEach(aabb -> {
            aabb = aabb.method_989(vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_238 rotated = switch (direction) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11033 -> aabb;
                case class_2350.field_11036 -> new class_238(aabb.field_1323, -aabb.field_1322, -aabb.field_1321, aabb.field_1320, -aabb.field_1325, -aabb.field_1324);
                case class_2350.field_11043 -> new class_238(aabb.field_1323, -aabb.field_1321, aabb.field_1322, aabb.field_1320, -aabb.field_1324, aabb.field_1325);
                case class_2350.field_11035 -> new class_238(-aabb.field_1323, -aabb.field_1321, -aabb.field_1322, -aabb.field_1320, -aabb.field_1324, -aabb.field_1325);
                case class_2350.field_11039 -> new class_238(aabb.field_1322, -aabb.field_1321, -aabb.field_1323, aabb.field_1325, -aabb.field_1324, -aabb.field_1320);
                case class_2350.field_11034 -> new class_238(-aabb.field_1322, -aabb.field_1321, aabb.field_1323, -aabb.field_1325, -aabb.field_1324, aabb.field_1320);
            };
            rotatedPieces.add(class_259.method_1078((class_238)rotated.method_989(-vec3.field_1352, -vec3.field_1350, -vec3.field_1350)));
        });
        return rotatedPieces.stream().reduce(class_259.method_1073(), class_259::method_1084);
    }

    public static class_265 rotateShapeHorizontal(class_265 shape, class_2350 direction) {
        ArrayList rotatedPieces = new ArrayList();
        class_243 vec3 = new class_243(-0.5, -0.5, -0.5);
        shape.method_1090().forEach(aabb -> {
            aabb = aabb.method_989(vec3.field_1352, vec3.field_1351, vec3.field_1350);
            class_238 rotated = switch (direction) {
                case class_2350.field_11043 -> aabb;
                case class_2350.field_11035 -> new class_238(-aabb.field_1323, aabb.field_1322, -aabb.field_1321, -aabb.field_1320, aabb.field_1325, -aabb.field_1324);
                case class_2350.field_11039 -> new class_238(aabb.field_1321, aabb.field_1322, -aabb.field_1323, aabb.field_1324, aabb.field_1325, -aabb.field_1320);
                case class_2350.field_11034 -> new class_238(-aabb.field_1321, aabb.field_1322, aabb.field_1323, -aabb.field_1324, aabb.field_1325, aabb.field_1320);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(direction));
            };
            rotatedPieces.add(class_259.method_1078((class_238)rotated.method_989(-vec3.field_1352, -vec3.field_1350, -vec3.field_1350)));
        });
        return rotatedPieces.stream().reduce(class_259.method_1073(), class_259::method_1084);
    }

    private static double[] adjustValues(class_2350 direction, double minX, double minZ, double maxX, double maxZ) {
        switch (direction) {
            case field_11039: {
                double temp_minX = minX;
                minX = 1.0 - maxX;
                double temp_minZ = minZ;
                minZ = 1.0 - maxZ;
                maxX = 1.0 - temp_minX;
                maxZ = 1.0 - temp_minZ;
                break;
            }
            case field_11043: {
                double temp_minX = minX;
                minX = minZ;
                minZ = 1.0 - maxX;
                maxX = maxZ;
                maxZ = 1.0 - temp_minX;
                break;
            }
            case field_11035: {
                double temp_minX = minX;
                minX = 1.0 - maxZ;
                double temp_minZ = minZ;
                minZ = temp_minX;
                double temp_maxX = maxX;
                maxX = 1.0 - temp_minZ;
                maxZ = temp_maxX;
            }
        }
        return new double[]{minX, minZ, maxX, maxZ};
    }

    public static EnumMap<class_2350.class_2351, class_265> rotateAxis(class_265 shape) {
        return new EnumMap<class_2350.class_2351, class_265>((Map<class_2350.class_2351, class_265>)ImmutableMap.of((Object)class_2350.class_2351.field_11052, (Object)shape, (Object)class_2350.class_2351.field_11048, (Object)VoxelShapeHelper.rotateAxis(shape, class_2350.class_2351.field_11048), (Object)class_2350.class_2351.field_11051, (Object)VoxelShapeHelper.rotateAxis(shape, class_2350.class_2351.field_11051)));
    }

    public static class_265 rotateAxis(class_265 shape, class_2350.class_2351 axis) {
        if (axis == class_2350.class_2351.field_11052) {
            return shape;
        }
        HashSet rotatedShapes = new HashSet();
        shape.method_1089((x1, y1, z1, x2, y2, z2) -> {
            y1 *= 16.0;
            y2 *= 16.0;
            x1 *= 16.0;
            x2 *= 16.0;
            z1 *= 16.0;
            z2 *= 16.0;
            if (axis == class_2350.class_2351.field_11048) {
                rotatedShapes.add(class_2248.method_9541((double)y1, (double)x1, (double)z1, (double)y2, (double)x2, (double)z2));
            } else {
                rotatedShapes.add(class_2248.method_9541((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2));
            }
        });
        return (class_265)rotatedShapes.stream().reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    }

    public static class_265 add(double x1, double y1, double z1, double x2, double y2, double z2, class_265 ... shapes) {
        HashSet result = new HashSet();
        for (class_265 shape : shapes) {
            shape.method_1089((x, y, z, x3, y3, z3) -> result.add(class_2248.method_9541((double)((x *= 16.0) + x1), (double)((y *= 16.0) + y1), (double)((z *= 16.0) + z1), (double)((x3 *= 16.0) + x2), (double)((y3 *= 16.0) + y2), (double)((z3 *= 16.0) + z2))));
        }
        return result.stream().reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).orElse(class_259.method_1073());
    }
}

