/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.DoNotCall;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7877;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryCollector;
import net.valhelsia.valhelsia_core.api.common.registry.helper.MappedRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.RegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.item.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.util.ResourceKeyHelper;

public record RegistryManager(String modId, ImmutableMap<class_5321<? extends class_2378<?>>, RegistryHelper<?, ? extends RegistryClass>> registryHelpers) {
    public RegistryManager(RegistryCollector collector) {
        this(collector.getModId(), collector.getHelpers());
    }

    public static RegistryManager constructEmpty(String modId) {
        return new RegistryManager(modId, ImmutableMap.of());
    }

    public <T> boolean hasHelper(class_5321<class_2378<T>> registryResourceKey) {
        return this.registryHelpers.containsKey(registryResourceKey);
    }

    public <T, H extends RegistryHelper<T, ?>> H getHelper(class_5321<class_2378<T>> registryResourceKey) {
        if (!this.hasHelper(registryResourceKey)) {
            throw new NullPointerException("Registry Manager for '" + this.modId() + "' has no Helper for registry: " + String.valueOf(registryResourceKey.method_29177()));
        }
        return (H)((RegistryHelper)this.registryHelpers.get(registryResourceKey));
    }

    public BlockRegistryHelper getBlockHelper() {
        return (BlockRegistryHelper)this.getHelper(class_7924.field_41254);
    }

    public ItemRegistryHelper getItemHelper() {
        return (ItemRegistryHelper)this.getHelper(class_7924.field_41197);
    }

    @DoNotCall
    public void register() {
        for (RegistryHelper registryHelper : this.registryHelpers.values()) {
            if (!(registryHelper instanceof MappedRegistryHelper)) continue;
            MappedRegistryHelper mappedRegistryHelper = (MappedRegistryHelper)registryHelper;
            registryHelper.getRegistryClasses().forEach(registryClass -> {
                try {
                    Class.forName(registryClass.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            mappedRegistryHelper.internalRegister();
        }
        if (this.hasHelper(class_7924.field_41197) && this.hasHelper(class_7924.field_41254)) {
            this.getItemHelper().registerBlockItems(this.getBlockHelper());
        }
    }

    public class_7877 buildRegistrySet() {
        class_7877 builder = new class_7877();
        for (RegistryHelper helper : this.registryHelpers.values()) {
            if (!(helper instanceof DatapackRegistryHelper)) continue;
            DatapackRegistryHelper datapackRegistryHelper = (DatapackRegistryHelper)helper;
            Function<class_7891, List> function = context -> datapackRegistryHelper.getClassCollector().collect((class_7891<?>)context);
            builder.method_46777(datapackRegistryHelper.getRegistry(), function::apply);
        }
        return builder;
    }

    public <T> ResourceKeyHelper<T> createKeyHelper(class_5321<? extends class_2378<T>> registry) {
        return new ResourceKeyHelper(registry, s -> class_2960.method_60655((String)this.modId(), (String)s));
    }
}

