/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry.helper;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.DoNotCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.valhelsia.valhelsia_core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.ValhelsiaRegistry;
import net.valhelsia.valhelsia_core.api.common.registry.helper.RegistryHelper;

public abstract class MappedRegistryHelper<T>
extends RegistryHelper<T, RegistryClass> {
    private final ValhelsiaRegistry<T> registry;
    private final ImmutableList<Class<?>> registryClasses;
    private final List<RegistryEntry<T, ? extends T>> entries = new ArrayList<RegistryEntry<T, ? extends T>>();

    public MappedRegistryHelper(class_5321<? extends class_2378<T>> registry, String modId, ImmutableList<Class<?>> registryClasses) {
        super(registry, modId);
        this.registry = ValhelsiaCore.INSTANCE.createRegistry(registry, modId);
        this.registryClasses = registryClasses;
    }

    public Collection<RegistryEntry<T, ? extends T>> getRegistryEntries() {
        return this.entries;
    }

    @DoNotCall
    public final void internalRegister() {
        this.registry.register();
    }

    public <O extends T> RegistryEntry<T, O> register(String name, Supplier<O> object) {
        return this.registerInternal(name, object);
    }

    public <O extends T, E extends RegistryEntry<T, O>> E registerInternal(String name, Supplier<O> object) {
        RegistryEntry<T, O> entry = this.registry.register(name, object, supplier -> this.createEntry(class_5321.method_29179(this.registry.getRegistryKey(), (class_2960)class_2960.method_60655((String)this.getModId(), (String)name))));
        this.entries.add(entry);
        return (E)entry;
    }

    protected abstract <O extends T> RegistryEntry<T, O> createEntry(class_5321<T> var1);

    @Override
    public ImmutableList<Class<?>> getRegistryClasses() {
        return this.registryClasses;
    }
}

