/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.world.structure.jigsaw;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5321;
import net.minecraft.class_5468;
import net.minecraft.class_5497;
import net.minecraft.class_5847;
import net.minecraft.class_6880;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class JigsawBuilder {
    private static final class_5321<class_5497> EMPTY_PROCESSOR_LIST = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)class_2960.method_60656((String)"empty"));
    private final class_5321<class_3785> key;
    @Nullable
    private final String folder;
    private final List<ElementInfo> elements = new ArrayList<ElementInfo>();
    private final class_7891<class_3785> context;
    private final ElementFunction elementFunction;
    private class_3785.class_3786 projection = class_3785.class_3786.field_16687;
    private class_5321<class_5497> processors = EMPTY_PROCESSOR_LIST;

    private JigsawBuilder(class_5321<class_3785> key, @Nullable String folder, class_7891<class_3785> context, @Nullable ElementFunction elementFunction) {
        this.key = key;
        this.folder = folder;
        this.context = context;
        this.elementFunction = Objects.requireNonNullElseGet(elementFunction, () -> (resourceLocation, holder, projection, terrainAdjustment) -> class_3784.method_30435((String)resourceLocation.toString(), (class_6880)holder));
    }

    public static JigsawBuilder builder(class_5321<class_3785> key, String folder, class_7891<class_3785> context, @Nullable ElementFunction elementFunction) {
        return new JigsawBuilder(key, folder, context, elementFunction);
    }

    public static JigsawBuilder builder(class_5321<class_3785> key, class_7891<class_3785> context, @Nullable ElementFunction elementFunction) {
        return new JigsawBuilder(key, null, context, elementFunction);
    }

    public JigsawBuilder projection(class_3785.class_3786 projection) {
        this.projection = projection;
        return this;
    }

    public JigsawBuilder element(String location) {
        return this.element(location, 1);
    }

    public JigsawBuilder element(String location, class_5847 terrainAdjustment) {
        return this.element(location, 1, terrainAdjustment);
    }

    public JigsawBuilder element(String location, int weight) {
        this.elements.add(ElementInfo.of((String)(this.folder != null ? this.folder + "/" + location : location), weight, null));
        return this;
    }

    public JigsawBuilder element(String location, int weight, class_5847 terrainAdjustment) {
        this.elements.add(ElementInfo.of((String)(this.folder != null ? this.folder + "/" + location : location), weight, terrainAdjustment));
        return this;
    }

    public JigsawBuilder processors(class_5321<class_5497> processors) {
        this.processors = processors;
        return this;
    }

    public void build(String modId, @Nullable class_5847 terrainAdjustment) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        class_6880.class_6883 processorListHolder = this.context.method_46799(class_7924.field_41247).method_46747(this.processors);
        class_6880.class_6883 fallbackPoolHolder = this.context.method_46799(class_7924.field_41249).method_46747(class_5468.field_26254);
        for (ElementInfo info : this.elements) {
            list.add(Pair.of(this.elementFunction.apply(class_2960.method_60655((String)modId, (String)info.location()), (class_6880<class_5497>)processorListHolder, this.projection, terrainAdjustment), (Object)info.weight));
        }
        this.context.method_46838(this.key, (Object)new class_3785((class_6880)fallbackPoolHolder, list, this.projection));
    }

    @FunctionalInterface
    public static interface ElementFunction {
        public Function<class_3785.class_3786, ? extends class_3784> apply(class_2960 var1, class_6880<class_5497> var2, class_3785.class_3786 var3, @Nullable class_5847 var4);
    }

    private record ElementInfo(String location, Integer weight, @Nullable class_5847 terrainAdjustment) {
        private static ElementInfo of(String location, Integer weight, @Nullable class_5847 terrainAdjustment) {
            return new ElementInfo(location, weight, terrainAdjustment);
        }
    }
}

