/*
 * Decompiled with CFR 0.152.
 */
package io.bendy1234.fasttrading.gui;

import io.bendy1234.fasttrading.FastTrading;
import io.bendy1234.fasttrading.ModKeyBindings;
import io.bendy1234.fasttrading.SpeedTradeTimer;
import io.bendy1234.fasttrading.duck.MerchantScreenHooks;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.class_10799;
import net.minecraft.class_11907;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class SpeedTradeButton
extends class_4264 {
    private static final class_2960 BUTTON_LOCATION = FastTrading.id("textures/gui/fasttrading.png");
    private static final class_2583 STYLE_GRAY = class_2583.field_24360.method_10977(class_124.field_1080);
    private final MerchantScreenHooks hooks;
    private Phase phase;

    public SpeedTradeButton(int x, int y, MerchantScreenHooks hooks) {
        super(x, y, 18, 20, (class_2561)class_2561.method_43473());
        this.hooks = hooks;
        this.phase = Phase.INACTIVE;
    }

    private boolean checkPrimed() {
        this.field_22763 = this.phase == Phase.INACTIVE && this.hooks.fasttrading$computeState() == MerchantScreenHooks.State.CAN_PERFORM && (ModKeyBindings.isDown(ModKeyBindings.keyOverrideBlock) || !this.hooks.fasttrading$isCurrentTradeOfferBlocked());
        return this.field_22763;
    }

    public void method_25306(class_11907 input) {
        if (this.checkPrimed()) {
            this.phase = Phase.AUTOFILL;
            SpeedTradeTimer.start();
        }
    }

    private boolean checkState() {
        if (this.hooks.fasttrading$computeState() != MerchantScreenHooks.State.CAN_PERFORM) {
            this.phase = Phase.INACTIVE;
            this.hooks.fasttrading$clearSellSlots();
            SpeedTradeTimer.stop();
            return false;
        }
        return true;
    }

    public void tick() {
        if (this.phase == Phase.INACTIVE) {
            this.checkPrimed();
            return;
        }
        this.field_22763 = false;
        while (SpeedTradeTimer.shouldDoAction()) {
            if (!this.checkState()) {
                return;
            }
            SpeedTradeTimer.onDoAction();
            if (this.phase == Phase.AUTOFILL) {
                this.hooks.fasttrading$autofillSellSlots();
                this.phase = Phase.TRADE;
                continue;
            }
            this.hooks.fasttrading$performTrade();
            this.phase = Phase.AUTOFILL;
        }
        this.checkState();
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int v = 36;
        if (this.checkPrimed()) {
            v = this.method_49606() ? 18 : 0;
        }
        context.method_25290(class_10799.field_56883, BUTTON_LOCATION, this.method_46426(), this.method_46427(), 0.0f, (float)v, 20, 18, 20, 54);
        this.applyTooltip();
    }

    protected void method_47399(class_6382 builder) {
    }

    protected void applyTooltip() {
        if (!this.method_49606()) {
            return;
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null) {
            return;
        }
        ArrayList<class_5481> textList = new ArrayList<class_5481>();
        if (this.phase != Phase.INACTIVE) {
            textList.add(class_2561.method_43471((String)"fasttrading.tooltip.in_progress").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1067, class_124.field_1056, class_124.field_1077})).method_30937());
        } else {
            MerchantScreenHooks.State state = this.hooks.fasttrading$computeState();
            if (state == MerchantScreenHooks.State.CAN_PERFORM) {
                boolean isBlocked = this.hooks.fasttrading$isCurrentTradeOfferBlocked();
                boolean isOverriden = ModKeyBindings.isDown(ModKeyBindings.keyOverrideBlock);
                if (isBlocked && !isOverriden) {
                    textList.add(class_2561.method_43471((String)"fasttrading.tooltip.cannot_perform").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1067, class_124.field_1061})).method_30937());
                    textList.add(class_2561.method_43471((String)"fasttrading.tooltip.blocked").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1056, class_124.field_1080})).method_30937());
                    if (ModKeyBindings.keyOverrideBlock.method_1415()) {
                        textList.add(class_2561.method_43469((String)"fasttrading.tooltip.unblock_hint.unbound[0]", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43471((String)ModKeyBindings.keyOverrideBlock.method_1428()).method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1068)))}).method_27694(style -> style.method_10977(class_124.field_1080)).method_30937());
                        textList.add(class_2561.method_43471((String)"fasttrading.tooltip.unblock_hint.unbound[1]").method_27694(style -> style.method_10977(class_124.field_1080)).method_30937());
                    } else {
                        textList.add(class_2561.method_43469((String)"fasttrading.tooltip.unblock_hint", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43471((String)ModKeyBindings.keyOverrideBlock.method_1428()).method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1068)))}).method_27694(style -> style.method_10977(class_124.field_1080)).method_30937());
                    }
                } else {
                    textList.add(class_2561.method_43471((String)"fasttrading.tooltip.can_perform").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1067, class_124.field_1060})).method_30937());
                    if (isBlocked) {
                        textList.add(class_2561.method_43471((String)"fasttrading.tooltip.can_perform.unblock_hint").method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)).method_30937());
                    }
                }
            } else {
                textList.add(class_2561.method_43471((String)"fasttrading.tooltip.cannot_perform").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1067, class_124.field_1061})).method_30937());
                textList.add(class_2561.method_43471((String)("fasttrading.tooltip." + state.name().toLowerCase(Locale.ROOT))).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1056, class_124.field_1080})).method_30937());
            }
            textList.add(class_2561.method_43473().method_30937());
            this.appendTradeDescription(this.hooks.fasttrading$getCurrentTradeOffer(), textList);
        }
        class_7919 tt = class_7919.method_47407(null);
        tt.field_41103 = textList;
        tt.field_51822 = class_2477.method_10517();
        this.method_47400(tt);
    }

    private void appendTradeDescription(class_1914 offer, ArrayList<class_5481> destList) {
        if (offer == null) {
            return;
        }
        class_1799 originalFirstBuyItem = offer.method_8246();
        class_1799 adjustedFirstBuyItem = offer.method_19272();
        class_1799 secondBuyItem = offer.method_8247();
        class_1799 sellItem = offer.method_8250();
        destList.add(class_2561.method_43471((String)"fasttrading.tooltip.current_trade.is").method_27694(style -> style.method_10977(class_124.field_1080)).method_30937());
        destList.add(this.createItemStackDescription(originalFirstBuyItem, adjustedFirstBuyItem).method_27696(STYLE_GRAY).method_30937());
        if (!secondBuyItem.method_7960()) {
            destList.add(class_2561.method_43469((String)"fasttrading.tooltip.current_trade.and", (Object[])new Object[]{this.createItemStackDescription(secondBuyItem)}).method_27696(STYLE_GRAY).method_30937());
        }
        destList.add(class_2561.method_43469((String)"fasttrading.tooltip.current_trade.for", (Object[])new Object[]{this.createItemStackDescription(sellItem)}).method_27696(STYLE_GRAY).method_30937());
    }

    private class_5250 createItemStackDescription(class_1799 stack, class_1799 adjustedStack) {
        if (stack.method_7947() == adjustedStack.method_7947()) {
            return this.createItemStackDescription(stack);
        }
        return this.getItemStackName(stack).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)("x" + stack.method_7947())).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1055, class_124.field_1061}))).method_10852((class_2561)class_2561.method_43470((String)(" x" + adjustedStack.method_7947())).method_27694(style -> style.method_27705(new class_124[]{class_124.field_1067, class_124.field_1060})));
    }

    private class_5250 createItemStackDescription(class_1799 stack) {
        return this.getItemStackName(stack).method_10852((class_2561)class_2561.method_43470((String)(" x" + stack.method_7947())));
    }

    private class_5250 getItemStackName(class_1799 stack) {
        return class_2564.method_10885((class_2561)class_2561.method_43470((String)"").method_10852(stack.method_7964()).method_27694(style -> style.method_27706(stack.method_7932().method_58413())));
    }

    public static enum Phase {
        INACTIVE,
        AUTOFILL,
        TRADE;

    }
}

