/*
 * Decompiled with CFR 0.152.
 */
package io.bendy1234.fasttrading.mixin;

import io.bendy1234.fasttrading.config.ModConfig;
import io.bendy1234.fasttrading.duck.MerchantScreenHooks;
import io.bendy1234.fasttrading.gui.SpeedTradeButton;
import io.bendy1234.fasttrading.util.PlayerInventoryUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_492;
import net.minecraft.class_9306;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_492.class})
public abstract class MerchantScreenMixin
extends class_465<class_1728>
implements MerchantScreenHooks {
    @Shadow
    private int field_19161;
    @Unique
    private class_1661 playerInventory;
    @Unique
    private SpeedTradeButton speedTradeButton;

    public MerchantScreenMixin() {
        super(null, null, null);
        throw new RuntimeException("Mixin constructor called?!");
    }

    @Shadow
    protected abstract void method_2496();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void capturePlayerInventory(class_1728 handler, class_1661 inventory, class_2561 title, CallbackInfo ci) {
        this.playerInventory = inventory;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void addSpeedTradeButton(CallbackInfo ci) {
        this.speedTradeButton = new SpeedTradeButton(this.field_2776 + 247, this.field_2800 + 36, this);
        this.method_37063((class_364)this.speedTradeButton);
    }

    @Override
    public MerchantScreenHooks.State fasttrading$computeState() {
        if (this.field_22787 == null || this.field_22787.field_1755 != this) {
            return MerchantScreenHooks.State.CLOSED;
        }
        class_1914 offer = this.fasttrading$getCurrentTradeOffer();
        if (offer == null) {
            return MerchantScreenHooks.State.NO_SELECTION;
        }
        if (offer.method_8255()) {
            return MerchantScreenHooks.State.OUT_OF_STOCK;
        }
        class_1799 sellItem = offer.method_8250();
        if (!PlayerInventoryUtil.playerCanAcceptStack(this.playerInventory, sellItem)) {
            return MerchantScreenHooks.State.NO_ROOM_FOR_SELL_ITEM;
        }
        if (((class_1728)this.field_2797).method_7611(2).method_7681() || PlayerInventoryUtil.playerCanPerformTrade(this.playerInventory, offer)) {
            return MerchantScreenHooks.State.CAN_PERFORM;
        }
        return MerchantScreenHooks.State.NOT_ENOUGH_BUY_ITEMS;
    }

    @Override
    public class_1914 fasttrading$getCurrentTradeOffer() {
        class_1916 tradeOffers = ((class_1728)this.field_2797).method_17438();
        if (this.field_19161 < 0 || this.field_19161 >= tradeOffers.size()) {
            return null;
        }
        return (class_1914)tradeOffers.get(this.field_19161);
    }

    @Override
    public boolean fasttrading$isCurrentTradeOfferBlocked() {
        class_1914 offer = this.fasttrading$getCurrentTradeOffer();
        if (offer == null) {
            return false;
        }
        return ModConfig.tradeBlockBehavior.isBlocked(offer.method_8250());
    }

    @Override
    public void fasttrading$autofillSellSlots() {
        switch (ModConfig.autofillBehavior) {
            case DEFAULT: {
                this.method_2496();
                break;
            }
            case STRICT: {
                this.fasttrading$clearSellSlots();
                class_1914 recipe = (class_1914)((class_1728)this.field_2797).method_17438().get(this.field_19161);
                this.fillSlot(0, recipe.method_57556().comp_2427());
                if (!recipe.method_57557().isPresent()) break;
                this.fillSlot(1, ((class_9306)recipe.method_57557().get()).comp_2427());
            }
        }
    }

    @Override
    public void fasttrading$performTrade() {
        class_1735 resultSlot = ((class_1728)this.field_2797).method_7611(2);
        if (!resultSlot.method_7677().method_7960()) {
            this.method_2383(resultSlot, -1, 0, class_1713.field_7794);
        }
    }

    @Override
    public void fasttrading$clearSellSlots() {
        this.method_2383(null, 0, 0, class_1713.field_7794);
        this.method_2383(null, 1, 0, class_1713.field_7794);
    }

    protected void method_37432() {
        super.method_37432();
        this.speedTradeButton.tick();
    }

    @Unique
    private void fillSlot(int slot, class_1799 item) {
        int count = 0;
        for (int i = 3; i < 39; ++i) {
            class_1799 invstack = ((class_1728)this.field_2797).method_7611(i).method_7677();
            if (!class_1799.method_31577((class_1799)item, (class_1799)invstack)) continue;
            this.method_2383(null, i, 0, class_1713.field_7790);
            this.method_2383(null, slot, 0, class_1713.field_7790);
            if ((count += invstack.method_7947()) > ((class_1728)this.field_2797).method_7611(slot).method_7677().method_7914()) {
                this.method_2383(null, i, 0, class_1713.field_7790);
                return;
            }
            if (count != ((class_1728)this.field_2797).method_7611(slot).method_7677().method_7914()) continue;
            return;
        }
    }
}

