/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.letmeclickandsendforserver;

import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Optional;
import me.fallenbreath.letmeclickandsendforserver.LetMeClickAndSendForServerMod;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.Nullable;

public class TextClickEventReplacer {
    private static final int MAX_QUEUE_ITERATIONS = 100000;

    public static void replaceInPlace(ITextComponent root) {
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(root);
        int cnt = 0;
        while (!queue.isEmpty()) {
            if (++cnt >= 100000 || queue.size() >= 100000) {
                LetMeClickAndSendForServerMod.LOGGER.warn("Max queue iteration {} exceeded, queue size {}", (Object)100000, (Object)queue.size());
                break;
            }
            ITextComponent text = (ITextComponent)queue.poll();
            Style style = text.func_150256_b();
            if (text instanceof IFormattableTextComponent) {
                IFormattableTextComponent mutableText = (IFormattableTextComponent)text;
                TextClickEventReplacer.replaceClickEvent(style.func_150235_h()).ifPresent(e -> mutableText.func_230530_a_(style.func_240715_a_(e)));
            }
            queue.addAll(text.func_150253_a());
        }
    }

    private static Optional<ClickEvent> replaceClickEvent(@Nullable ClickEvent event) {
        if (event == null || event.func_150669_a() != ClickEvent.Action.RUN_COMMAND) {
            return Optional.empty();
        }
        String command = event.func_150668_b();
        if (command.isEmpty() || command.startsWith("/")) {
            return Optional.empty();
        }
        String newValue = "/lmcas " + command;
        return Optional.of(new ClickEvent(event.func_150669_a(), newValue));
    }
}

