/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.RewardItemStack;
import project.studio.manametalmod.core.SP;
import project.studio.manametalmod.core.TextEncryption;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;

public final class WitheGoldList {
    private static final Map<String, SP> SPLIST = new HashMap<String, SP>();
    private static final Map<String, ArrayList<RewardItemStack>> OnlineStoreInventory = new HashMap<String, ArrayList<RewardItemStack>>();
    private static final Map<Integer, ItemStack> OnlineStoreTable = new HashMap<Integer, ItemStack>();
    public static SP clientSP = new SP();
    public static int clientMaxGold = 0;
    public static final List<RewardItemStack> OfflineStoreInventory = new ArrayList<RewardItemStack>();
    private static final String key = "SyVGG7tR6J4kDGEqW25SCq/PVUtfzwZEx2BHtDaG8926xWLzTBBdUhgnM0mM++RU";

    public static final int getTableItemID(ItemStack item) {
        for (Map.Entry<Integer, ItemStack> entry : OnlineStoreTable.entrySet()) {
            if (!MMM.isItemStackEqualNoNBT(item, entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static final ArrayList<RewardItemStack> getOnlineStore(String player) {
        if (OnlineStoreInventory.containsKey(player)) {
            return OnlineStoreInventory.get(player);
        }
        return null;
    }

    public static final void updateQuarkNetdisc(String playerID) {
        if (M3Config.QuarkNetdisc) {
            // empty if block
        }
    }

    public static void parsingOnlineStoreTable() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    OnlineStoreTable.clear();
                    String targetUrl = "https://www.manametal.net/api/cashshop/webinventory.php?list=2";
                    URL url = new URL(targetUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("User-agent", "IE/11.0");
                    connection.setRequestProperty("Accept", "application/json; charset=utf-8");
                    int responseCode = connection.getResponseCode();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    connection.disconnect();
                    String encryptedDataWithIv = sb.toString();
                    byte[] decodedBytes = Base64.getDecoder().decode(encryptedDataWithIv);
                    if (decodedBytes.length <= 16) {
                        return;
                    }
                    byte[] iv = Arrays.copyOfRange(decodedBytes, 0, 16);
                    byte[] encryptedData = Arrays.copyOfRange(decodedBytes, 16, decodedBytes.length);
                    MessageDigest digest = MessageDigest.getInstance("SHA-256");
                    byte[] hashedKey = digest.digest(WitheGoldList.key.getBytes(StandardCharsets.UTF_8));
                    byte[] aesKey = Arrays.copyOf(hashedKey, 16);
                    SecretKeySpec secretKey = new SecretKeySpec(aesKey, "AES");
                    IvParameterSpec ivSpec = new IvParameterSpec(iv);
                    Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    cipher.init(2, (Key)secretKey, ivSpec);
                    byte[] decryptedBytes = cipher.doFinal(encryptedData);
                    String jsonString = new String(decryptedBytes, StandardCharsets.UTF_8);
                    Pattern itemPattern = Pattern.compile("\"(\\d+)\":\"([^\"]+)\"");
                    Matcher itemMatcher = itemPattern.matcher(jsonString);
                    if (MMM.DEBUG()) {
                        MMM.Logg("parsing online store table");
                    }
                    while (itemMatcher.find()) {
                        ItemStack tempitem;
                        String[] array;
                        int id = Integer.parseInt(itemMatcher.group(1));
                        String item = itemMatcher.group(2);
                        if (item == null || (array = item.split(":")).length != 3 || (tempitem = MMM.findItemStack(array[1], array[0], 1, Integer.parseInt(array[2]))) == null) continue;
                        OnlineStoreTable.put(id, tempitem);
                        if (!MMM.DEBUG()) continue;
                        MMM.Logg("parsing item : " + tempitem.func_82833_r());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setName("OnlineStoreTable");
        thread.start();
    }

    public static final void onPlayerLoggedInEvent(EntityPlayer player, ManaMetalModRoot root) {
        if (M3Config.OnlineWhiteGold) {
            WitheGoldList.getWhitegoldSQL(player.func_70005_c_(), root);
        }
        if (!M3Config.OnlineWhiteGold && SPLIST.containsKey(player.func_70005_c_())) {
            SP sp = SPLIST.get(player.func_70005_c_());
            WitheGoldList.givePlayerWhiteGold(root.carrer.getPlayer(), root, sp.getWhiteGold());
        }
    }

    public static final void givePlayerWhiteGold(EntityPlayer player, ManaMetalModRoot root, int spWhiteGold) {
        if (spWhiteGold > 0 && root.money.getSponsorAncientStone() < spWhiteGold) {
            int add = spWhiteGold - root.money.getSponsorAncientStone();
            root.money.addAncientStone(add);
            root.money.setSponsorAncientStone(spWhiteGold);
            MMM.addMessage(root.carrer.getPlayer(), "MMM.info.AncientStoneSponsor", spWhiteGold);
            MMM.Logg(player + " get the " + spWhiteGold + " ancient stone from online sponsor base");
            return;
        }
    }

    public static int getWhitegoldOnline(String player) {
        if (SPLIST.containsKey(player)) {
            return SPLIST.get(player).getWhiteGold();
        }
        return 0;
    }

    public static final SP.LV getSPLV(String name, SP.SSeason type) {
        if (SPLIST.containsKey(name)) {
            SP data = SPLIST.get(name);
            return data.getSeasonTier(type);
        }
        return SP.LV.Tier0;
    }

    public static final boolean hasLV(String name, SP.SSeason season, SP.LV lv, boolean client) {
        SP data;
        if (client) {
            return clientSP.getSeasonTier(season).ordinal() >= lv.ordinal();
        }
        return SPLIST.containsKey(name) && (data = SPLIST.get(name)).getSeasonTier(season).ordinal() >= lv.ordinal();
    }

    public static void showPlayerData(String player) {
        System.out.println("show player data : " + player + "\r\n");
        if (SPLIST.containsKey(player)) {
            SP sp = SPLIST.get(player);
            System.out.println("total whitegold >  : " + sp.getWhiteGold());
            for (int s = 0; s < SP.SeasonSponsorCount; ++s) {
                System.out.println("test whitegold >  : " + SP.SSeason.values()[s].toString() + " : tier : " + (Object)((Object)sp.getSeasonTier(SP.SSeason.values()[s])));
            }
        } else {
            System.out.println("no data");
        }
    }

    public static void showAllData() {
        System.out.println("show all data \r\n");
        for (Map.Entry<String, SP> entry : SPLIST.entrySet()) {
            SP sp = entry.getValue();
            System.out.println("data name : " + entry.getKey().toString() + " total whitegold > : " + sp.getWhiteGold());
            for (int s = 0; s < SP.SeasonSponsorCount; ++s) {
                if (sp.getSeasonTier(SP.SSeason.values()[s]) == SP.LV.Tier0) continue;
                System.out.println("type : " + SP.SSeason.values()[s].toString() + " LV : " + (Object)((Object)sp.getSeasonTier(SP.SSeason.values()[s])));
            }
            System.out.println("  \r\n");
        }
    }

    public static SP.SSeason hasSeasonType(String name) {
        for (int s = 0; s < SP.SSeason.seasons.length; ++s) {
            if (!SP.SSeason.seasons[s].toString().equals(name)) continue;
            return SP.SSeason.seasons[s];
        }
        return SP.SSeason.Normal;
    }

    public static int[] getLVData(SP.SSeason type) {
        switch (type) {
            case FF43: {
                return new int[]{500, 500, 500, 500, 500};
            }
            case Anok: 
            case RLuo: 
            case RedMoon: {
                return new int[]{600, 1200, 2800, 4800, 4800};
            }
            case S1: 
            case S2: 
            case S3: 
            case S4: 
            case S5: 
            case S6: 
            case S7: 
            case S8: 
            case S2_8th: 
            case S6_8th: 
            case S9: {
                return new int[]{480, 1200, 2800, 6000, 6000};
            }
            case An_8th: {
                return new int[]{240, 600, 1200, 3000, 3000};
            }
            case S10: {
                return new int[]{480, 1200, 2800, 4000, 6000};
            }
            case GS2: {
                return new int[]{1000, 1000, 1000, 1000, 1000};
            }
            case S11: 
            case S12: 
            case S13: {
                return new int[]{480, 1200, 2800, 4000, 6000};
            }
            case S9_9th: {
                return new int[]{480, 1200, 2800, 6000, 6000};
            }
            case An_9th: {
                return new int[]{240, 480, 1200, 2800, 4800};
            }
        }
        return null;
    }

    public static SP.LV getLV(int data, SP.SSeason type) {
        int[] temp = WitheGoldList.getLVData(type);
        if (temp != null) {
            if (data >= temp[4]) {
                return SP.LV.Tier5;
            }
            if (data >= temp[3]) {
                return SP.LV.Tier4;
            }
            if (data >= temp[2]) {
                return SP.LV.Tier3;
            }
            if (data >= temp[1]) {
                return SP.LV.Tier2;
            }
            if (data >= temp[0]) {
                return SP.LV.Tier1;
            }
        }
        return SP.LV.Tier0;
    }

    public static final void analyzeOffline() {
        if (!M3Config.OnlineWhiteGold) {
            try {
                String text;
                String fileContent = TextEncryption.readFileFromJar();
                if (fileContent != null && (text = TextEncryption.decrypt(fileContent)) != null) {
                    SPLIST.clear();
                    String[] data = text.split(";");
                    for (int s = 0; s < data.length; ++s) {
                        if (data[s].contains("$M3$") || data[s].contains("(,)")) continue;
                        String[] temp = data[s].split(",");
                        String ID = temp[0].replace("(", "");
                        int gold = Integer.parseInt(temp[1]);
                        String key = temp[2].replace(")", "");
                        SP.SSeason season = WitheGoldList.hasSeasonType(key);
                        if (season != null) {
                            SP sp;
                            if (season == SP.SSeason.Costed) {
                                if (SPLIST.containsKey(ID)) {
                                    sp = SPLIST.get(ID);
                                    sp.setSeasonTier(season.ordinal(), SP.LV.Tier0);
                                } else {
                                    sp = new SP();
                                    sp.setSeasonTier(season.ordinal(), SP.LV.Tier0);
                                    SPLIST.put(ID, sp);
                                }
                            } else if (SPLIST.containsKey(ID)) {
                                sp = SPLIST.get(ID);
                                sp.setSeasonTier(season.ordinal(), WitheGoldList.getLV(gold, season));
                                sp.addWhiteGold(gold);
                            } else {
                                sp = new SP();
                                sp.setSeasonTier(season.ordinal(), WitheGoldList.getLV(gold, season));
                                sp.addWhiteGold(gold);
                                SPLIST.put(ID, sp);
                            }
                        }
                        if (!M3Config.DEBUG) continue;
                        System.out.println("parse target  : " + s + " : " + data[s] + " type : " + key + " gold : " + gold + " ID : " + ID);
                        System.out.println("  \r\n");
                    }
                    for (Map.Entry<String, SP> entry : SPLIST.entrySet()) {
                        entry.getValue().lock();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("analyze offline whitegold fail");
                System.out.println("  \r\n");
            }
        }
    }

    public static void parse(String target, String player, ManaMetalModRoot root) {
        if (target != null) {
            try {
                String[] data = target.split(";");
                if (data != null && data.length > 0) {
                    SP sp = new SP();
                    for (int s = 0; s < data.length; ++s) {
                        SP.SSeason season;
                        if (data[s].contains("$M3$") || data[s].contains("(,)")) continue;
                        if (M3Config.DEBUG) {
                            System.out.println("parse target  : " + s + " : " + data[s]);
                        }
                        String[] temp = data[s].split(",");
                        String key = temp[1].replace(")", "");
                        int gold = Integer.parseInt(temp[0].replace("(", ""));
                        if (M3Config.DEBUG) {
                            System.out.println("key : " + key + " / gold : " + gold);
                        }
                        if ((season = WitheGoldList.hasSeasonType(key)) != null) {
                            if (season == SP.SSeason.Costed) {
                                sp.setSeasonTier(season.ordinal(), SP.LV.Tier0);
                            } else {
                                sp.setSeasonTier(season.ordinal(), WitheGoldList.getLV(gold, season));
                                sp.addWhiteGold(gold);
                            }
                            if (M3Config.DEBUG) {
                                System.out.println(player + " whitegole  : " + gold + " type : " + season.toString() + " LV : " + WitheGoldList.getLV(gold, season).toString());
                            }
                        }
                        if (!M3Config.DEBUG) continue;
                        System.out.println("  \r\n");
                    }
                    sp.lock();
                    SPLIST.put(player, sp);
                    if (root != null) {
                        WitheGoldList.givePlayerWhiteGold(root.carrer.getPlayer(), root, sp.getWhiteGold());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void playerInventory(String player) {
        BufferedReader reader = null;
        URLConnection connection = null;
        try {
            if (MMM.DEBUG()) {
                MMM.Logg("analyze player inventory : " + player);
            }
            String targetUrl = "https://www.manametal.net/api/cashshop/webinventory.php?id=" + player;
            URL url = new URL(targetUrl);
            connection = (HttpURLConnection)url.openConnection();
            ((HttpURLConnection)connection).setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setRequestProperty("User-agent", "IE/11.0");
            connection.setRequestProperty("Accept", "application/json; charset=utf-8");
            int responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode == 200) {
                String jsonString;
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                while ((jsonString = reader.readLine()) != null) {
                    if (!jsonString.startsWith("{\"time\":") || !jsonString.contains("}")) continue;
                    ArrayList<RewardItemStack> list = new ArrayList<RewardItemStack>();
                    OnlineStoreInventory.put(player, list);
                    jsonString = jsonString.replace("{", "").replace("}", "");
                    String[] array = jsonString.split(",");
                    for (int s = 1; s < array.length; ++s) {
                        String[] temp = array[s].split(":");
                        int ID = Integer.parseInt(temp[0].replace("\"", ""));
                        int count = Integer.parseInt(temp[1].replace("\"", ""));
                        if (!OnlineStoreTable.containsKey(ID)) continue;
                        ItemStack item = OnlineStoreTable.get(ID).func_77946_l();
                        item.field_77994_a = 1;
                        RewardItemStack RIS = new RewardItemStack(item).setCount(count);
                        list.add(RIS);
                    }
                }
            }
            reader.close();
            ((HttpURLConnection)connection).disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (reader != null) {
                    reader.close();
                }
                if (connection != null) {
                    connection.connect();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void getWhitegoldSQL(final String player, final ManaMetalModRoot root) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    String urltextSP = "https://www.manametal.net/m3data/cash.php?item=" + player;
                    URL url = new URL(urltextSP);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-agent", "IE/11.0");
                    connection.setRequestProperty("Accept", "application/json; charset=utf-8");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    while ((line = reader.readLine()) != null) {
                        if (M3Config.DEBUG) {
                            System.out.println(line);
                            System.out.println("  \r\n");
                        }
                        if (!line.contains("$M3$")) continue;
                        WitheGoldList.parse(line, player, root);
                    }
                    connection.disconnect();
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setName("WhiteGold");
        thread.start();
    }
}

