/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.api.addon.thaumcraft;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.magic.ManaElements;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.entities.monster.EntityInhabitedZombie;
import thaumcraft.common.entities.monster.boss.EntityCultistPortal;
import thaumcraft.common.entities.monster.boss.EntityTaintacleGiant;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import tw.pearki.mcmod.muya.event.EntityLivingPotionEvent;

public class ThaumcraftMobs {
    public static final void ThaumcraftBossRemoveSpeed(EntityLivingBase target, EntityLivingPotionEvent event) {
        if ((target instanceof EntityThaumcraftBoss || target instanceof EntityTaintacleGiant) && event.effect.func_76456_a() == 1) {
            event.setCanceled(true);
        }
    }

    public static final boolean ThaumcraftMobsBossData(EntityLivingBase target) {
        ManaMetalModRoot root = MMM.getEntityNBT(target);
        if (root == null) {
            MMM.warning("can't set entity world data");
            return false;
        }
        AttackEffect data = new AttackEffect();
        int LV2 = 0;
        int HP = 0;
        ManaElements ManaElement = ManaElements.Dark;
        if (target instanceof EntityCultist) {
            HP = 450;
            LV2 = 20;
            ManaElement = ManaElements.Dark;
            data.penetration_base = 5;
            data.attack_base = 150;
        }
        if (target instanceof EntityBrainyZombie) {
            HP = 200;
            data.attack_base = 80;
        }
        if (target instanceof EntityFireBat) {
            HP = 100;
            data.attack_base = 100;
        }
        if (target instanceof EntityThaumcraftBoss) {
            HP = 450000;
            LV2 = 50;
            ManaElement = ManaElements.Dark;
            data.penetration_base = 40;
            data.attack_base = 6000;
        }
        if (target instanceof EntityTaintacleGiant) {
            HP = 450000;
            LV2 = 50;
            ManaElement = ManaElements.Dark;
            data.penetration_base = 40;
            data.attack_base = 6000;
        }
        if (target instanceof EntityCultistPortal) {
            HP = 500000;
            LV2 = 50;
            ManaElement = ManaElements.Fire;
            data.penetration_base = 100;
            data.attack_base = 0;
        }
        if (target.getClass() == EntityEldritchCrab.class) {
            HP = 7500;
            LV2 = 40;
            ManaElement = ManaElements.Water;
            data.penetration_base = 20;
            data.attack_base = 2800;
        }
        if (target instanceof EntityInhabitedZombie) {
            HP = 3500;
            LV2 = 40;
            ManaElement = ManaElements.Fire;
            data.penetration_base = 20;
            data.attack_base = 2000;
        }
        if (MMM.getDimensionID(target.field_70170_p) == Config.dimensionOuterId) {
            if (target.getClass() == EntityEldritchGuardian.class) {
                HP = 25000;
                LV2 = 40;
                ManaElement = ManaElements.Dark;
                data.penetration_base = 20;
                data.attack_base = 2000;
            }
        } else if (target.getClass() == EntityEldritchGuardian.class) {
            HP = 1500;
            LV2 = 20;
            ManaElement = ManaElements.Dark;
            data.attack_base = 150;
        }
        if (LV2 > 0) {
            root.ManaEntityData.setPenetrationDefense(data.penetration_base);
            root.ManaEntityData.attack_damage += data.attack_base;
            root.ManaEntityData.setLV(LV2);
            root.ManaEntityData.Element = ManaElement;
            HashMultimap attributes = HashMultimap.create();
            attributes.clear();
            attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "EventEnemyFair", (double)HP, 0));
            target.func_110140_aT().func_111147_b((Multimap)attributes);
            target.func_70606_j(target.func_110138_aP());
            target.getEntityData().func_74778_a("EventEnemyFair", "EventEnemyFair");
            root.ManaEntityData.send();
            return true;
        }
        return false;
    }
}

