/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.autocrystal;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.autocrystal.AutoCrystalEffect;
import project.studio.manametalmod.blocks.BlockTileEntitySafeChest;
import project.studio.manametalmod.core.MultipleItemStack;
import project.studio.manametalmod.defensive_tower.TileEntityDefensiveTower;
import project.studio.manametalmod.produce.casting.TileEntityEquipmentDismantle;
import project.studio.manametalmod.rpg.TileEntityWeaponScroll;
import project.studio.manametalmod.tileentity.TileEntityCrystalZ;
import project.studio.manametalmod.tileentity.TileEntityManaCraftTable;
import project.studio.manametalmod.tileentity.TileEntityManaOreDictionary;
import project.studio.manametalmod.tileentity.TileEntityMetalCraftTable;
import project.studio.manametalmod.tileentity.TileEntityPlayerStore;
import project.studio.manametalmod.tileentity.TileEntityPowerCrystalBase;

public enum AutoCrystal {
    unknow,
    setBlock,
    moveBlock,
    setItem,
    moveItem,
    collect,
    breakBlock,
    tree,
    agriculture,
    fish,
    craft,
    animal;


    public static boolean stickItemFoodRoot(IInventory targetInventory, ItemStack item, World world) {
        if (MMM.isFoodRoot(item)) {
            int size;
            item.field_77994_a = size = MMM.insertItemStackFoodToIInventory(item, targetInventory, world);
            return size <= 0;
        }
        return MMM.tryInsertStack(targetInventory, item);
    }

    public static boolean canEffect(TileEntity tile) {
        Class<?> classs = tile.getClass();
        if (tile.func_145838_q() instanceof BlockTileEntitySafeChest) {
            return false;
        }
        if (tile.getClass() == TileEntityManaOreDictionary.class) {
            return false;
        }
        if (tile.getClass() == TileEntityPowerCrystalBase.class) {
            return false;
        }
        if (tile.getClass() == TileEntityWeaponScroll.class) {
            return false;
        }
        if (tile.getClass() == TileEntityDefensiveTower.class) {
            return false;
        }
        if (tile.getClass() == TileEntityManaCraftTable.class) {
            return false;
        }
        if (tile.getClass() == TileEntityMetalCraftTable.class) {
            return false;
        }
        if (tile.getClass() == TileEntityPlayerStore.class) {
            return false;
        }
        if (tile.getClass() == TileEntityEquipmentDismantle.class) {
            return false;
        }
        if (classs.getName().contains("TileEntityBarrel")) {
            return false;
        }
        if (classs.getName().contains("storagedrawers")) {
            return false;
        }
        if (classs.getName().contains("TileStrongbox")) {
            return false;
        }
        if (classs.getName().contains("TileStrongboxCreative")) {
            return false;
        }
        return !classs.getName().contains("TileCache");
    }

    public boolean hasItems(MultipleItemStack[] data) {
        for (int s = 0; s < data.length; ++s) {
            if (data[s] == null || data[s].getItem(0) == null) continue;
            return true;
        }
        return false;
    }

    public static List<IRecipe> findRecipeNONBT(ItemStack item) {
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        int size = CraftingManager.func_77594_a().func_77592_b().size();
        for (int s = 0; s < size; ++s) {
            ItemStack recipeResult;
            IRecipe tmpRecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(s);
            if (!(tmpRecipe instanceof ShapelessRecipes) && !(tmpRecipe instanceof ShapelessOreRecipe) && !(tmpRecipe instanceof ShapedRecipes) && !(tmpRecipe instanceof ShapedOreRecipe) || !MMM.isItemStackEqualNoNBT(item, recipeResult = tmpRecipe.func_77571_b())) continue;
            list.add(tmpRecipe);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public Object getItemFromRecipe(IRecipe tmpRecipe) {
        if (tmpRecipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)tmpRecipe).field_77579_b;
        }
        if (tmpRecipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)tmpRecipe).getInput();
        }
        if (tmpRecipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)tmpRecipe).field_77574_d;
        }
        if (tmpRecipe instanceof ShapedOreRecipe) {
            return ((ShapedOreRecipe)tmpRecipe).getInput();
        }
        return null;
    }

    public boolean advancedCheck(IInventory box, Object obj, boolean isclear, TileEntityCrystalZ tile) {
        if (obj instanceof ItemStack[]) {
            ItemStack[] items = (ItemStack[])obj;
            for (int s = 0; s < items.length; ++s) {
                if (items[s] == null || !(isclear ? !this.clearBoxItems(items[s], box, tile) : !this.hasItemStackNoNBT(items[s], box))) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof List) {
            List items = (List)obj;
            for (int s = 0; s < items.size(); ++s) {
                Object temp = items.get(s);
                if (temp == null) continue;
                if (temp instanceof ItemStack && (isclear ? !this.clearBoxItems((ItemStack)temp, box, tile) : !this.hasItemStackNoNBT((ItemStack)temp, box))) {
                    return false;
                }
                if (!(temp instanceof List) || !(isclear ? !this.clearBoxFromList(box, (List)temp, tile) : !this.isBoxHasList(box, (List)temp))) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Object[]) {
            Object[] items = (Object[])obj;
            for (int s = 0; s < items.length; ++s) {
                Object temp = items[s];
                if (temp == null) continue;
                if (temp instanceof ItemStack && (isclear ? !this.clearBoxItems((ItemStack)temp, box, tile) : !this.hasItemStackNoNBT((ItemStack)temp, box))) {
                    return false;
                }
                if (!(temp instanceof List) || !(isclear ? !this.clearBoxFromList(box, (List)temp, tile) : !this.isBoxHasList(box, (List)temp))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasItemStackNoNBT(ItemStack target, IInventory tile) {
        for (int b = 0; b < tile.func_70302_i_(); ++b) {
            if (tile.func_70301_a(b) == null || !this.isItemStackEqualNoNBT(tile.func_70301_a(b), target)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemStackEqualNoNBT(ItemStack item2, ItemStack target) {
        if (target.func_77973_b() == item2.func_77973_b()) {
            if (target.func_77960_j() == item2.func_77960_j()) {
                return true;
            }
            return target.func_77960_j() == Short.MAX_VALUE;
        }
        return false;
    }

    public boolean isItemStackEqualToLostNoNBT(ItemStack target, List targetlist) {
        for (int s = 0; s < targetlist.size(); ++s) {
            ItemStack item = (ItemStack)targetlist.get(s);
            if (!this.isItemStackEqualNoNBT(target, item)) continue;
            return true;
        }
        return false;
    }

    public boolean isBoxHasList(IInventory box, List targetlist) {
        int size = box.func_70302_i_();
        for (int s = 0; s < size; ++s) {
            ItemStack item = box.func_70301_a(s);
            if (item == null || !this.isItemStackEqualToLostNoNBT(item, targetlist)) continue;
            return true;
        }
        return false;
    }

    public boolean clearBoxFromList(IInventory box, List obj, TileEntityCrystalZ tile) {
        int size = box.func_70302_i_();
        for (int s = 0; s < size; ++s) {
            ItemStack item = box.func_70301_a(s);
            if (item == null) continue;
            int sizes = obj.size();
            for (int dx = 0; dx < sizes; ++dx) {
                if (!this.isItemStackEqualNoNBT(item, (ItemStack)obj.get(dx))) continue;
                ItemStack itemreturn = item.func_77946_l();
                itemreturn.field_77994_a = 1;
                tile.craftReturen.add(itemreturn);
                MMM.removeTileEntityItemReturn(box, s);
                return true;
            }
        }
        return false;
    }

    public boolean clearBoxItems(ItemStack target, IInventory box, TileEntityCrystalZ tile) {
        int size = box.func_70302_i_();
        for (int s = 0; s < size; ++s) {
            ItemStack item = box.func_70301_a(s);
            if (item == null || !this.isItemStackEqualNoNBT(item, target)) continue;
            ItemStack itemreturn = target.func_77946_l();
            itemreturn.field_77994_a = 1;
            tile.craftReturen.add(itemreturn);
            MMM.removeTileEntityItemReturn(box, s);
            return true;
        }
        return false;
    }

    public void effectCraftV2(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!tile.open) {
            return;
        }
        if (time % 20 == 0) {
            if (tile.craftReturen == null) {
                tile.craftReturen = new ArrayList<ItemStack>(9);
            }
            if (tile.target == null) {
                return;
            }
            if (tile.getEnergy().getEnergy() < 2) {
                return;
            }
            IInventory box = tile.getTarget();
            if (box == null) {
                return;
            }
            if (tile.craftNeeds != null && tile.outItem != null && MMM.isItemStackEqual(tile.target, tile.outItem)) {
                tile.craftReturen.clear();
                if (this.advancedCheck(box, tile.craftNeeds, true, tile)) {
                    ItemStack okitem = tile.outItem.func_77946_l();
                    okitem.field_77994_a = tile.outSize;
                    MMM.spawnItemInWorld(world, okitem, (double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.5f), (double)((float)tile.field_145849_e + 0.5f));
                    tile.getEnergy().removeEnergy(3);
                    return;
                }
                for (int s = 0; s < tile.craftReturen.size(); ++s) {
                    MMM.tryInsertItemTo(box, tile.craftReturen.get(s), null);
                }
                tile.craftReturen.clear();
            } else {
                List<IRecipe> RecipeList = AutoCrystal.findRecipeNONBT(tile.target);
                if (RecipeList != null) {
                    int out_item_size = 0;
                    Object item_need = null;
                    int size1 = RecipeList.size();
                    for (int sz = 0; sz < size1; ++sz) {
                        IRecipe temp = RecipeList.get(sz);
                        if (temp.func_77571_b() == null) continue;
                        item_need = this.getItemFromRecipe(temp);
                        out_item_size = temp.func_77571_b().field_77994_a;
                        tile.craftReturen.clear();
                        if (this.advancedCheck(box, item_need, true, tile)) {
                            ItemStack okitem = temp.func_77571_b().func_77946_l();
                            okitem.field_77994_a = out_item_size;
                            MMM.spawnItemInWorld(world, okitem, (double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.5f), (double)((float)tile.field_145849_e + 0.5f));
                            tile.getEnergy().removeEnergy(3);
                            tile.craftNeeds = item_need;
                            tile.outItem = temp.func_77571_b().func_77946_l();
                            tile.outSize = out_item_size;
                            return;
                        }
                        for (int s = 0; s < tile.craftReturen.size(); ++s) {
                            MMM.tryInsertItemTo(box, tile.craftReturen.get(s), null);
                        }
                    }
                }
            }
        }
    }

    public void effectCraft(TileEntityCrystalZ tile, int time, Random random, World world) {
        if (!tile.open) {
            return;
        }
        if (time % 40 == 0 && tile.target != null) {
            if (tile.getEnergy().getEnergy() < 2) {
                return;
            }
            int out_item_size = 0;
            MultipleItemStack[] MultipleItemStacks = null;
            List<IRecipe> RecipeList = MMM.findRecipeNONBT(tile.target);
            if (RecipeList != null) {
                block0: for (int sz = 0; sz < RecipeList.size(); ++sz) {
                    int s;
                    IInventory box;
                    MultipleItemStacks = MMM.getRecipeInputs(RecipeList.get(sz));
                    out_item_size = RecipeList.get((int)sz).func_77571_b().field_77994_a;
                    if (MultipleItemStacks == null || !this.hasItems(MultipleItemStacks) || (box = tile.getTarget()) == null) continue;
                    ItemStack[] item_need = new ItemStack[9];
                    block1: for (s = 0; s < MultipleItemStacks.length; ++s) {
                        if (MultipleItemStacks[s] == null || MultipleItemStacks[s].getItem(0) == null) continue;
                        if (MultipleItemStacks[s].getItem(0).func_77960_j() == Short.MAX_VALUE) {
                            MultipleItemStacks[s].getItem(0).func_77964_b(0);
                        }
                        for (int z = 0; z < item_need.length; ++z) {
                            if (item_need[z] == null) {
                                item_need[z] = MultipleItemStacks[s].getItem(0).func_77946_l();
                                item_need[z].field_77994_a = 1;
                                continue block1;
                            }
                            if (!MMM.isItemStackEqualNoNBT(MultipleItemStacks[s].getItem(0), item_need[z])) continue;
                            ++item_need[z].field_77994_a;
                            continue block1;
                        }
                    }
                    for (s = 0; s < item_need.length; ++s) {
                        if (item_need[s] != null && !MMM.hasItemStackNoNBT(item_need[s], box)) continue block0;
                    }
                    for (s = 0; s < item_need.length; ++s) {
                        if (item_need[s] != null && !MMM.clearItemsNoNBT(item_need[s], box)) continue block0;
                    }
                    ItemStack okitem = tile.target.func_77946_l();
                    okitem.field_77994_a = out_item_size;
                    MMM.spawnItemInWorld(world, okitem, (double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.5f), (double)((float)tile.field_145849_e + 0.5f));
                    tile.getEnergy().removeEnergy(3);
                    return;
                }
            }
        }
    }

    public static boolean can_effect(TileEntityCrystalZ tile, int time, Random random, World world) {
        return !world.func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) && tile.getEnergy().getEnergy() > 0;
    }

    public void effect(TileEntityCrystalZ tile, int time, Random random, World world) {
        switch (this) {
            case unknow: {
                break;
            }
            case animal: {
                break;
            }
            case craft: {
                if (world.field_72995_K || !AutoCrystal.can_effect(tile, time, random, world)) break;
                this.effectCraftV2(tile, time, random, world);
                break;
            }
            case setItem: {
                try {
                    if (time % 30 != 0 || world.field_72995_K) break;
                    AutoCrystalEffect.use_item(tile, time, random, world);
                }
                catch (Exception e1) {
                    if (tile.temp != null) {
                        MMM.Logg("autocrystal has error at use item : " + tile.temp.func_82833_r());
                    }
                    e1.printStackTrace();
                }
                break;
            }
            case moveItem: {
                if (time % 5 != 0) break;
                AutoCrystalEffect.move_item(tile, time, random, world);
                break;
            }
            case fish: {
                if (time % 20 != 0) break;
                AutoCrystalEffect.fishing(tile, time, random, world);
                break;
            }
            case agriculture: {
                if (time % 20 != 0) break;
                AutoCrystalEffect.farm(tile, time, random, world);
                break;
            }
            case breakBlock: {
                if (time % 20 != 0) break;
                AutoCrystalEffect.breakblock(tile, time, random, world);
                break;
            }
            case collect: {
                if (time % 3 != 0) break;
                AutoCrystalEffect.collectitem(tile, time, random, world);
                break;
            }
            case moveBlock: {
                if (time % 40 != 0) break;
                AutoCrystalEffect.moveblock(tile, time, random, world);
                break;
            }
            case setBlock: {
                if (time % 10 != 0) break;
                AutoCrystalEffect.setblock(tile, time, random, world);
                break;
            }
            case tree: {
                if (time % 20 != 0) break;
                AutoCrystalEffect.tree(tile, time, random, world);
            }
        }
    }
}

