/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.bosssummon;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.Lapuda.BossHydra;
import project.studio.manametalmod.Lapuda.BossRuneGiant;
import project.studio.manametalmod.Lapuda.BossSkyDragon;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.bosssummon.BossType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.core.TileEntityUpdate;
import project.studio.manametalmod.mob.boss.BossDarkKnight;
import project.studio.manametalmod.mob.boss.BossDeadAngel;
import project.studio.manametalmod.mob.boss.BossDestroyer;
import project.studio.manametalmod.mob.boss.BossDragonEvil;
import project.studio.manametalmod.mob.boss.BossDragonShadow;
import project.studio.manametalmod.mob.boss.BossLavaGiant;
import project.studio.manametalmod.mob.boss.BossRescures;
import project.studio.manametalmod.mob.boss.BossSnakeWind;
import project.studio.manametalmod.mob.boss.BossWitheredDevil;
import project.studio.manametalmod.multipleBlock.MultipleBlock;
import project.studio.manametalmod.pagan.MobPaganPuppetBoss;

public class TileEntityBossSpawn
extends TileEntityUpdate {
    public BossType type;
    public boolean isStart = false;
    public int time = 0;
    public boolean[] spawnData = new boolean[BossType.values().length];
    public static final MultipleBlock tileMB = new MultipleBlock("BossSpawn");

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isStart = NBTHelp.getBooleanSafe("isStart", nbt, this.isStart);
        this.time = NBTHelp.getIntSafe("time", nbt, this.time);
        this.spawnData = NBTHelp.getBooleanArraySafe(nbt, "spawnData", this.spawnData);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isStart", this.isStart);
        nbt.func_74768_a("time", this.time);
        NBTHelp.setBooleanArray(nbt, "spawnData", this.spawnData);
    }

    public static final boolean isCandles(Block block) {
        return ManaMetalAPI.CandleList.contains(block);
    }

    public boolean tryStart(BossType type, EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            if (tileMB.testBossSummon(this.field_145850_b, this.field_145851_c - 4, this.field_145848_d, this.field_145849_e - 4)) {
                if (this.spawnData[type.ordinal()]) {
                    if (TileEntityBossSpawn.hasProperArena(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && MMM.canSummonBoss(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                        if (!this.isStart) {
                            ItemStack need = new ItemStack(ManaMetalMod.ManaCrystal, TileEntityBossSpawn.getNeed(type));
                            if (MMM.hasItemStack(need, player)) {
                                MMM.clearItems(need, player);
                                this.isStart = true;
                                this.type = type;
                                this.time = 0;
                                MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":bossSummon", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0, 1.0, 32.0);
                                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
                                this.update_data();
                                return true;
                            }
                            MMM.addMessage(player, "MMM.info.bosssumom.fail.4");
                        } else {
                            MMM.addMessage(player, "MMM.info.bosssumom.fail.3");
                        }
                    } else {
                        MMM.addMessage(player, "MMM.info.bosssumom.fail.2");
                    }
                } else {
                    MMM.addMessage(player, "MMM.info.bosssumom.fail.1");
                }
            } else {
                MMM.addMessage(player, "MMM.info.bosssumom.fail.0");
            }
        }
        return false;
    }

    public static int getNeed(BossType type) {
        switch (type) {
            case destroy: 
            case Reaper: 
            case ShadowDragon: {
                return 8;
            }
            case LavaGiant: 
            case DeathAngel: 
            case Withered: {
                return 10;
            }
            case darkKnight: 
            case StormSnake: 
            case EvilDragon: {
                return 16;
            }
            case Hydra: 
            case GiantRose: 
            case RuneGiant: 
            case SkyGuardianDragon: {
                return 20;
            }
        }
        return 0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isStart) {
            ++this.time;
            if (this.time > 120) {
                this.summon();
            }
        }
        if (this.field_145850_b.field_72995_K && this.isStart) {
            float mx = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.3f;
            float my = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.3f;
            float mz = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) * 0.3f;
            FXHelp.spawnParticle(this.field_145850_b, Particle.dark, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.4, (double)this.field_145849_e + 0.5, mx, my, mz, 1.2f);
            FXHelp.spawnParticle(this.field_145850_b, Particle.fire, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.4, (double)this.field_145849_e + 0.5, 0.0, 0.5, 0.0, 2.2f);
            FXHelp.spawnParticle(this.field_145850_b, Particle.manaFire, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.4, (double)this.field_145849_e + 0.5, mx * 0.5f, my * 2.0f, mz * 0.5f, 1.2f);
            switch (this.field_145850_b.field_73012_v.nextInt(8)) {
                case 0: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)(this.field_145851_c + 4) + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 1: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)(this.field_145851_c - 4) + 0.5f, (float)this.field_145848_d + 0.5f, (float)this.field_145849_e + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 2: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)(this.field_145849_e + 4) + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 3: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 0.5f, (float)(this.field_145849_e - 4) + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 4: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)(this.field_145851_c + 3) + 0.5f, (float)this.field_145848_d + 0.5f, (float)(this.field_145849_e + 3) + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 5: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)(this.field_145851_c - 3) + 0.5f, (float)this.field_145848_d + 0.5f, (float)(this.field_145849_e - 3) + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 6: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)(this.field_145851_c + 3) + 0.5f, (float)this.field_145848_d + 0.5f, (float)(this.field_145849_e - 3) + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                    break;
                }
                case 7: {
                    FXHelp.spawnParticleTargetmobile(this.field_145850_b, Particle.enchantmenttable, (float)(this.field_145851_c - 3) + 0.5f, (float)this.field_145848_d + 0.5f, (float)(this.field_145849_e + 3) + 0.5f, 1, (float)this.field_145851_c + 0.5f, (double)this.field_145848_d + 0.5, (float)this.field_145849_e + 0.5f, 1.0f);
                }
            }
        }
    }

    public void summon() {
        if (!this.field_145850_b.field_72995_K) {
            this.isStart = false;
            this.time = 0;
            this.update_data();
            MMM.arcLightning_vanilla(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 0.0f, 0.0f, 255.0f);
            if (this.type == null) {
                return;
            }
            IBossDisplayData boss = null;
            switch (this.type) {
                case destroy: {
                    boss = new BossDestroyer(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case Reaper: {
                    boss = new BossRescures(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case ShadowDragon: {
                    boss = new BossDragonShadow(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case LavaGiant: {
                    boss = new BossLavaGiant(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case DeathAngel: {
                    boss = new BossDeadAngel(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case Withered: {
                    boss = new BossWitheredDevil(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case darkKnight: {
                    boss = new BossDarkKnight(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss2", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case StormSnake: {
                    boss = new BossSnakeWind(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss2", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case EvilDragon: {
                    boss = new BossDragonEvil(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss2", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case Hydra: {
                    boss = new BossHydra(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss3", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case GiantRose: {
                    boss = new MobPaganPuppetBoss(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss3", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case RuneGiant: {
                    boss = new BossRuneGiant(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss3", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                    break;
                }
                case SkyGuardianDragon: {
                    boss = new BossSkyDragon(this.field_145850_b);
                    MMM.playSoundFromServer(this.field_145850_b, MMM.getMODID() + ":event.boss3", this.field_145851_c, this.field_145848_d, this.field_145849_e, 5.0, 1.0, 32.0);
                }
            }
            if (boss != null) {
                boss.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                this.field_145850_b.func_72838_d((Entity)boss);
                MMM.PlayerShockClinet(40, MMM.getDimensionID(this.field_145850_b), this.field_145851_c, this.field_145848_d, this.field_145849_e, 20.0);
            }
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        }
    }

    public static boolean hasProperArena(World world, int sx, int sy, int sz) {
        int heightCheck = 3;
        int heightMin = 2;
        int range = (int)Math.ceil(16.0);
        for (int i = -range; i < range + 1; ++i) {
            block1: for (int j = -range; j < range + 1; ++j) {
                if (Math.abs(i) == 4 && Math.abs(j) == 4 || !(TileEntityBossSpawn.pointDistancePlane(i, j, 0.0, 0.0) <= 12.0f)) continue;
                int x = sx + i;
                int z = sz + j;
                int air = 0;
                for (int k = heightCheck + heightMin + 1; k >= -heightCheck; --k) {
                    boolean isAir;
                    int y = sy + k;
                    boolean bl = isAir = world.func_147439_a(x, y, z).func_149668_a(world, x, y, z) == null;
                    if (isAir) {
                        ++air;
                        continue;
                    }
                    if (k > heightCheck) continue;
                    if (air > 2) continue block1;
                    air = 0;
                }
                return false;
            }
        }
        return true;
    }

    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }
}

