/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.card;

import java.util.Random;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.card.EffectBattleCard;
import project.studio.manametalmod.card.IManaBattleCards;

public class BattleCard
implements Cloneable {
    public int attack;
    public int defense;
    public int health;
    public int crit;
    public int avoid;
    public int speed;
    public int attackTime = 0;
    public IManaBattleCards Card;
    public ItemStack cardItem;
    public boolean hasPower = false;
    public int powerCD = 0;
    public int cdTime = 0;
    public int id = 0;
    public int maxHP = 0;
    public static Random rand = new Random();
    public int time = 0;
    public EffectBattleCard[] effects = new EffectBattleCard[EffectBattleCard.values().length];
    public int[] effectTime = new int[EffectBattleCard.values().length];

    public BattleCard(ItemStack card) {
        if (card != null && card.func_77973_b() instanceof IManaBattleCards) {
            this.id = card.func_77960_j();
            this.Card = (IManaBattleCards)card.func_77973_b();
            this.attack = this.Card.getAttributes(this.id)[0];
            this.defense = this.Card.getAttributes(this.id)[1];
            this.health = this.Card.getAttributes(this.id)[2];
            this.crit = this.Card.getAttributes(this.id)[3];
            this.avoid = this.Card.getAttributes(this.id)[4];
            this.speed = this.Card.getAttributes(this.id)[5];
            this.maxHP = this.Card.getAttributes(this.id)[2];
            this.hasPower = this.Card.hasSpecialPower(this.id);
            this.powerCD = this.Card.SpecialPowerCD(this.id);
            this.cardItem = card;
        } else {
            MMM.Logg("[ERROR] battle card registered has error ! can't registered card");
            this.Kill();
        }
    }

    public static int getCardMaxSizeLV(int lv) {
        return 35 + lv * 5;
    }

    public BattleCard setNewCard() {
        BattleCard cards = new BattleCard(this.cardItem.func_77946_l());
        return cards;
    }

    public BattleCard clone() throws CloneNotSupportedException {
        BattleCard card = (BattleCard)super.clone();
        card.cardItem = this.cardItem.func_77946_l();
        card.Card = (IManaBattleCards)card.cardItem.func_77973_b();
        return card;
    }

    public void update() {
        ++this.attackTime;
        if (this.cdTime < this.powerCD) {
            ++this.cdTime;
        }
        this.Card.onCardUpdata(this);
        ++this.time;
        if (this.time >= 20) {
            this.time = 0;
            this.updateEffect();
        }
    }

    public void updateEffect() {
        for (int s = 0; s < this.effects.length; ++s) {
            if (this.effects[s] == null) continue;
            this.effects[s].doEffect(this);
            int n = s;
            this.effectTime[n] = this.effectTime[n] - 1;
            if (this.effectTime[s] > 0) continue;
            this.effects[s] = null;
            this.effectTime[s] = 0;
        }
    }

    public void addEffect(EffectBattleCard effect, int time) {
        this.effects[effect.ordinal()] = effect;
        this.effectTime[effect.ordinal()] = time;
    }

    public void removeEffect(EffectBattleCard effect) {
        this.effects[effect.ordinal()] = null;
        this.effectTime[effect.ordinal()] = 0;
    }

    public boolean hasEffect(EffectBattleCard effect) {
        for (int s = 0; s < this.effects.length; ++s) {
            if (this.effects[s] == null || this.effects[s] != effect || this.effectTime[s] <= 0) continue;
            return true;
        }
        return false;
    }

    public void removeEffect() {
        this.effects = new EffectBattleCard[EffectBattleCard.values().length];
        this.effectTime = new int[EffectBattleCard.values().length];
    }

    public boolean canUsePower() {
        if (!this.hasEffect(EffectBattleCard.silence)) {
            return this.hasPower && this.cdTime >= this.powerCD;
        }
        return false;
    }

    public boolean canAttack() {
        return this.attackTime >= this.speed;
    }

    public boolean hasDamage() {
        return this.health < this.maxHP;
    }

    public void Kill() {
        this.damageCard(2000.0f);
    }

    public boolean isDead() {
        return this.health <= 0;
    }

    public void damageCard(int damage) {
        this.health -= damage;
    }

    public void damageCard(float damage) {
        this.health = (int)((float)this.health - (float)this.maxHP * damage);
    }

    public void healCard(int heal) {
        this.health += heal;
        if (this.health > this.maxHP) {
            this.health = this.maxHP;
        }
    }

    public void healCard(float heal) {
        this.health = (int)((float)this.health + (float)this.maxHP * heal);
        if (this.health > this.maxHP) {
            this.health = this.maxHP;
        }
    }

    public String toString() {
        return this.cardItem.func_82833_r();
    }
}

