/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.chess;

import java.util.Arrays;
import project.studio.manametalmod.chess.AIChessMove;
import project.studio.manametalmod.chess.AIChessPosition;
import project.studio.manametalmod.chess.AIMain;

public class AIChess {
    public AIMain main;
    public static final boolean WHITE = true;
    public static final boolean BLACK = false;
    public boolean HUMAN = true;
    public boolean PROGRAM = false;
    public boolean bWhoseTurn = true;
    public boolean bIterativeDeepening = true;
    public int nodeCount = 0;
    public int maxDepth;
    public static int maxDepthSetting = 5;
    public boolean bThinking = false;
    private static final int[] index = new int[]{0, 12, 15, 10, 1, 6, 6};
    public AIChessPosition pos = null;
    public AIChessPosition workPos = null;
    private static final int[] pieceMovementTable = new int[]{0, -1, 1, 10, -10, 0, -1, 1, 10, -10, -9, -11, 9, 11, 0, 8, -8, 12, -12, 19, -19, 21, -21, 0, 10, 20, 0};
    private static final float[] value = new float[]{0.0f, 1.0f, 3.0f, 3.2f, 5.0f, 9.0f, 500.0f};
    private final AIChessMove[] possibleCaptures = new AIChessMove[256];
    private final AIChessMove[] possibleMoveList = new AIChessMove[256];
    private final int[] piece_moves = new int[32];
    public int reachedDepth = 0;
    public AIChessMove bestMove = new AIChessMove();
    int localMaxima = 0;
    public AIChessMove localBestMove = null;
    public boolean bCheck = false;
    public int lastDepth = -1;
    public AIChessMove[] principalVariation = new AIChessMove[16];
    int sideChecked = 0;
    public int nPossibleCaptures = 0;
    private final int[] computerControl = new int[80];
    private final int[] humanControl = new int[80];

    public boolean drawnPosition(AIChessPosition p) {
        return false;
    }

    public boolean wonPosition(AIChessPosition p, boolean player) {
        return false;
    }

    protected AIChessMove alphaBeta(int depth, AIChessPosition p, boolean player) {
        this.nodeCount = 0;
        this.reachedDepth = 0;
        if (this.maxDepth > 3 && this.bIterativeDeepening) {
            int prevDepth = this.maxDepth;
            this.maxDepth = 3;
            float beta = 100000.0f;
            int md = 3;
            while (md < prevDepth + 1) {
                this.maxDepth = md++;
                beta = this.alphaBetaHelper(depth, p, player, 100000.0f, -beta);
                if (!this.bThinking) break;
            }
            this.maxDepth = prevDepth;
        }
        return this.bestMove;
    }

    protected float alphaBetaHelper(int depth, AIChessPosition p, boolean player, float alpha, float beta) {
        int i;
        if (this.lastDepth != depth) {
            this.lastDepth = depth;
        }
        int num = 0;
        if (player ? p.bBlackChecked : p.bWhiteChecked) {
            num = this.calcPossibleMoves(p, player);
            if (player ? p.bBlackChecked : p.bWhiteChecked) {
                if (depth == 2) {
                    return (this.maxDepth - depth + this.localMaxima + 1) * 2000;
                }
                return (this.maxDepth - depth + this.localMaxima + 1) * 1000;
            }
        }
        if (depth > this.reachedDepth) {
            this.reachedDepth = depth;
        }
        if (depth - this.localMaxima >= this.maxDepth || !this.bThinking) {
            return this.positionEvaluation(p, player);
        }
        if (num == 0) {
            num = this.calcPossibleMoves(p, player);
        }
        float value = 0.0f;
        AIChessMove[] chessMove = new AIChessMove[num];
        int nMoves = num - this.nPossibleCaptures;
        for (i = 0; i < this.nPossibleCaptures; ++i) {
            chessMove[i] = new AIChessMove(this.possibleCaptures[i]);
        }
        for (i = 0; i < nMoves; ++i) {
            chessMove[this.nPossibleCaptures + i] = new AIChessMove(this.possibleMoveList[i]);
        }
        int prevToVal = 0;
        int prevFromVal = 0;
        for (i = 0; i < num; ++i) {
            if (p.board[chessMove[i].to] != 0 || p.board[chessMove[i].from] == (player ? 1 : -1)) {
                this.localMaxima = 2;
            }
            boolean bWhiteKingMoved = p.bWhiteKingMoved;
            boolean bBlackKingMoved = p.bBlackKingMoved;
            prevFromVal = p.board[chessMove[i].from];
            prevToVal = p.board[chessMove[i].to];
            p.makeMove(chessMove[i]);
            ++this.nodeCount;
            value = -this.alphaBetaHelper(depth + 1, p, !player, -beta, -alpha);
            p.board[chessMove[i].from] = prevFromVal;
            p.board[chessMove[i].to] = prevToVal;
            p.bWhiteKingMoved = bWhiteKingMoved;
            p.bBlackKingMoved = bBlackKingMoved;
            if (this.localMaxima != 0) {
                this.localMaxima = 0;
            }
            if (value >= alpha) {
                return alpha;
            }
            if (!(value > beta)) continue;
            beta = value;
            this.principalVariation[depth].from = chessMove[i].from;
            this.principalVariation[depth].to = chessMove[i].to;
            if (depth != 0) continue;
            this.bestMove = chessMove[i];
        }
        return beta;
    }

    public AIChessMove playGame(AIChessPosition startingPosition, boolean bAsPlayer) {
        for (int i = 0; i < 16; ++i) {
            this.principalVariation[i].from = 0;
            this.principalVariation[i].to = 0;
        }
        this.workPos = new AIChessPosition(startingPosition);
        this.bestMove = null;
        this.bestMove = this.alphaBeta(0, this.workPos, bAsPlayer);
        if (!this.bThinking) {
            return null;
        }
        return this.bestMove;
    }

    public float positionEvaluation(AIChessPosition p, boolean player) {
        AIChessPosition pos = p;
        int[] b = pos.board;
        float ret = 0.0f;
        int pieceType = 0;
        float val = 0.0f;
        float control = 0.0f;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                int i = y * 10 + x;
                if (b[i] == 0) continue;
                control += (float)this.humanControl[i];
                control -= (float)this.computerControl[i];
                if (b[i] < 0) {
                    if (this.humanControl[i] > this.computerControl[i]) {
                        control += value[-b[i]];
                    }
                } else if (this.humanControl[i] < this.computerControl[i]) {
                    control -= value[b[i]];
                }
                if ((pieceType = b[i]) < 0) {
                    pieceType = -pieceType;
                }
                val = value[pieceType];
                val *= 5.0f;
                if (b[i] < 0) {
                    val = -val;
                }
                ret += val;
            }
        }
        control += (float)(this.humanControl[33] - this.computerControl[33]);
        control += (float)(this.humanControl[34] - this.computerControl[34]);
        control += (float)(this.humanControl[43] - this.computerControl[43]);
        control += (float)(this.humanControl[44] - this.computerControl[44]);
        control = (float)((double)control * 0.333);
        ret += control;
        if (!player) {
            ret = -ret;
        }
        return ret;
    }

    private int calcPieceMoves(AIChessPosition pos, int square_index) {
        int[] b = pos.board;
        int piece = b[square_index];
        int piece_type = piece;
        if (piece_type < 0) {
            piece_type = -piece_type;
        }
        int count = 0;
        int piece_index = index[piece_type];
        int move_index = pieceMovementTable[piece_index];
        int target = 0;
        int side_index = piece < 0 ? -1 : 1;
        int[] control = piece < 0 ? this.computerControl : this.humanControl;
        block0 : switch (piece_type) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                int move_offset = square_index + side_index * 10 + 1;
                if (move_offset >= 0 && move_offset < 80) {
                    target = b[move_offset];
                    if (piece > 0 && target < 0 && target != 7 || piece < 0 && target > 0 && target != 7) {
                        this.piece_moves[count++] = move_offset;
                        int n = move_offset;
                        control[n] = control[n] + 12;
                        if (target == 6) {
                            pos.bWhiteChecked = true;
                        } else if (target == -6) {
                            pos.bBlackChecked = true;
                        }
                    }
                }
                if ((move_offset = square_index + side_index * 10 - 1) >= 0 && move_offset < 80) {
                    target = b[move_offset];
                    if (piece > 0 && target < 0 && target != 7 || piece < 0 && target > 0 && target != 7) {
                        this.piece_moves[count++] = move_offset;
                        int n = move_offset;
                        control[n] = control[n] + 12;
                        if (target == 6) {
                            pos.bWhiteChecked = true;
                        } else if (target == -6) {
                            pos.bBlackChecked = true;
                        }
                    }
                }
                if ((move_offset = square_index + side_index * 20) >= 0 && move_offset < 80) {
                    int temp;
                    int n = temp = piece > 0 ? 1 : 6;
                    if (b[move_offset] == 0 && square_index / 10 == temp && (piece < 0 && b[square_index - 10] == 0 || piece > 0 && b[square_index + 10] == 0)) {
                        this.piece_moves[count++] = move_offset;
                    }
                }
                if ((move_offset = square_index + side_index * 10) < 0 || move_offset >= 80 || b[move_offset] != 0) break;
                this.piece_moves[count++] = move_offset;
                break;
            }
            default: {
                move_index = piece;
                if (move_index < 0) {
                    move_index = -move_index;
                }
                move_index = index[move_index];
                int next_square = square_index + pieceMovementTable[move_index];
                while (true) {
                    if (next_square < 80 && next_square >= 0 && b[next_square] != 7) {
                        target = b[next_square];
                        if (!(side_index < 0 && target < 0 || side_index > 0 && target > 0)) {
                            int n = next_square;
                            control[n] = control[n] + 1;
                            this.piece_moves[count++] = next_square;
                            if (target == 6) {
                                pos.bWhiteChecked = true;
                            } else if (target == -6) {
                                pos.bBlackChecked = true;
                            }
                            if (target == 0 && piece_type != 2 && piece_type != 6) {
                                next_square += pieceMovementTable[move_index];
                                continue;
                            }
                        }
                    }
                    if (pieceMovementTable[++move_index] == 0) break block0;
                    next_square = square_index + pieceMovementTable[move_index];
                }
            }
        }
        return count;
    }

    public int calcPossibleMoves(AIChessPosition pos, boolean player) {
        Arrays.fill(this.humanControl, 0);
        Arrays.fill(this.computerControl, 0);
        int[] b = pos.board;
        pos.bWhiteChecked = false;
        pos.bBlackChecked = false;
        int count = 0;
        this.nPossibleCaptures = 0;
        int i = 0;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                i = y * 10 + x;
                if (b[i] == 0) continue;
                int board_val = b[i];
                int num = this.calcPieceMoves(pos, i);
                if ((board_val >= 0 || player) && (board_val <= 0 || !player)) continue;
                for (int j = 0; j < num; ++j) {
                    if (b[this.piece_moves[j]] != 0 || b[i] == (player ? 1 : -1) || this.piece_moves[j] == 33 || this.piece_moves[j] == 34 || this.piece_moves[j] == 43 || this.piece_moves[j] == 44) {
                        this.possibleCaptures[this.nPossibleCaptures].from = i;
                        this.possibleCaptures[this.nPossibleCaptures].to = this.piece_moves[j];
                        ++this.nPossibleCaptures;
                        continue;
                    }
                    this.possibleMoveList[count].from = i;
                    this.possibleMoveList[count].to = this.piece_moves[j];
                    ++count;
                }
            }
        }
        return count + this.nPossibleCaptures;
    }

    public AIChess(AIMain main) {
        int i;
        this.main = main;
        this.pos = new AIChessPosition(this.main);
        this.workPos = new AIChessPosition(this.main);
        for (i = 0; i < 256; ++i) {
            this.possibleMoveList[i] = new AIChessMove();
        }
        for (i = 0; i < 256; ++i) {
            this.possibleCaptures[i] = new AIChessMove();
        }
        for (i = 0; i < 16; ++i) {
            this.principalVariation[i] = new AIChessMove();
        }
        this.main = main;
        this.maxDepth = maxDepthSetting;
    }
}

