/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.AttributesItemType;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.entity.nbt.NbtBaubles;
import project.studio.manametalmod.magic.magicItem.IMagicEffect;

public class AttributesItem {
    public AttributesItemType type;
    public ItemStack item;
    public int maxUse;
    public IMagicEffect[] effect;
    public boolean canLost = false;
    public String needMODID = MMM.getMODID();

    public AttributesItem(AttributesItemType type, Object item, int maxUse, IMagicEffect ... effect) {
        this.type = type;
        this.item = MMM.item(item);
        this.maxUse = maxUse;
        this.effect = effect;
    }

    public String needMODID() {
        return this.needMODID;
    }

    public AttributesItem setNeedMODID(String needMODID) {
        this.needMODID = needMODID;
        return this;
    }

    public static final AttributesItem get(AttributesItemType type) {
        int size = ManaMetalAPI.AttributesItemList.size();
        for (int s = 0; s < size; ++s) {
            AttributesItem temp = ManaMetalAPI.AttributesItemList.get(s);
            if (temp.type != type) continue;
            return temp;
        }
        return null;
    }

    public static final boolean effect(AttributesItemType type, EntityPlayer player, boolean isRemove, boolean changeUseCount, boolean message, String sound, boolean removeItem) {
        return AttributesItem.effect(type, MMM.getEntityNBT(player), player, isRemove, changeUseCount, message, sound, removeItem, false);
    }

    public static final boolean effect(AttributesItemType type, ManaMetalModRoot root, EntityPlayer player, boolean isRemove, boolean changeUseCount, boolean message, String sound, boolean removeItem, boolean needCheckUseCount) {
        AttributesItem temp;
        if (root != null && (temp = AttributesItem.get(type)) != null) {
            if (root.carrer.AttributesItemUseCount[type.ordinal()] < temp.maxUse || needCheckUseCount) {
                if (temp.effect != null) {
                    for (int s = 0; s < temp.effect.length; ++s) {
                        NbtBaubles.apply(temp.effect[s].getType(), root, isRemove ? -temp.effect[s].getValue() : temp.effect[s].getValue(), player);
                    }
                }
                if (changeUseCount) {
                    if (isRemove) {
                        int n = type.ordinal();
                        root.carrer.AttributesItemUseCount[n] = root.carrer.AttributesItemUseCount[n] - 1;
                    } else {
                        int n = type.ordinal();
                        root.carrer.AttributesItemUseCount[n] = root.carrer.AttributesItemUseCount[n] + 1;
                    }
                    root.carrer.send2();
                }
                if (!player.field_70170_p.field_72995_K && message) {
                    int isUse = temp.maxUse - root.carrer.AttributesItemUseCount[type.ordinal()];
                    MMM.addMessage(player, "MMM.info.AttributesItem.use", temp.item.func_82833_r(), isUse);
                }
                if (removeItem) {
                    MMM.removePlayerCurrentItem(player);
                }
                temp.item.func_77973_b().func_77654_b(temp.item, player.field_70170_p, player);
                if (sound != null) {
                    player.field_70170_p.func_72956_a((Entity)player, sound, 0.5f, player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
                }
                return true;
            }
            if (!player.field_70170_p.field_72995_K && message) {
                MMM.addMessage(player, "MMM.info.AttributesItem.fail", temp.item.func_82833_r(), temp.maxUse);
            }
        }
        return false;
    }

    public static final boolean canUse(AttributesItemType type, ManaMetalModRoot root, EntityPlayer player) {
        AttributesItem temp;
        if (root != null && (temp = AttributesItem.get(type)) != null) {
            return root.carrer.AttributesItemUseCount[type.ordinal()] < temp.maxUse;
        }
        return false;
    }

    public boolean isCanLost() {
        return this.canLost;
    }

    public AttributesItem setCanLost(boolean canLost) {
        this.canLost = canLost;
        return this;
    }
}

