/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import project.studio.manametalmod.core.BlockDataPos;
import project.studio.manametalmod.core.BlockPos;
import project.studio.manametalmod.core.Pos;

public class TargetHelp {
    public static BlockPos getBlockAimingAt(EntityLivingBase player, World world, double distance) {
        if (!world.field_72995_K) {
            float angleZ;
            float sinPitch;
            float cosPitch;
            float rotPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C);
            float rotYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B);
            double baseX = player.field_70169_q + (player.field_70165_t - player.field_70169_q);
            double baseY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) + 1.62 - (double)player.field_70129_M;
            double baseZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s);
            Vec3 fromVec = Vec3.func_72443_a((double)baseX, (double)baseY, (double)baseZ);
            float cosYaw = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float sinYaw = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float angleX = sinYaw * (cosPitch = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180))));
            Vec3 toVec = fromVec.func_72441_c((double)angleX * distance, (double)(sinPitch = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)))) * distance, (double)(angleZ = cosYaw * cosPitch) * distance);
            MovingObjectPosition ray = world.func_72901_a(fromVec, toVec, true);
            if (ray == null) {
                return null;
            }
            int x = ray.field_72311_b;
            int y = ray.field_72312_c;
            int z = ray.field_72309_d;
            Block blockHit = world.func_147439_a(x, y, z);
            return new BlockPos(blockHit, new Pos(ray), world.func_72805_g(x, y, z));
        }
        return null;
    }

    public static Entity getTargetEntity(EntityLivingBase ep, World world, double dist) {
        MovingObjectPosition mop = TargetHelp.getMovingObjectPositionFromPlayer(ep, world, dist);
        if (mop != null) {
            return mop.field_72308_g;
        }
        return null;
    }

    public static BlockPos getTargetBlockEntity(EntityLivingBase player, World world) {
        MovingObjectPosition mop = TargetHelp.getMovingObjectPositionFromEntity(world, player, true);
        if (mop == null) {
            return null;
        }
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        Block blockHit = world.func_147439_a(x, y, z);
        if (blockHit != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return new BlockPos(blockHit, new Pos(mop), world.func_72805_g(x, y, z));
        }
        return null;
    }

    protected static MovingObjectPosition getMovingObjectPositionFromEntity(World world, EntityLivingBase player, boolean data) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)player.func_70047_e();
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 1.5;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, data, !data, false);
    }

    public static BlockDataPos getTargetBlock(EntityPlayer player, World world) {
        MovingObjectPosition mop = TargetHelp.getMovingObjectPositionFromPlayer(world, player, true);
        if (mop == null) {
            return null;
        }
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        Block blockHit = world.func_147439_a(x, y, z);
        if (blockHit != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return new BlockDataPos(blockHit, world.func_72805_g(x, y, z), x, y, z);
        }
        return null;
    }

    public static Entity getTargetEntityV2(World world, EntityPlayer player, int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        Entity target = null;
        List list = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)scanRadius), (double)(player.field_70163_u - (double)scanRadius), (double)(player.field_70161_v - (double)scanRadius), (double)(player.field_70165_t + (double)scanRadius), (double)(player.field_70163_u + (double)scanRadius), (double)(player.field_70161_v + (double)scanRadius)));
        for (int s = 0; s < list.size(); ++s) {
            Entity tempentity = (Entity)list.get(s);
            if (tempentity == null || tempentity.field_70121_D == null) continue;
            float distance = player.func_70032_d(tempentity) + 0.1f;
            float angle = player.field_70759_as;
            float pitch = player.field_70125_A;
            Vec3 look = player.func_70040_Z();
            Vec3 targetVec = Vec3.func_72443_a((double)(player.field_70165_t + look.field_72450_a * (double)distance), (double)((double)player.func_70047_e() + player.field_70163_u + look.field_72448_b * (double)distance), (double)(player.field_70161_v + look.field_72449_c * (double)distance));
            if (!tempentity.field_70121_D.func_72318_a(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = tempentity;
        }
        return target;
    }

    public static EntityLivingBase getTargetEntityLife(World world, EntityPlayer player, int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        EntityLivingBase target = null;
        List lst = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)scanRadius), (double)(player.field_70163_u - (double)scanRadius), (double)(player.field_70161_v - (double)scanRadius), (double)(player.field_70165_t + (double)scanRadius), (double)(player.field_70163_u + (double)scanRadius), (double)(player.field_70161_v + (double)scanRadius)));
        for (int i = 0; i < lst.size(); ++i) {
            Entity ent = (Entity)lst.get(i);
            if (ent == null || ent.field_70121_D == null || !(ent instanceof EntityLivingBase)) continue;
            float distance = player.func_70032_d(ent) + 0.1f;
            float angle = player.field_70759_as;
            float pitch = player.field_70125_A;
            Vec3 look = player.func_70040_Z();
            Vec3 targetVec = Vec3.func_72443_a((double)(player.field_70165_t + look.field_72450_a * (double)distance), (double)((double)player.func_70047_e() + player.field_70163_u + look.field_72448_b * (double)distance), (double)(player.field_70161_v + look.field_72449_c * (double)distance));
            if (!ent.field_70121_D.func_72318_a(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (EntityLivingBase)ent;
        }
        return target;
    }

    public static EntityLivingBase getTargetMob(World world, EntityPlayer player, int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        EntityLivingBase target = null;
        List lst = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)scanRadius), (double)(player.field_70163_u - (double)scanRadius), (double)(player.field_70161_v - (double)scanRadius), (double)(player.field_70165_t + (double)scanRadius), (double)(player.field_70163_u + (double)scanRadius), (double)(player.field_70161_v + (double)scanRadius)));
        for (int i = 0; i < lst.size(); ++i) {
            Entity ent = (Entity)lst.get(i);
            if (ent == null || ent.field_70121_D == null || !(ent instanceof EntityLivingBase) || !(ent instanceof EntityMob) && !(ent instanceof IMob)) continue;
            float distance = player.func_70032_d(ent) + 0.1f;
            float angle = player.field_70759_as;
            float pitch = player.field_70125_A;
            Vec3 look = player.func_70040_Z();
            Vec3 targetVec = Vec3.func_72443_a((double)(player.field_70165_t + look.field_72450_a * (double)distance), (double)((double)player.func_70047_e() + player.field_70163_u + look.field_72448_b * (double)distance), (double)(player.field_70161_v + look.field_72449_c * (double)distance));
            if (!ent.field_70121_D.func_72318_a(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (EntityLivingBase)ent;
        }
        return target;
    }

    protected static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer player, boolean data) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, data, !data, false);
    }

    protected static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityLivingBase ep, World world, double dist) {
        return TargetHelp.getMovingObjectPositionFromPlayer(ep, world, dist, 0.0);
    }

    protected static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityLivingBase ep, World world, double dist, double bbExpand) {
        MovingObjectPosition mop = null;
        float yOffset = ep.func_70047_e();
        Vec3 playerPos = Vec3.func_72443_a((double)ep.field_70165_t, (double)(ep.field_70163_u + (double)yOffset), (double)ep.field_70161_v);
        Vec3 look = ep.func_70040_Z();
        if (ep instanceof EntityPlayer) {
            mop = TargetHelp.getBlockMovingObjectPositionFromPlayer(world, ep, dist, true);
            if (mop != null) {
                Vec3 v = Vec3.func_72443_a((double)(ep.field_70165_t - (double)mop.field_72311_b), (double)(ep.field_70163_u - (double)mop.field_72312_c), (double)(ep.field_70161_v - (double)mop.field_72309_d));
                dist = v.func_72433_c();
            }
        } else {
            mop = world.func_72901_a(playerPos, look, true);
        }
        Vec3 playerView = playerPos.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        List list = world.func_72839_b((Entity)ep, ep.field_70121_D.func_72321_a(ep.func_70040_Z().field_72450_a * dist, ep.func_70040_Z().field_72448_b * dist, ep.func_70040_Z().field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0));
        MovingObjectPosition tempMop = null;
        double prevDist = dist * dist;
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1 == ep.field_70154_o || ep == ep.field_70154_o || !(entity1 instanceof EntityLivingBase)) continue;
            float f2 = 0.4f;
            AxisAlignedBB axisalignedbb = entity1.field_70121_D.func_72314_b(bbExpand, bbExpand, bbExpand);
            MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(playerPos, playerView);
            if (movingobjectposition1 == null) continue;
            movingobjectposition1.field_72308_g = entity1;
            double entityDist = entity1.func_70068_e((Entity)ep);
            if (!(entityDist < prevDist)) continue;
            tempMop = movingobjectposition1;
            prevDist = entityDist;
        }
        if (tempMop != null) {
            return tempMop;
        }
        return mop;
    }

    protected static MovingObjectPosition getBlockMovingObjectPositionFromPlayer(World par1World, EntityLivingBase par2EntityPlayer, double reachDistance, boolean par3) {
        float f = 1.0f;
        float rotPitch = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float rotYaw = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double posX = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double posY = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + 1.62 - (double)par2EntityPlayer.field_70129_M;
        double posZ = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 entityPos = Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
        float zDesp = MathHelper.func_76134_b((float)(-rotYaw * 0.01745329f - 3.141593f));
        float xDesp = MathHelper.func_76126_a((float)(-rotYaw * 0.01745329f - 3.141593f));
        float yScale = -MathHelper.func_76134_b((float)(-rotPitch * 0.01745329f));
        float lookY = MathHelper.func_76126_a((float)(-rotPitch * 0.01745329f));
        float lookX = xDesp * yScale;
        float lookZ = zDesp * yScale;
        Vec3 look = entityPos.func_72441_c((double)lookX * reachDistance, (double)lookY * reachDistance, (double)lookZ * reachDistance);
        return par1World.func_72901_a(entityPos, look, par3);
    }
}

