/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.earlystrength;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;

public class BlockBedBase
extends BlockDirectional {
    public static final int[][] bedPosFX = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] Icon1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] Icon2;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] Icon3;
    int power;
    String name;

    public BlockBedBase(String name, int power) {
        super(Material.field_151577_b);
        this.name = name;
        this.func_149672_a(Block.field_149775_l);
        this.setblockSize();
        this.func_149663_c(name);
        this.func_149658_d(MMM.getMODID() + ":" + name);
        this.power = power;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int data, float dx, float dy, float dz) {
        if (world.field_72995_K) {
            return true;
        }
        int i1 = world.func_72805_g(x, y, z);
        if (!BlockBedBase.isBlockHeadOfBed(i1)) {
            int j1 = BlockBedBase.func_149895_l((int)i1);
            if (world.func_147439_a(x += bedPosFX[j1][0], y, z += bedPosFX[j1][1]) != this) {
                return true;
            }
            i1 = world.func_72805_g(x, y, z);
        }
        if (world.field_73011_w.func_76567_e() && world.func_72807_a(x, z) != BiomeGenBase.field_76778_j) {
            EntityPlayer.EnumStatus enumstatus;
            if (BlockBedBase.func_149976_c(i1)) {
                EntityPlayer entityplayer1 = null;
                for (EntityPlayer entityplayer2 : world.field_73010_i) {
                    if (!entityplayer2.func_70608_bn()) continue;
                    ChunkCoordinates chunkcoordinates = entityplayer2.field_71081_bT;
                    if (chunkcoordinates.field_71574_a != x || chunkcoordinates.field_71572_b != y || chunkcoordinates.field_71573_c != z) continue;
                    entityplayer1 = entityplayer2;
                }
                if (entityplayer1 != null) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.occupied", new Object[0]));
                    return true;
                }
                BlockBedBase.func_149979_a(world, x, y, z, false);
            }
            if ((enumstatus = player.func_71018_a(x, y, z)) == EntityPlayer.EnumStatus.OK) {
                ManaMetalModRoot root = MMM.getEntityNBT(player);
                if (root != null) {
                    root.mana.setBedPower(this.power);
                }
                BlockBedBase.func_149979_a(world, x, y, z, true);
                return true;
            }
            if (enumstatus == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
            } else if (enumstatus == EntityPlayer.EnumStatus.NOT_SAFE) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
            }
            return true;
        }
        double d2 = (double)x + 0.5;
        double d0 = (double)y + 0.5;
        double d1 = (double)z + 0.5;
        world.func_147468_f(x, y, z);
        int k1 = BlockBedBase.func_149895_l((int)i1);
        if (world.func_147439_a(x += bedPosFX[k1][0], y, z += bedPosFX[k1][1]) == this) {
            world.func_147468_f(x, y, z);
            d2 = (d2 + (double)x + 0.5) / 2.0;
            d0 = (d0 + (double)y + 0.5) / 2.0;
            d1 = (d1 + (double)z + 0.5) / 2.0;
        }
        world.func_72885_a((Entity)null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 5.0f, true, true);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        int i1;
        if (p_149691_1_ == 0) {
            return Blocks.field_150344_f.func_149733_h(p_149691_1_);
        }
        int k = BlockBedBase.func_149895_l((int)p_149691_2_);
        int l = Direction.field_71584_h[k][p_149691_1_];
        int n = i1 = BlockBedBase.isBlockHeadOfBed(p_149691_2_) ? 1 : 0;
        return !(i1 == 1 && l == 2 || i1 == 0 && l == 3) ? (l != 5 && l != 4 ? this.Icon3[i1] : this.Icon2[i1]) : this.Icon1[i1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.Icon3 = new IIcon[]{p_149651_1_.func_94245_a(this.func_149641_N() + "_feet_top"), p_149651_1_.func_94245_a(this.func_149641_N() + "_head_top")};
        this.Icon1 = new IIcon[]{p_149651_1_.func_94245_a(this.func_149641_N() + "_feet_end"), p_149651_1_.func_94245_a(this.func_149641_N() + "_head_end")};
        this.Icon2 = new IIcon[]{p_149651_1_.func_94245_a(this.func_149641_N() + "_feet_side"), p_149651_1_.func_94245_a(this.func_149641_N() + "_head_side")};
    }

    public int func_149645_b() {
        return 14;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        this.setblockSize();
    }

    public void func_149695_a(World p_149695_1_, int p_149695_2_, int p_149695_3_, int p_149695_4_, Block p_149695_5_) {
        int l = p_149695_1_.func_72805_g(p_149695_2_, p_149695_3_, p_149695_4_);
        int i1 = BlockBedBase.func_149895_l((int)l);
        if (BlockBedBase.isBlockHeadOfBed(l)) {
            if (p_149695_1_.func_147439_a(p_149695_2_ - bedPosFX[i1][0], p_149695_3_, p_149695_4_ - bedPosFX[i1][1]) != this) {
                p_149695_1_.func_147468_f(p_149695_2_, p_149695_3_, p_149695_4_);
            }
        } else if (p_149695_1_.func_147439_a(p_149695_2_ + bedPosFX[i1][0], p_149695_3_, p_149695_4_ + bedPosFX[i1][1]) != this) {
            p_149695_1_.func_147468_f(p_149695_2_, p_149695_3_, p_149695_4_);
            if (!p_149695_1_.field_72995_K) {
                this.func_149697_b(p_149695_1_, p_149695_2_, p_149695_3_, p_149695_4_, l, 0);
            }
        }
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return BlockBedBase.isBlockHeadOfBed(p_149650_1_) ? Item.func_150899_d((int)0) : MMM.findItemStackM3("Item" + this.name, 1, 0).func_77973_b();
    }

    private void setblockSize() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public static boolean isBlockHeadOfBed(int p_149975_0_) {
        return (p_149975_0_ & 8) != 0;
    }

    public static boolean func_149976_c(int p_149976_0_) {
        return (p_149976_0_ & 4) != 0;
    }

    public static void func_149979_a(World p_149979_0_, int p_149979_1_, int p_149979_2_, int p_149979_3_, boolean p_149979_4_) {
        int l = p_149979_0_.func_72805_g(p_149979_1_, p_149979_2_, p_149979_3_);
        l = p_149979_4_ ? (l |= 4) : (l &= 0xFFFFFFFB);
        p_149979_0_.func_72921_c(p_149979_1_, p_149979_2_, p_149979_3_, l, 4);
    }

    public static ChunkCoordinates func_149977_a(World world, int x, int y, int z, int p_149977_4_) {
        int i1 = world.func_72805_g(x, y, z);
        int j1 = BlockDirectional.func_149895_l((int)i1);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = x - bedPosFX[j1][0] * k1 - 1;
            int i2 = z - bedPosFX[j1][1] * k1 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!World.func_147466_a((IBlockAccess)world, (int)l2, (int)(y - 1), (int)i3) || world.func_147439_a(l2, y, i3).func_149688_o().func_76218_k() || world.func_147439_a(l2, y + 1, i3).func_149688_o().func_76218_k()) continue;
                    if (p_149977_4_ <= 0) {
                        return new ChunkCoordinates(l2, y, i3);
                    }
                    --p_149977_4_;
                }
            }
        }
        return null;
    }

    public void func_149690_a(World world, int x, int y, int z, int data, float p_149690_6_, int p_149690_7_) {
        if (!BlockBedBase.isBlockHeadOfBed(data)) {
            super.func_149690_a(world, x, y, z, data, p_149690_6_, 0);
        }
    }

    public int func_149656_h() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return MMM.findItemStackM3("Item" + this.name, 1, 0).func_77973_b();
    }

    public void func_149681_a(World world, int x, int y, int z, int data, EntityPlayer player) {
        int i1;
        if (player.field_71075_bZ.field_75098_d && BlockBedBase.isBlockHeadOfBed(data) && world.func_147439_a(x -= bedPosFX[i1 = BlockBedBase.func_149895_l((int)data)][0], y, z -= bedPosFX[i1][1]) == this) {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return true;
    }
}

