/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.entity.nbt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import project.studio.manametalmod.battle.DOTDamage;
import project.studio.manametalmod.core.EntityNBTBaseM3;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.event.EventFx;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;
import tw.pearki.mcmod.muya.common.SendType;

public class NbtEntityData
extends EntityNBTBaseM3 {
    protected final ManaMetalModRoot obj;
    public ManaElements Element = ManaElements.Earthm;
    public float Defense = 0.0f;
    public int Level = 1;
    public int FightingPower = 0;
    public int magicDefense = 0;
    public int PenetrationDefense = 0;
    public int drop = 100;
    public int attack_damage = 0;
    private List<String> bossReward = null;
    public List<DOTDamage> dots = new ArrayList<DOTDamage>(8);
    public List<PotionEffectM3> potions = new ArrayList<PotionEffectM3>(8);
    public boolean canBossAward = true;
    int time = 0;
    int timeDot = 0;

    public DOTDamage getDOTDamage(DOTDamage target) {
        if (!this.dots.isEmpty()) {
            for (int s = 0; s < this.dots.size(); ++s) {
                if (!this.dots.get(s).equalsDot(target)) continue;
                return this.dots.get(s);
            }
        }
        return null;
    }

    public boolean isDOTDamage(DOTDamage target) {
        if (!this.dots.isEmpty()) {
            for (int s = 0; s < this.dots.size(); ++s) {
                if (!this.dots.get(s).equalsDot(target)) continue;
                return true;
            }
        }
        return false;
    }

    public void addPotion(PotionEffectM3 target) {
        int size = this.potions.size();
        for (int s = 0; s < size; ++s) {
            PotionEffectM3 potion = this.potions.get(s);
            if (potion.ID != target.ID) continue;
            if (target.LV > potion.LV) {
                potion.TIME = target.TIME;
                potion.LV = target.LV;
                this.send();
            } else if (target.LV == potion.LV && target.TIME > potion.TIME) {
                potion.TIME = target.TIME;
                this.send();
            }
            return;
        }
        this.potions.add(target);
        this.send2();
    }

    public void addPotionUUIDVerify(PotionEffectM3 potion) {
        int size = this.potions.size();
        for (int s = 0; s < size; ++s) {
            PotionEffectM3 temp = this.potions.get(s);
            if (temp.ID != potion.ID) continue;
            if (potion.LV > temp.LV) {
                temp.TIME = potion.TIME;
                temp.LV = potion.LV;
                if (potion.UUIDList != null) {
                    if (temp.UUIDList == null) {
                        temp.UUIDList = new HashSet<Long>();
                    }
                    temp.UUIDList.addAll(potion.UUIDList);
                }
                this.send2();
            } else if (potion.LV == temp.LV && potion.TIME > temp.TIME) {
                temp.TIME = potion.TIME;
                if (potion.UUIDList != null) {
                    if (temp.UUIDList == null) {
                        temp.UUIDList = new HashSet<Long>();
                    }
                    temp.UUIDList.addAll(potion.UUIDList);
                }
                this.send2();
            }
            return;
        }
        this.potions.add(potion);
        this.send2();
    }

    public boolean removePotion(PotionM3 data) {
        for (int s = 0; s < this.potions.size(); ++s) {
            if (this.potions.get((int)s).ID.ordinal() != data.ordinal()) continue;
            this.potions.remove(s);
            this.send2();
            return true;
        }
        return false;
    }

    public void dopotion() {
        if (this.potions.isEmpty()) {
            return;
        }
        PotionEffectM3 effect = null;
        for (int s = 0; s < this.potions.size(); ++s) {
            effect = this.potions.get(s);
            --effect.TIME;
            if (effect.TIME >= 0) continue;
            EventFx.potionOver(this.entity, effect, this.obj);
            this.potions.remove(s);
            --s;
        }
        this.send2();
    }

    public void addbossReward(String player) {
        if (!this.canBossAward) {
            return;
        }
        if (this.bossReward == null) {
            this.bossReward = new ArrayList<String>(10);
        }
        if (!this.getBossReward().contains(player)) {
            this.getBossReward().add(player);
        }
    }

    public void clearbossReward() {
        if (this.bossReward != null) {
            this.bossReward.clear();
        }
    }

    public int getFightingPower() {
        return this.FightingPower;
    }

    public Entity getentity() {
        return this.entity;
    }

    public void send() {
        if (this.GetSide().isServer()) {
            this.Send();
        }
    }

    public NbtEntityData(ManaMetalModRoot obj) {
        this.obj = obj;
    }

    public ManaElements getElement() {
        return this.Element;
    }

    public float getDefense() {
        return this.Defense;
    }

    public int getLV() {
        return this.Level;
    }

    public void setDefense(float num) {
        this.Defense = num;
    }

    public void setLV(int LV2) {
        this.Level = LV2;
    }

    public void setPenetrationDefense(int penetrationDefense) {
        this.PenetrationDefense = penetrationDefense;
    }

    public void setFightingPower(int s) {
        this.FightingPower = s;
    }

    public void setElement(ManaElements element) {
        this.Element = element;
    }

    public void LoadNBT(NBTTagCompound tag) {
        this.canBossAward = NBTHelp.getBooleanSafe("canBossAward", tag, true);
        this.Element = ManaElements.getElementsFromID(tag.func_74762_e("Element"));
        this.Level = tag.func_74762_e("Level");
        this.FightingPower = tag.func_74762_e("FightingPower");
        this.PenetrationDefense = NBTHelp.getIntSafe("PenetrationDefense", tag, 0);
        this.drop = NBTHelp.getIntSafe("drop", tag, 100);
        this.attack_damage = NBTHelp.getIntSafe("attack_damage", tag, 0);
        this.Defense = NBTHelp.getFloatSafe("Defense", tag, 0.0f);
        if (tag.func_150297_b("potions", 9)) {
            this.potions.clear();
            NBTTagList list = tag.func_150295_c("potions", 10);
            int count = list.func_74745_c();
            for (int s = 0; s < count; ++s) {
                PotionEffectM3 data = PotionEffectM3.readFromNBT(list.func_150305_b(s));
                this.potions.add(data);
            }
        }
        if (tag.func_150297_b("bossRewardCount", 3)) {
            int count = tag.func_74762_e("bossRewardCount");
            this.setBossReward(new ArrayList<String>(count));
            for (int s = 0; s < count; ++s) {
                this.getBossReward().add(NBTHelp.getStringSafe("bossReward" + s, tag, "MissingNo"));
            }
        }
    }

    @Override
    public void SaveNBT(SendType type, NBTTagCompound tag) {
        tag.func_74757_a("canBossAward", this.canBossAward);
        tag.func_74768_a("Element", ManaElements.getElementsID(this.Element));
        tag.func_74768_a("Level", this.Level);
        tag.func_74768_a("FightingPower", this.FightingPower);
        tag.func_74768_a("PenetrationDefense", this.PenetrationDefense);
        tag.func_74768_a("drop", this.drop);
        tag.func_74768_a("attack_damage", this.attack_damage);
        tag.func_74776_a("Defense", this.Defense);
        if (!this.potions.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (int s = 0; s < this.potions.size(); ++s) {
                NBTTagCompound temp = new NBTTagCompound();
                this.potions.get(s).SaveToNBT(temp);
                list.func_74742_a((NBTBase)temp);
            }
            tag.func_74782_a("potions", (NBTBase)list);
        }
        if (this.getBossReward() != null) {
            for (int s = 0; s < this.getBossReward().size(); ++s) {
                tag.func_74778_a("bossReward" + s, this.getBossReward().get(s));
            }
            tag.func_74768_a("bossRewardCount", this.getBossReward().size());
        }
    }

    public void send2() {
        if (this.entity instanceof EntityPlayerMP) {
            this.SendTo((EntityPlayerMP)this.entity);
        }
    }

    public void Update() {
        ++this.timeDot;
        if (this.timeDot > 19) {
            this.timeDot = 0;
            try {
                this.doDot();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dots.clear();
            }
            try {
                this.dopotion();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.potions.clear();
            }
        }
    }

    public boolean addDotDamage(DOTDamage dot) {
        for (int s = 0; s < this.dots.size(); ++s) {
            if (!this.dots.get(s).equalsDot(dot)) continue;
            return false;
        }
        this.dots.add(dot);
        return true;
    }

    public void removeDotDamage(DOTDamage dot) {
        this.dots.remove(dot);
    }

    public void removeAllDotDamage() {
        this.dots.clear();
    }

    public void doDot() {
        if (this.dots.isEmpty()) {
            return;
        }
        for (int s = 0; s < this.dots.size(); ++s) {
            DOTDamage dot = this.dots.get(s);
            if (this.entity instanceof EntityLivingBase) {
                dot.attack((EntityLivingBase)this.entity);
            }
            --dot.count;
            if (dot.count > 0) continue;
            this.dots.remove(s);
            --s;
        }
    }

    public int getMagicDefense() {
        return this.magicDefense;
    }

    public void setMagicDefense(int magicDefense) {
        this.magicDefense = magicDefense;
    }

    public int getPenetrationDefense() {
        return this.PenetrationDefense;
    }

    public void addbossRewardName(EntityPlayer summonPlayerName, ManaMetalModRoot root) {
        this.addbossReward(summonPlayerName.func_70005_c_());
    }

    protected void Init() {
    }

    public List<String> getBossReward() {
        if (this.bossReward == null) {
            this.bossReward = new ArrayList<String>(10);
        }
        return this.bossReward;
    }

    public void setBossReward(List<String> bossReward) {
        this.bossReward = bossReward;
    }
}

