/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.entity.nbt;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.biome.BiomeGenSwamp;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import tw.pearki.mcmod.muya.common.SendType;
import tw.pearki.mcmod.muya.common.entity.EntityNBTBase;

public class NbtSurvivalFactor
extends EntityNBTBase {
    public static final float AverageTemperature = 37.0f;
    float Temperature = 37.0f;
    int Water = 1000;
    int Fatigue = 1000;
    int Oxygen = 1000;
    int Humidity = 0;
    int Disease = 0;
    int time = 0;
    int weight = 0;
    int[] weightMax = new int[]{2500, 3500, 4500};
    int bedPower = 0;
    public ItemStack eatFoodTemp;
    public int eadSameFood = 0;
    protected final ManaMetalModRoot obj;

    public NbtSurvivalFactor(ManaMetalModRoot obj) {
        this.obj = obj;
    }

    public void LoadNBT(NBTTagCompound nbt) {
        this.Temperature = nbt.func_74760_g("Temperature");
        this.Water = nbt.func_74762_e("Water");
        this.Oxygen = nbt.func_74762_e("Oxygen");
        this.Fatigue = nbt.func_74762_e("Fatigue");
        nbt.func_74762_e("bedPower");
        this.bedPower = NBTHelp.getIntSafe("bedPower", nbt, 0);
        this.eatFoodTemp = NBTHelp.getItemStackSafe(nbt, null);
        this.eadSameFood = nbt.func_74762_e("eadSameFood");
    }

    protected void SaveNBT(SendType type, NBTTagCompound nbt) {
        nbt.func_74776_a("Temperature", this.Temperature);
        nbt.func_74768_a("Water", this.Water);
        nbt.func_74768_a("Oxygen", this.Oxygen);
        nbt.func_74768_a("Fatigue", this.Fatigue);
        nbt.func_74768_a("bedPower", this.bedPower);
        if (this.eatFoodTemp != null) {
            this.eatFoodTemp.func_77955_b(nbt);
        }
        nbt.func_74768_a("eadSameFood", this.eadSameFood);
    }

    public void changeTemperature(float temperature, EntityPlayer player) {
        temperature -= 0.5f;
        this.Temperature += (temperature -= (float)(this.Humidity / 900)) / (this.Temperature / 4.0f);
        if (player.func_70027_ad()) {
            this.Temperature += 1.2f;
        }
    }

    public void changeHumidity(BiomeGenBase biome, EntityPlayer player) {
        if (player.func_70090_H()) {
            this.Humidity = 1000;
        } else {
            if (player.func_130014_f_().func_72896_J() && player.func_130014_f_().func_72937_j((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) {
                this.Humidity += 90;
            }
            this.Humidity = (int)((float)this.Humidity - this.Temperature / 3.0f);
            if (biome instanceof BiomeGenOcean || biome instanceof BiomeGenRiver) {
                this.Humidity += 10;
            } else if (biome instanceof BiomeGenDesert || biome instanceof BiomeGenHell) {
                this.Humidity -= 50;
            } else if (biome instanceof BiomeGenJungle || biome instanceof BiomeGenSwamp) {
                this.Humidity += 5;
            }
        }
    }

    public float EnvironmentalVariables() {
        float temperature = 0.0f;
        int posX = (int)this.entity.field_70165_t;
        int posY = (int)this.entity.field_70163_u;
        int posZ = (int)this.entity.field_70161_v;
        for (int y = -3; y < 4; ++y) {
            for (int x = -3; x < 4; ++x) {
                for (int z = -3; z < 4; ++z) {
                    Block block = this.entity.field_70170_p.func_147439_a(posX + x, posY + y, posZ + z);
                    if (!ManaMetalAPI.TemperatureBlock.containsKey(block)) continue;
                    temperature += ManaMetalAPI.TemperatureBlock.get(block).floatValue();
                }
            }
        }
        return temperature / 343.0f;
    }

    public void changeWater(BiomeGenBase biome, EntityPlayer player) {
        this.Water = player.func_70090_H() ? 1000 : (int)((float)this.Water - (10.0f + this.Temperature / 5.0f));
    }

    public void updateSurvivalFactor() {
        EntityPlayer player = (EntityPlayer)this.entity;
        BiomeGenBase biome = player.func_130014_f_().getBiomeGenForCoordsBody((int)player.field_70165_t, (int)player.field_70161_v);
        this.changeTemperature(biome.field_76750_F, player);
        this.changeHumidity(biome, player);
        this.changeWater(biome, player);
        this.EnvironmentalVariables();
        player.func_71026_bH();
        player.func_70051_ag();
        if (this.GetSide().isServer()) {
            this.Send();
        }
    }

    public void Update() {
        ++this.time;
        if (this.time >= 100) {
            this.updateSurvivalFactor();
            this.time = 0;
        }
    }

    protected void Init() {
    }
}

