/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.magic;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.battle.AttackType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.mob.EntityMagicBallTrackTileEntity;
import project.studio.manametalmod.network.MessageSoundFX;
import project.studio.manametalmod.network.PacketHandlerMana;
import project.studio.manametalmod.spell.SpellType;

public enum ManaElements {
    Magic,
    Water,
    Ice,
    Fire,
    Light,
    Dark,
    Wind,
    Earthm,
    Grass,
    Thunder;


    public static ManaElements readFromNBT(NBTTagCompound nbt) {
        return ManaElements.getElementsFromString(NBTHelp.getStringSafe("ManaElements", nbt, "Magic"));
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("ManaElements", this.toString());
    }

    public void PlayerElementsSoundClinet(int dimension, double x, double y, double z, double range) {
        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageSoundFX(ManaElements.getElementsSounds(this), false), new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public void playerSoundAtEntity(Entity entity) {
        entity.field_70170_p.func_72956_a(entity, ManaElements.getElementsSounds(this), 1.0f, (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
    }

    public int getColor() {
        switch (this) {
            case Dark: {
                return 0;
            }
            case Earthm: {
                return 40484;
            }
            case Fire: {
                return 16751872;
            }
            case Grass: {
                return 65284;
            }
            case Ice: {
                return 8585206;
            }
            case Light: {
                return 16772167;
            }
            case Magic: {
                return 10538239;
            }
            case Thunder: {
                return 0xFFF600;
            }
            case Water: {
                return 7039231;
            }
            case Wind: {
                return 5701552;
            }
        }
        return 0xFFFFFF;
    }

    public int[] getColorRGB() {
        switch (this) {
            case Dark: {
                return new int[]{0, 0, 0};
            }
            case Earthm: {
                return new int[]{0, 130, 21};
            }
            case Fire: {
                return new int[]{255, 162, 56};
            }
            case Grass: {
                return new int[]{0, 255, 4};
            }
            case Ice: {
                return new int[]{145, 255, 255};
            }
            case Light: {
                return new int[]{255, 238, 165};
            }
            case Magic: {
                return new int[]{102, 216, 255};
            }
            case Thunder: {
                return new int[]{255, 246, 0};
            }
            case Water: {
                return new int[]{107, 104, 255};
            }
            case Wind: {
                return new int[]{56, 255, 189};
            }
        }
        return new int[]{255, 255, 255};
    }

    public String getTranslationName() {
        return MMM.getTranslateText("item.weapon.effects.Elements." + this.ordinal());
    }

    public ManaElements getEntityElements(EntityLivingBase entity) {
        ManaMetalModRoot root = MMM.getEntityNBT(entity);
        if (root != null) {
            return root.ManaEntityData.getElement();
        }
        return null;
    }

    public static DamageSource getDamageSource(ManaElements Elements) {
        return new DamageSource(ManaElements.getElementsName(Elements)).func_82726_p();
    }

    public static DamageSource getDamageSourceIndirect(ManaElements Elements, Entity ball, Entity player) {
        return AttackType.getDamage(player, Elements, SpellType.Energy, WeaponType.Magic, true, true);
    }

    public static float getElementsEffests(ManaElements Elements, Entity Target2, Entity Ball, Entity shooter, float attack) {
        if (Target2 != null && Target2 instanceof EntityLivingBase) {
            if (Elements == Magic) {
                return attack;
            }
            if (Elements == Water) {
                return attack;
            }
            if (Elements == Ice) {
                return attack;
            }
            if (Elements == Fire) {
                return attack;
            }
            if (Elements == Light) {
                return attack;
            }
            if (Elements == Dark) {
                return attack;
            }
            if (Elements == Wind) {
                return attack;
            }
            if (Elements == Earthm) {
                return attack;
            }
            if (Elements == Grass) {
                return attack;
            }
            if (Elements == Thunder) {
                return attack;
            }
        }
        return attack;
    }

    public static String getElementsSounds(ManaElements Elements) {
        if (Elements == Magic) {
            return "manametalmod:magic.magic";
        }
        if (Elements == Water) {
            return "manametalmod:magic.water";
        }
        if (Elements == Ice) {
            return "manametalmod:magic.ice";
        }
        if (Elements == Fire) {
            return "manametalmod:magic.fire";
        }
        if (Elements == Light) {
            return "manametalmod:magic.light";
        }
        if (Elements == Dark) {
            return "manametalmod:magic.dark";
        }
        if (Elements == Wind) {
            return "manametalmod:magic.wind";
        }
        if (Elements == Earthm) {
            return "manametalmod:magic.earthm";
        }
        if (Elements == Grass) {
            return "manametalmod:magic.grass";
        }
        if (Elements == Thunder) {
            return "manametalmod:magic.thunder";
        }
        return null;
    }

    public static String getElementsName(ManaElements Elements) {
        if (Elements == null) {
            return null;
        }
        return Elements.toString();
    }

    public static int getElementsID(ManaElements Elements) {
        if (Elements == null) {
            return 0;
        }
        return Elements.ordinal();
    }

    public static ManaElements getElementsFromID(int id) {
        if (id < ManaElements.values().length) {
            return ManaElements.values()[id];
        }
        return null;
    }

    public static ManaElements getElementsFromString(String name) {
        if (name == null) {
            return null;
        }
        for (int s = 0; s < ManaElements.values().length; ++s) {
            if (!ManaElements.values()[s].toString().equals(name)) continue;
            return ManaElements.values()[s];
        }
        return null;
    }

    public static boolean getElementsNemesis(ManaElements Elements, ManaElements target) {
        if (Elements == null || target == null) {
            return false;
        }
        if (Elements == Magic) {
            return false;
        }
        return Elements == Water ? target == Fire || target == Ice || target == Earthm : (Elements == Ice ? target == Grass || target == Water || target == Wind : (Elements == Fire ? target == Grass || target == Magic || target == Ice : (Elements == Light ? target == Dark || target == Fire || target == Ice : (Elements == Dark ? target == Thunder || target == Fire || target == Wind : (Elements == Wind ? target == Grass || target == Earthm || target == Thunder : (Elements == Earthm ? target == Magic || target == Thunder || target == Dark : (Elements == Grass ? target == Water || target == Ice || target == Earthm : Elements == Thunder && (target == Water || target == Light || target == Wind))))))));
    }

    public float getElementsEffestsTileEntity(ManaElements Elements, Entity Target2, EntityMagicBallTrackTileEntity ball, float attack) {
        return ManaElements.getElementsEffests(Elements, Target2, ball, null, attack);
    }
}

