/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.client.ClientPacketHandle;

public class MessageClientChatText
implements IMessage,
IMessageHandler<MessageClientChatText, IMessage> {
    public String text;
    public Object[] obj;
    public ClientChatTextType[] types;

    public MessageClientChatText() {
    }

    public MessageClientChatText(String text, Object[] obj) {
        this.text = text;
        this.obj = obj;
        this.types = new ClientChatTextType[obj.length];
        for (int s = 0; s < this.types.length; ++s) {
            this.types[s] = obj[s] instanceof ItemStack ? ClientChatTextType.ItemStack : (obj[s] instanceof Item ? ClientChatTextType.Item : (obj[s] instanceof Block ? ClientChatTextType.Block : (obj[s] instanceof Entity ? ClientChatTextType.Entity : ClientChatTextType.String)));
        }
    }

    public IMessage onMessage(MessageClientChatText message, MessageContext ctx) {
        ClientPacketHandle.instance.acceptMessage(message);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        int s;
        int size = buf.readInt();
        this.types = new ClientChatTextType[size];
        this.obj = new Object[size];
        for (s = 0; s < this.types.length; ++s) {
            this.types[s] = ClientChatTextType.values()[buf.readInt()];
        }
        block8: for (s = 0; s < this.types.length; ++s) {
            switch (this.types[s]) {
                case ItemStack: {
                    this.obj[s] = ByteBufUtils.readItemStack((ByteBuf)buf);
                    continue block8;
                }
                case Item: {
                    this.obj[s] = Item.func_150899_d((int)buf.readInt());
                    continue block8;
                }
                case Block: {
                    this.obj[s] = Block.func_149729_e((int)buf.readInt());
                    continue block8;
                }
                case Entity: {
                    this.obj[s] = ByteBufUtils.readTag((ByteBuf)buf);
                    continue block8;
                }
                case String: {
                    this.obj[s] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                }
            }
        }
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        int s;
        buf.writeInt(this.types.length);
        for (s = 0; s < this.types.length; ++s) {
            buf.writeInt(this.types[s].ordinal());
        }
        block8: for (s = 0; s < this.types.length; ++s) {
            switch (this.types[s]) {
                case ItemStack: {
                    ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)this.obj[s]));
                    continue block8;
                }
                case Item: {
                    buf.writeInt(Item.func_150891_b((Item)((Item)this.obj[s])));
                    continue block8;
                }
                case Block: {
                    buf.writeInt(Block.func_149682_b((Block)((Block)this.obj[s])));
                    continue block8;
                }
                case Entity: {
                    NBTTagCompound tag = new NBTTagCompound();
                    Entity entity = (Entity)this.obj[s];
                    entity.func_70039_c(tag);
                    ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
                    continue block8;
                }
                case String: {
                    ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.obj[s].toString());
                }
            }
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    public static enum ClientChatTextType {
        ItemStack,
        Item,
        Block,
        Entity,
        String;

    }
}

