/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.api.MoneySourceType;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.mail.Mail;
import project.studio.manametalmod.mail.MailCore;
import project.studio.manametalmod.mail.Stationery;
import project.studio.manametalmod.network.PacketHelp;

public class MessageMailSet
implements IMessage,
IMessageHandler<MessageMailSet, IMessage> {
    private int ID;
    String title;
    String target;
    String name;
    String text;
    long money;
    ItemStack[] items;
    private int itemCount;
    int paper;

    public MessageMailSet() {
    }

    public MessageMailSet(int id, String title, String target, String name, String text, long money, ItemStack[] items, int paper) {
        this.ID = id;
        this.title = title;
        this.target = target;
        this.name = name;
        this.text = text;
        this.money = money;
        this.items = items;
        this.itemCount = this.items != null ? items.length : 0;
        this.paper = paper;
    }

    public IMessage onMessage(MessageMailSet message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        ManaMetalModRoot root = MMM.getEntityNBT((EntityPlayer)player);
        if (root != null && root.money.getMoney() >= message.money && message.money > 0L) {
            Mail mail = new Mail(message.title, message.text, message.target, message.name, message.money, message.items, Stationery.values()[message.paper]);
            MailCore.sendMail(mail, player.field_70170_p);
            root.money.addMoney(-message.money, MoneySourceType.Mail);
            MMM.Logg(message.name + " player sendMail to : " + message.target);
            MMM.addMessage((EntityPlayer)player, "MMM.info.mail.send", message.target);
            EntityPlayerMP playertarget = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(message.target);
            if (playertarget != null) {
                MMM.addMessage((EntityPlayer)playertarget, "MMM.info.mail.takemail");
            }
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.ID = buf.readInt();
        this.title = PacketHelp.readString(buf);
        this.target = PacketHelp.readString(buf);
        this.name = PacketHelp.readString(buf);
        this.text = PacketHelp.readString(buf);
        this.money = buf.readLong();
        this.itemCount = buf.readInt();
        this.items = new ItemStack[this.itemCount];
        for (int s = 0; s < this.itemCount; ++s) {
            this.items[s] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        this.paper = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ID);
        PacketHelp.writeString(buf, this.title);
        PacketHelp.writeString(buf, this.target);
        PacketHelp.writeString(buf, this.name);
        PacketHelp.writeString(buf, this.text);
        buf.writeLong(this.money);
        buf.writeInt(this.itemCount);
        for (int s = 0; s < this.itemCount; ++s) {
            if (this.items[s] == null) continue;
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.items[s]);
        }
        buf.writeInt(this.paper);
    }
}

