/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.produce.casting;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.core.AttackEffect;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.produce.casting.CastingEffectType;

public class CastingEffect {
    public static void addForgeLore(ItemStack item, List list, EntityPlayer player) {
        CastingEffectType type = CastingEffect.getType(item);
        if (type == null) {
            return;
        }
        NBTTagCompound tag = item.func_77978_p();
        list.set(0, MMM.getTranslateText("forge_effect.effect.name." + type.ordinal()) + list.get(0));
        StringBuilder text = new StringBuilder();
        AttackEffect data = new AttackEffect();
        if (item.func_77973_b() instanceof ItemArmor) {
            CastingEffect.doBeEffectAttackArmor(data, player, item);
        } else if (MMM.getItemIsWeapon(item)) {
            WeaponType attackType = MMM.getWeaponType(item);
            CastingEffect.doEffectAttack(data, item, player, true, attackType);
        } else if (item.func_77973_b().func_77616_k(item)) {
            CastingEffect.toolEffect(data, player, item);
        }
        String lore = null;
        CastingEffect.addText(text, "manaItem.magicDefense", data.defense, true, false);
        CastingEffect.addText(text, "manaItem.avoid", data.avoid, true, false);
        CastingEffect.addText(text, "manaItem.crit", data.crit, true, false);
        CastingEffect.addText(text, "manaItem.penetrate", data.penetration_base, true, false);
        CastingEffect.addText(text, "manaItem.attackMultiplier", data.attack, false, true);
        CastingEffect.addText(text, "forge_effect.tool.speed", data.customize_speed, true, false);
        CastingEffect.addText(text, "forge_effect.tool.exp", data.xp, true, false);
        if (text.length() <= 0) {
            list.add(MMM.getTranslateText("forge_effect.effect.noeffect"));
            text = null;
        } else {
            String removed;
            lore = text.toString();
            if (lore.endsWith(removed = " , ")) {
                String result = lore.substring(0, lore.length() - removed.length());
                list.add(EnumChatFormatting.GREEN + result);
            } else {
                list.add(EnumChatFormatting.GREEN + lore);
            }
        }
        if (tag.func_150297_b("player_name", 8)) {
            list.add(StatCollector.func_74838_a((String)"forge_effect.player_name") + tag.func_74779_i("player_name"));
        }
    }

    public static final void addText(StringBuilder text, String key, float data, boolean isinteger, boolean percent) {
        if (data != 0.0f) {
            text.append(MMM.getTranslateText(key));
            if (data > 0.0f) {
                text.append("+");
            }
            if (isinteger) {
                text.append((int)data);
            } else if (percent) {
                text.append((int)(data * 100.0f));
                text.append("%");
            } else {
                text.append(data);
            }
            text.append(" , ");
        }
    }

    public static final void doBeEffectAttack(AttackEffect data, EntityPlayer player) {
        for (int s = 0; s < 4; ++s) {
            ItemStack item = player.field_71071_by.field_70460_b[s];
            CastingEffect.doBeEffectAttackArmor(data, player, item);
        }
    }

    public static final void toolEffect(AttackEffect data, EntityPlayer player, ItemStack item) {
        CastingEffectType effect;
        if (item != null && (effect = CastingEffect.getType(item)) != null) {
            if (effect.isNormal) {
                return;
            }
            if (effect.isBad) {
                data.customize_speed -= 1.0f;
                return;
            }
            switch (effect) {
                case fast: {
                    data.customize_speed += 1.0f;
                    break;
                }
                case rapidly: {
                    data.customize_speed += 3.0f;
                    break;
                }
                case Speeding: {
                    data.customize_speed += 5.0f;
                    break;
                }
                case lucky: {
                    data.xp += 1.0f;
                    break;
                }
                case prayer: {
                    data.xp += 2.0f;
                    break;
                }
                case blessing: {
                    data.xp += 3.0f;
                    break;
                }
                case holy: {
                    data.customize_speed += 5.0f;
                    data.xp += 3.0f;
                    break;
                }
                case skygod: {
                    data.customize_speed += 7.0f;
                    data.xp += 4.0f;
                }
            }
        }
    }

    public static final void doBeEffectAttackArmor(AttackEffect data, EntityPlayer player, ItemStack item) {
        CastingEffectType effect;
        if (item != null && (effect = CastingEffect.getType(item)) != null) {
            if (effect.isNormal) {
                return;
            }
            if (effect.isBad) {
                data.defense = (int)((float)data.defense - 10.0f);
                data.avoid = (int)((float)data.avoid - 10.0f);
                return;
            }
            switch (effect) {
                case hard: {
                    data.defense += 20;
                    break;
                }
                case Sturdy: {
                    data.defense += 25;
                    break;
                }
                case Aegis: {
                    data.defense += 30;
                    break;
                }
                case Lightweight: {
                    data.avoid += 6;
                    break;
                }
                case brisk: {
                    data.avoid += 8;
                    break;
                }
                case Swift: {
                    data.avoid += 10;
                    break;
                }
                case myth: {
                    data.defense += 30;
                    data.avoid += 10;
                    break;
                }
                case brilliant: {
                    data.defense += 50;
                    data.avoid += 20;
                }
            }
        }
    }

    public static final void doEffectAttack(AttackEffect data, ItemStack item, EntityPlayer player, boolean cantrigger, WeaponType weapontype) {
        if (!cantrigger) {
            return;
        }
        CastingEffectType type = CastingEffect.getType(item);
        if (type == null) {
            return;
        }
        if (type.isNormal) {
            return;
        }
        if (type.isBad) {
            data.attack -= 0.1f;
            data.penetration_base -= 2;
            data.crit -= 5;
            return;
        }
        if (type == CastingEffectType.legend) {
            data.attack += 0.3f;
            data.crit += 10;
            data.penetration_base += 5;
            return;
        }
        if (type == CastingEffectType.eventually) {
            data.attack += 0.4f;
            data.crit += 20;
            data.penetration_base += 8;
            return;
        }
        switch (type) {
            case Spike: {
                data.attack += 0.1f;
                return;
            }
            case Sharp: {
                data.attack += 0.15f;
                return;
            }
            case demon: {
                data.attack += 0.2f;
                return;
            }
            case violence: {
                data.crit += 10;
                return;
            }
            case violent: {
                data.crit += 15;
                return;
            }
            case fury: {
                data.crit += 20;
                return;
            }
        }
        if (weapontype == null) {
            return;
        }
        if (weapontype == WeaponType.PhysicalMelee) {
            switch (type) {
                case Strong: {
                    data.attack += 0.1f;
                    return;
                }
                case StrongBig: {
                    data.attack += 0.15f;
                    return;
                }
                case powerful: {
                    data.attack += 0.2f;
                    return;
                }
            }
        }
        if (weapontype == WeaponType.PhysicalRange) {
            switch (type) {
                case Precision: {
                    data.attack += 0.1f;
                    return;
                }
                case accurate: {
                    data.attack += 0.15f;
                    return;
                }
                case Rapid: {
                    data.attack += 0.2f;
                    return;
                }
            }
        }
        if (weapontype == WeaponType.Magic) {
            switch (type) {
                case magical: {
                    data.attack += 0.1f;
                    return;
                }
                case mysterious: {
                    data.attack += 0.15f;
                    return;
                }
                case Magicguide: {
                    data.attack += 0.2f;
                    return;
                }
            }
        }
    }

    public static CastingEffectType getType(ItemStack item) {
        int id;
        if (item != null && item.func_77942_o() && item.func_77978_p().func_150297_b("forge_effect", 3) && (id = NBTHelp.getIntSafe("forge_effect", item.func_77978_p(), -1)) > -1) {
            return CastingEffectType.values()[id];
        }
        return null;
    }

    public static boolean setType(ItemStack item, CastingEffectType type) {
        if (item != null && item.func_77942_o() && item.func_77978_p().func_150297_b("forge_effect", 3)) {
            item.func_77978_p().func_74768_a("forge_effect", type.ordinal());
        }
        return false;
    }
}

