/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.skyadventure;

import project.studio.manametalmod.MMM;
import project.studio.manametalmod.skyadventure.GameSkyAdventure;

public enum SkyCard {
    Lightning(0),
    Fog(0),
    Wind(0),
    Fire(0),
    Rain(0),
    Crossing(0),
    Treasure(2),
    Arrow(1),
    Spear(1),
    Axe(1),
    Stone(1),
    Impact(1),
    Cannon1(1),
    Missile1(1),
    Machinegun1(1),
    Cannon2(1),
    Missile2(1),
    Machinegun2(1),
    Nuclear(1),
    Service(3),
    Tactics(3),
    Plan(3),
    TNT(3),
    Card(3),
    Potion(3),
    Magic(3),
    Armor(3),
    Cannon3(1),
    Missile3(1),
    Machinegun3(1);

    int type = 0;
    public static final SkyCard[] card_1;
    public static final SkyCard[] card_2;
    public static final SkyCard[] card_3;
    public static final SkyCard[] card_4;
    public static final SkyCard[] card_5;

    private SkyCard(int type) {
        this.type = type;
    }

    public static SkyCard getRandomrCard(GameSkyAdventure game) {
        int data = game.random.nextInt(100);
        if (data < 4) {
            return SkyCard.getCardFromCards(card_5, game);
        }
        if (data < 10) {
            return SkyCard.getCardFromCards(card_4, game);
        }
        if (data < 18) {
            return SkyCard.getCardFromCards(card_3, game);
        }
        if (data < 60) {
            return SkyCard.getCardFromCards(card_2, game);
        }
        if (data < 90) {
            return SkyCard.getCardFromCards(card_1, game);
        }
        return SkyCard.getCardFromCards(SkyCard.values(), game);
    }

    public static SkyCard getCardFromCards(SkyCard[] data, GameSkyAdventure game) {
        return data[game.random.nextInt(data.length)];
    }

    public int[] getUV() {
        switch (this) {
            case Lightning: 
            case Fog: 
            case Wind: 
            case Fire: 
            case Rain: 
            case Crossing: {
                return new int[]{this.ordinal() * 25, 0};
            }
            case Arrow: 
            case Spear: 
            case Axe: 
            case Stone: 
            case Impact: {
                return new int[]{(this.ordinal() - 7) * 25, 39};
            }
            case Service: {
                return new int[]{125, 39};
            }
            case Tactics: {
                return new int[]{150, 39};
            }
            case Plan: {
                return new int[]{175, 39};
            }
            case TNT: {
                return new int[]{200, 39};
            }
            case Card: {
                return new int[]{225, 39};
            }
            case Potion: {
                return new int[]{175, 78};
            }
            case Magic: {
                return new int[]{200, 78};
            }
            case Armor: {
                return new int[]{225, 78};
            }
            case Cannon1: 
            case Missile1: 
            case Machinegun1: 
            case Cannon2: 
            case Missile2: 
            case Machinegun2: 
            case Nuclear: {
                return new int[]{(this.ordinal() - 12) * 25, 78};
            }
            case Treasure: {
                return new int[]{150, 0};
            }
            case Cannon3: {
                return new int[]{0, 117};
            }
            case Missile3: {
                return new int[]{25, 117};
            }
            case Machinegun3: {
                return new int[]{50, 117};
            }
        }
        return new int[]{0, 0};
    }

    public int getAvoid() {
        int avoid = 0;
        switch (this) {
            case Arrow: {
                avoid = 50;
                break;
            }
            case Axe: {
                avoid = 80;
                break;
            }
            case Cannon1: {
                avoid = 80;
                break;
            }
            case Cannon2: {
                avoid = 85;
                break;
            }
            case Cannon3: {
                avoid = 90;
                break;
            }
            case Impact: {
                avoid = 100;
                break;
            }
            case Machinegun1: {
                avoid = 40;
                break;
            }
            case Machinegun2: {
                avoid = 50;
                break;
            }
            case Machinegun3: {
                avoid = 60;
                break;
            }
            case Missile1: {
                avoid = 100;
                break;
            }
            case Missile2: {
                avoid = 100;
                break;
            }
            case Missile3: {
                avoid = 100;
                break;
            }
            case Spear: {
                avoid = 40;
                break;
            }
            case Stone: {
                avoid = 90;
                break;
            }
            case Nuclear: {
                avoid = 90;
            }
        }
        return avoid;
    }

    public int getAttack() {
        switch (this) {
            case Arrow: {
                return 50;
            }
            case Axe: {
                return 75;
            }
            case Cannon1: {
                return 100;
            }
            case Cannon2: {
                return 150;
            }
            case Cannon3: {
                return 225;
            }
            case Impact: {
                return 100;
            }
            case Machinegun1: {
                return 150;
            }
            case Machinegun2: {
                return 195;
            }
            case Machinegun3: {
                return 250;
            }
            case Missile1: {
                return 60;
            }
            case Missile2: {
                return 95;
            }
            case Missile3: {
                return 140;
            }
            case Spear: {
                return 75;
            }
            case Stone: {
                return 40;
            }
            case Nuclear: {
                return 300;
            }
        }
        return 0;
    }

    public int tryAttack(GameSkyAdventure game) {
        int avoid = this.getAvoid();
        if (game.random.nextInt(100) < avoid) {
            return (int)((float)this.getAttack() * 0.9f + (float)game.random.nextInt((int)((float)this.getAttack() * 0.2f)));
        }
        game.setGameInfo(game.text("attack.avoid"));
        return 0;
    }

    public String names() {
        return MMM.getTranslateText("SkyCard." + this.toString());
    }

    public String lore() {
        if (this.isBattleCard()) {
            int max = (int)((double)this.getAttack() * 1.1);
            int min = (int)((double)this.getAttack() * 0.9);
            return this.names() + MMM.getTranslateText("SkyCard.avoid") + this.getAvoid() + "%" + MMM.getTranslateText("SkyCard.avoid2") + min + "~" + max + MMM.getTranslateText("SkyCard.avoid3");
        }
        return MMM.getTranslateText("SkyCard.lore." + this.toString());
    }

    public boolean isBattleCard() {
        return this.type == 1;
    }

    public boolean isNaturalCard() {
        return this.type == 0;
    }

    static {
        card_1 = new SkyCard[]{Lightning, Fog, Wind, Fire, Rain, Arrow, Spear, Axe, Stone, Impact, Treasure};
        card_2 = new SkyCard[]{Cannon1, Missile1, Machinegun1, Impact, Card, Potion, Crossing, Armor};
        card_3 = new SkyCard[]{Cannon2, Missile2, Machinegun2, Impact, Card, Potion, Service, Armor};
        card_4 = new SkyCard[]{Cannon3, Missile3, Machinegun3, TNT, Nuclear, Crossing};
        card_5 = new SkyCard[]{Magic, Tactics};
    }
}

