/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.team;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.network.MessageTeamClient;
import project.studio.manametalmod.network.PacketHandlerMana;

public class Team
implements Cloneable {
    public static String inviteNamePlayer = "";
    public static String inviteNameTeam = "";
    public static final int MaxPlayer = 10;
    public static final Map<String, Team> TeamPool = new HashMap<String, Team>();
    public static boolean hasInvite = false;
    public static final String keyPlayer = "player_";
    public static final String keyNoPlayer = "NONAME";
    public static final String keyTeamName = "keyTeamName";
    public String[] players = new String[10];
    public String teamName;
    @SideOnly(value=Side.CLIENT)
    public static Team client_team;

    public Team(String captain, String name) {
        this.players[0] = captain;
        this.teamName = name;
    }

    public static void addTeam(Team team, EntityPlayer player) {
        String nameteamp = player.func_70005_c_() + "_" + team.teamName;
        TeamPool.put(nameteamp, team);
    }

    public static void load(WorldEvent.Load event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getTeamPool().func_150297_b("TeamPool", 9)) {
            TeamPool.clear();
            NBTTagList list = MMM.getWorldData(event.world).getTeamPool().func_150295_c("TeamPool", 10);
            int size = list.func_74745_c();
            for (int s = 0; s < size; ++s) {
                NBTTagCompound tag = list.func_150305_b(s);
                if (!Team.check(tag)) continue;
                String nameteamp = tag.func_74779_i("player_0") + "_" + tag.func_74779_i(keyTeamName);
                TeamPool.put(nameteamp, Team.readFromNBT(tag));
                MMM.Logg("read team : " + tag.func_74779_i(keyTeamName) + " / captain : " + tag.func_74779_i("player_0"));
            }
        }
    }

    public static void save(WorldEvent.Save event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<String, Team> entry : TeamPool.entrySet()) {
                Team team = entry.getValue();
                NBTTagCompound tag = new NBTTagCompound();
                Team.saveToNBT(tag, entry.getValue());
                list.func_74742_a((NBTBase)tag);
            }
            MMM.getWorldData(event.world).getTeamPool().func_74782_a("TeamPool", (NBTBase)list);
            MMM.getWorldData(event.world).func_76185_a();
        }
    }

    public static boolean same(EntityPlayer player1, EntityPlayer player2) {
        Team team1 = Team.getTeamFromPool(player1);
        Team team2 = Team.getTeamFromPool(player2);
        return team1 != null && team2 != null && team1 == team2;
    }

    public static void playerLogin(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            for (Map.Entry<String, Team> entry : TeamPool.entrySet()) {
                Team team = entry.getValue();
                if (!Team.hasPlayer(team, player)) continue;
                Team.setPlayerTeamRoot(player, entry.getKey());
                PacketHandlerMana.INSTANCE.sendTo((IMessage)new MessageTeamClient(0, team.teamName, team.players[0], team.players), (EntityPlayerMP)player);
                MMM.addMessage(player, "MMM.teamlogin", team.teamName, team.players[0]);
                return;
            }
        }
    }

    public static void setPlayerTeamRoot(EntityPlayer player, String team) {
        ManaMetalModRoot root;
        if (!player.field_70170_p.field_72995_K && (root = MMM.getEntityNBT(player)) != null) {
            root.carrer.teamName = team;
        }
    }

    public static Team readFromNBT(NBTTagCompound tag) {
        Team team = new Team(tag.func_74779_i("player_0"), tag.func_74779_i(keyTeamName));
        for (int s = 1; s < team.players.length; ++s) {
            if (!tag.func_150297_b(keyPlayer + s, 8)) continue;
            team.players[s] = tag.func_74779_i(keyPlayer + s);
        }
        return team;
    }

    public static void saveToNBT(NBTTagCompound tag, Team team) {
        tag.func_74778_a(keyTeamName, team.teamName);
        for (int s = 0; s < team.players.length; ++s) {
            if (team.players[s] == null) continue;
            tag.func_74778_a(keyPlayer + s, team.players[s]);
        }
    }

    public static boolean check(NBTTagCompound tag) {
        return tag != null && tag.func_150297_b(keyTeamName, 8) && tag.func_150297_b("player_0", 8);
    }

    public static String[] getTeamPlayers(EntityPlayer player) {
        Team team;
        if (!player.field_70170_p.field_72995_K && (team = Team.getTeamFromPool(player)) != null) {
            return team.players;
        }
        return null;
    }

    public static boolean isCaptain(EntityPlayer player) {
        Team team;
        if (!player.field_70170_p.field_72995_K && (team = Team.getTeamFromPool(player)) != null) {
            return player.func_70005_c_().equals(team.players[0]);
        }
        return false;
    }

    public static boolean hasPlayer(Team team, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && team != null) {
            return MMM.isStringFromArray(team.players, player.func_70005_c_());
        }
        return false;
    }

    public static boolean hasPlayerName(Team team, String player) {
        if (team != null) {
            return MMM.isStringFromArray(team.players, player);
        }
        return false;
    }

    public static Team getTeamFromRoot(EntityPlayer player) {
        ManaMetalModRoot root;
        if (!player.field_70170_p.field_72995_K && (root = MMM.getEntityNBT(player)) != null && root.carrer.teamName != null && TeamPool.containsKey(root.carrer.teamName)) {
            return TeamPool.get(root.carrer.teamName);
        }
        return null;
    }

    public static Team getTeamFromPool(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            for (Map.Entry<String, Team> entry : TeamPool.entrySet()) {
                Team team = entry.getValue();
                if (!Team.hasPlayer(team, player)) continue;
                return team;
            }
        }
        return null;
    }

    public static Team applicationTeam(String captain, String name) {
        if (TeamPool.containsKey(captain + "_" + name)) {
            return null;
        }
        return new Team(captain, name);
    }

    public static boolean addPlayer(Team team, String target) {
        if (!Team.hasPlayerName(team, target)) {
            for (int s = 0; s < team.players.length; ++s) {
                if (team.players[s] != null) continue;
                team.players[s] = target;
                return true;
            }
        }
        return false;
    }

    public static boolean removePlayer(Team team, String target) {
        for (int s = 0; s < team.players.length; ++s) {
            if (team.players[s] == null || !team.players[s].equals(target)) continue;
            team.players[s] = null;
            return true;
        }
        return false;
    }

    public static void updateTeamPlaeyers(Team team) {
        int s;
        ArrayList<String> list = new ArrayList<String>(10);
        for (s = 0; s < team.players.length; ++s) {
            if (team.players[s] == null) continue;
            list.add(team.players[s]);
        }
        for (s = 0; s < team.players.length; ++s) {
            team.players[s] = s < list.size() ? (String)list.get(s) : null;
        }
    }

    public static void synchronize(Team team, World world, int type, String target) {
        if (!world.field_72995_K) {
            for (int s = 0; s < team.players.length; ++s) {
                EntityPlayerMP player;
                if (team.players[s] == null || (player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(team.players[s])) == null) continue;
                PacketHandlerMana.INSTANCE.sendTo((IMessage)new MessageTeamClient(0, team.teamName, team.players[0], team.players), player);
                MMM.addMessage((EntityPlayer)player, "MMM.teamplayersynchronize." + type, target);
            }
        }
    }

    public static void dissolve(Team team, World world) {
        if (!world.field_72995_K) {
            for (int s = 0; s < team.players.length; ++s) {
                EntityPlayerMP player;
                if (team.players[s] == null || (player = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(team.players[s])) == null) continue;
                PacketHandlerMana.INSTANCE.sendTo((IMessage)new MessageTeamClient(2, "null", "null", new String[]{"0"}), player);
                MMM.addMessage((EntityPlayer)player, "MMM.teamdissolve");
            }
            String nameteamp = team.players[0] + "_" + team.teamName;
            TeamPool.remove(nameteamp);
        }
    }

    public static int getTeamEfficientPlayerCount(Team team, EntityPlayer player) {
        if (team == null) {
            return 1;
        }
        int count = 0;
        for (int s = 0; s < team.players.length; ++s) {
            EntityPlayer playerteam;
            if (team.players[s] == null || (playerteam = MMM.getPlayer(player.field_70170_p, team.players[s])) == null) continue;
            ++count;
        }
        return count;
    }
}

