/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.universeMessage;

import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringEscapeUtils;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.universeMessage.UMEutils;
import project.studio.manametalmod.universeMessage.UniverseMessage;

public class UMEReader {
    static boolean isError = false;
    private static List<DecodedUniverseMessage> Message = new ArrayList<DecodedUniverseMessage>();
    private static int nowMaxCount = 0;
    private static HashMap<String, String> usedUUID = new HashMap();
    private static String firstRawMsg;
    private static final String[] queryURL;

    private static String getQueryURL(int limit, int offset) {
        String s = "";
        if (limit > 0) {
            s = s + "+limit+" + limit;
        }
        if (offset >= 0) {
            s = s + "+offset+" + offset;
        }
        return queryURL[0] + s + queryURL[1];
    }

    static void init() {
        UMEReader.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(boolean skipExistingMessage) {
        BufferedReader in = null;
        String text = null;
        try {
            URL urlTemp = new URL(UMEReader.getQueryURL(1, 0));
            urlTemp.openConnection().setRequestProperty("User-agent", "IE/7.0");
            in = new BufferedReader(new InputStreamReader(urlTemp.openConnection().getInputStream(), "UTF-8"));
            boolean finded = false;
            while ((text = in.readLine()) != null) {
                if (text.indexOf("UniverseMessageV4") < 0) continue;
                finded = true;
                if (text.equals(firstRawMsg)) break;
                UMEReader.flushMsg();
                nowMaxCount = 1;
                firstRawMsg = text;
                Message.add(new DecodedUniverseMessage(text));
                break;
            }
            if (!finded) {
                nowMaxCount = 0;
            }
            if (skipExistingMessage && nowMaxCount == 1) {
                urlTemp = new URL(UMEReader.getQueryURL(0, nowMaxCount));
                urlTemp.openConnection().setRequestProperty("User-agent", "IE/7.0");
                in = new BufferedReader(new InputStreamReader(urlTemp.openConnection().getInputStream(), "UTF-8"));
                while ((text = in.readLine()) != null) {
                    if (text.indexOf("UniverseMessageV4") < 0) continue;
                    ++nowMaxCount;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static void flushMsg() {
        Message.clear();
        if (usedUUID.size() > 1000) {
            usedUUID.clear();
        }
    }

    static void readUME() {
        isError = false;
        BufferedReader in = null;
        String text = null;
        try {
            UMEReader.init(true);
            if (nowMaxCount <= 0) {
                return;
            }
            URL urlTemp = new URL(UMEReader.getQueryURL(0, nowMaxCount));
            urlTemp.openConnection().setRequestProperty("User-agent", "IE/7.0");
            in = new BufferedReader(new InputStreamReader(urlTemp.openConnection().getInputStream(), "UTF-8"));
            while ((text = in.readLine()) != null) {
                if (text.indexOf("UniverseMessageV4") < 0) continue;
                ++nowMaxCount;
                Message.add(new DecodedUniverseMessage(text));
            }
            isError = false;
        }
        catch (MalformedURLException e) {
            isError = true;
        }
        catch (IOException e) {
            isError = true;
        }
        catch (Exception e) {
            isError = true;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    static void displayUMEforPlayer() {
        UMEReader.readUME();
        if (isError) {
            isError = false;
            UniverseMessage.time = -200;
            return;
        }
        for (int s = 0; s < Message.size(); ++s) {
            String msgGet;
            DecodedUniverseMessage msg = Message.get(s);
            if (msg.isReaded || (msgGet = msg.getMsg()) == null) continue;
            MMM.addMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, msgGet);
        }
        if (Message.size() > 300) {
            UMEReader.flushMsg();
        }
    }

    static {
        queryURL = new String[]{"https://docs.google.com/spreadsheets/d/1FdA46JHfMpNizZLqsEPUNgsNQSu5zJo89AuXnzAiz5k/gviz/tq?tqx=out:html&tq=select+B+where+B+like+%27UniverseMessageV4_%25%27", "&gid=0"};
    }

    private static enum UMEstatus {
        UNVERIFIED,
        VALID,
        INVALID;

    }

    private static class DecodedUniverseMessage {
        private final String rawMsg;
        private UMEstatus status = UMEstatus.UNVERIFIED;
        private String msg = null;
        String playerName = null;
        boolean isReaded = false;

        DecodedUniverseMessage(String rawMsg) {
            this.rawMsg = rawMsg == null ? "" : rawMsg;
            this.decodeMsg();
        }

        public String getMsg() {
            this.isReaded = true;
            if (this.status.equals((Object)UMEstatus.VALID)) {
                return this.msg;
            }
            if (this.status.equals((Object)UMEstatus.INVALID)) {
                return null;
            }
            this.decodeMsg();
            if (this.status.equals((Object)UMEstatus.UNVERIFIED)) {
                return null;
            }
            return this.getMsg();
        }

        public void decodeMsg() {
            String[] texts = UMEutils.decodeRawMsg(this.rawMsg);
            if (texts.length <= 4) {
                this.status = UMEstatus.INVALID;
                return;
            }
            this.playerName = texts[1];
            String lastUUID = (String)usedUUID.get(this.playerName);
            if (lastUUID != null && lastUUID.equals(texts[3])) {
                this.status = UMEstatus.INVALID;
                return;
            }
            GameProfile testProfile = UMEutils.getProfileFromSessionService(this.playerName, texts[3]);
            if (testProfile == null || !testProfile.isComplete()) {
                this.status = UMEstatus.INVALID;
                return;
            }
            usedUUID.put(this.playerName, texts[3]);
            texts[2] = StringEscapeUtils.unescapeHtml4((String)texts[2]);
            String Modifier2 = UniverseMessage.UME;
            String massageOK = "<" + this.playerName + "> " + texts[2];
            if (texts[1].equals("dragon060810")) {
                Modifier2 = Modifier2 + UniverseMessage.UMEAuthor;
            }
            if (UniverseMessage.VIP_List.contains(texts[1])) {
                Modifier2 = Modifier2 + UniverseMessage.UMEVIP;
            }
            this.msg = Modifier2 + massageOK;
            this.status = UMEstatus.VALID;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof String) {
                return ((String)o).equals(this.rawMsg);
            }
            if (o instanceof DecodedUniverseMessage) {
                return ((DecodedUniverseMessage)o).equals(this.rawMsg);
            }
            return false;
        }

        public int hashCode() {
            return this.rawMsg.hashCode();
        }
    }
}

