/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.watergame;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalMod;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Pos;
import project.studio.manametalmod.instance_dungeon.MobDunageonHeroTemple;
import project.studio.manametalmod.itemAndBlockCraft.ItemCraft10;
import project.studio.manametalmod.produce.gemcraft.GemCraftCore;
import project.studio.manametalmod.watergame.BlockWaterGame;
import project.studio.manametalmod.watergame.WaterDirection;
import project.studio.manametalmod.watergame.WaterGameType;

public class TileEntityWaterGame
extends TileEntity {
    public int time = 0;
    public WaterGameType type = WaterGameType.soure;
    public boolean hasWater = false;
    public boolean canMove = true;
    public WaterDirection direction = WaterDirection.Up;
    public boolean update = false;
    public Pos soure = new Pos();
    public WaterDirection soure_direction = WaterDirection.Up;
    public WaterGameType soure_type = WaterGameType.soure;
    boolean isUpSoureWater = false;
    public int addWaterTIme = 0;
    public boolean hasitems = true;
    public static final List<ItemStack> waterGameItems = new ArrayList<ItemStack>();
    public static final List<ItemStack> waterGameItems2 = new ArrayList<ItemStack>();

    public TileEntityWaterGame() {
        this.type = WaterGameType.soure;
    }

    public TileEntityWaterGame(WaterGameType type, WaterDirection direction) {
        this.type = type;
        this.direction = direction;
        if (type == WaterGameType.soure) {
            this.hasWater = true;
        }
    }

    public void addWater(boolean add, WaterDirection direction, Pos pos, WaterGameType type, boolean isUpSoureWater) {
        if (!this.update) {
            return;
        }
        if (this.addWaterTIme > 0) {
            return;
        }
        this.hasWater = add;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.soure.isEmpty()) {
            this.soure = pos.copy();
        }
        this.soure_direction = direction;
        this.soure_type = type;
        this.isUpSoureWater = isUpSoureWater;
        this.addWaterTIme = 40;
        if (this.type == WaterGameType.end) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            if (this.hasitems) {
                this.hasitems = false;
                if (!this.field_145850_b.field_72995_K) {
                    this.done();
                }
            }
        }
    }

    public void done() {
        if (MMM.getDimensionID(this.field_145850_b) == M3Config.WorldInstanceDungeonID) {
            List<EntityLivingBase> list = MMM.findLivingBase(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 64.0);
            for (int s = 0; s < list.size(); ++s) {
                if (!(list.get(s) instanceof MobDunageonHeroTemple)) continue;
                MobDunageonHeroTemple mob = (MobDunageonHeroTemple)list.get(s);
                if (mob.type != 5) continue;
                mob.drawTest(50);
            }
        } else {
            this.addRandItemToPlayers();
            this.addRandItemToPlayers();
        }
    }

    public void addRandItemToPlayers() {
        List<EntityPlayer> list = MMM.findPlayers(this, 16.0);
        if (!list.isEmpty()) {
            for (int s = 0; s < list.size(); ++s) {
                ItemStack item = null;
                item = MMM.getDimensionID(this.field_145850_b) == M3Config.WorldPyramidID ? MMM.getRandomItemFromList(waterGameItems2).func_77946_l() : MMM.getRandomItemFromList(waterGameItems).func_77946_l();
                MMM.addMessageGetItem(list.get(s), item);
                MMM.addItemToPlayer(item, list.get(s));
            }
        }
    }

    public boolean canSate(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) instanceof BlockWaterGame) {
            return true;
        }
        for (int dx = -3; dx < 4; ++dx) {
            for (int dz = -3; dz < 4; ++dz) {
                for (int dy = -2; dy < 0; ++dy) {
                    if (!(world.func_147439_a(x + dx, y + dy, z + dz) instanceof BlockWaterGame)) continue;
                    TileEntityWaterGame tile = (TileEntityWaterGame)world.func_147438_o(x + dx, y + dy, z + dz);
                    if (tile.type != WaterGameType.Pillar) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.update) {
            this.update = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        switch (this.func_145832_p()) {
            case 0: {
                this.direction = WaterDirection.Dowm;
                break;
            }
            case 1: {
                this.direction = WaterDirection.Right;
                break;
            }
            case 2: {
                this.direction = WaterDirection.Up;
                break;
            }
            case 3: {
                this.direction = WaterDirection.Left;
            }
        }
        if (this.addWaterTIme > 0) {
            --this.addWaterTIme;
        }
        ++this.time;
        if (this.time > 5) {
            this.time = 0;
            if (this.type == WaterGameType.Pillar) {
                if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
                    MMM.breakBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                }
                return;
            }
            if (this.type != WaterGameType.rock && this.type != WaterGameType.Pillar && !this.canSate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                MMM.breakBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                return;
            }
            if (this.type == WaterGameType.rock) {
                return;
            }
            if (this.hasWater) {
                if (!this.hasSoure()) {
                    this.hasWater = false;
                    this.update = false;
                    this.soure = new Pos();
                    if (this.type == WaterGameType.end) {
                        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                    }
                    return;
                }
                this.type.update(this, this.field_145850_b, this.direction);
            }
        }
    }

    public boolean hasSoure() {
        if (this.type == WaterGameType.soure) {
            return true;
        }
        if (this.soure.isEmpty()) {
            return false;
        }
        if (this.type != WaterGameType.Pillar && this.soure.getPosTileEntity(this.field_145850_b) != null && this.soure.getPosTileEntity(this.field_145850_b) instanceof TileEntityWaterGame) {
            TileEntityWaterGame target = (TileEntityWaterGame)this.soure.getPosTileEntity(this.field_145850_b);
            if (target.hasWater || target.type == WaterGameType.soure) {
                if (this.isUpSoureWater) {
                    return true;
                }
                if (WaterGameType.canAdd(this.type, this.direction, this.soure_direction, this.isUpSoureWater)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = WaterGameType.values()[NBTHelp.getIntSafe("type", nbt, 0)];
        this.canMove = NBTHelp.getBooleanSafe("canMove", nbt, false);
        this.hasWater = NBTHelp.getBooleanSafe("hasWater", nbt, false);
        this.direction = WaterDirection.values()[NBTHelp.getIntSafe("direction", nbt, 0)];
        this.soure.readFromNBT(nbt);
        this.soure_type = WaterGameType.values()[NBTHelp.getIntSafe("soure_type", nbt, 0)];
        this.soure_direction = WaterDirection.values()[NBTHelp.getIntSafe("soure_direction", nbt, 0)];
        this.isUpSoureWater = NBTHelp.getBooleanSafe("isUpSoureWater", nbt, false);
        this.addWaterTIme = NBTHelp.getIntSafe("addWaterTIme", nbt, 0);
        this.hasitems = NBTHelp.getBooleanSafe("hasitems", nbt, true);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74757_a("canMove", this.canMove);
        nbt.func_74757_a("hasWater", this.hasWater);
        nbt.func_74768_a("direction", this.direction.ordinal());
        this.soure.saveToNBT(nbt);
        nbt.func_74768_a("soure_type", this.soure_type.ordinal());
        nbt.func_74768_a("soure_direction", this.soure_direction.ordinal());
        nbt.func_74757_a("isUpSoureWater", this.isUpSoureWater);
        nbt.func_74768_a("addWaterTIme", this.addWaterTIme);
        nbt.func_74757_a("hasitems", this.hasitems);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.type == WaterGameType.WaterDown) {
            return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 3), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
        }
        return super.getRenderBoundingBox();
    }

    static {
        waterGameItems.add(new ItemStack(GemCraftCore.ItemMagicJadeUnknowns, 1, 3));
        waterGameItems.add(new ItemStack(GemCraftCore.ItemMagicJadeUnknowns, 1, 4));
        waterGameItems.add(new ItemStack(GemCraftCore.ItemMagicJadeUnknowns, 1, 5));
        waterGameItems.add(new ItemStack(ItemCraft10.ItemBagLegendaryWeapon3s, 1));
        waterGameItems.add(new ItemStack(ManaMetalMod.SageofTheStone, 1));
        waterGameItems2.add(new ItemStack(GemCraftCore.ItemArmorGems, 1, 0));
        waterGameItems2.add(new ItemStack(GemCraftCore.ItemArmorGems, 1, 1));
        waterGameItems2.add(new ItemStack(GemCraftCore.ItemArmorGems, 1, 2));
        waterGameItems2.add(new ItemStack(GemCraftCore.ItemArmorGems, 1, 3));
    }
}

