/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.autocrystal;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.autocrystal.CraftingHelper;
import project.studio.manametalmod.autocrystal.Ingredient;
import project.studio.manametalmod.tileentity.TileEntityCrystalZ;

public final class CraftingHandler {
    private CraftingHandler() {
    }

    public static void checkRecipe(TileEntityCrystalZ tile, int time, ItemStack target) {
        if (!tile.open || time % 20 != 0 || tile.func_145831_w().field_72995_K) {
            return;
        }
        if (tile.target == null || tile.energy.getEnergy() < 3) {
            return;
        }
        IInventory targetBox = tile.getTarget();
        if (Objects.isNull(targetBox)) {
            return;
        }
        HashMultiset itemCrafting = HashMultiset.create();
        for (int slot = 0; slot < targetBox.func_70302_i_(); ++slot) {
            ItemStack stack = targetBox.func_70301_a(slot);
            if (Objects.isNull(stack)) continue;
            ItemStack finalStack = stack.func_77946_l();
            Optional<ItemStack> opt = itemCrafting.stream().filter(it -> MMM.isItemStackEqual(it, stack)).findFirst();
            if (opt.isPresent()) {
                itemCrafting.add((Object)opt.get(), finalStack.field_77994_a);
                continue;
            }
            itemCrafting.add((Object)finalStack, finalStack.field_77994_a);
        }
        ImmutableMap<ImmutableList<Ingredient>, ItemStack> recipes = CraftingHelper.findRecipeByItemStack(target);
        for (Map.Entry recipe : recipes.entrySet()) {
            HashMultiset outputs = HashMultiset.create();
            HashMultiset itemUsed = HashMultiset.create();
            boolean flag = CraftingHandler.checkUsageItems((Multiset<ItemStack>)itemCrafting, (List)recipe.getKey(), (Multiset<ItemStack>)outputs, (Multiset<ItemStack>)itemUsed, 0);
            if (!flag) continue;
            CraftingHandler.create(tile, targetBox, (Multiset<ItemStack>)itemUsed, ((ItemStack)recipe.getValue()).func_77946_l());
            CraftingHandler.setOutputsOrDrop(tile, targetBox, (Multiset<ItemStack>)outputs);
            tile.energy.setEnergy(tile.energy.getEnergy() - 3);
        }
    }

    private static boolean checkUsageItems(Multiset<ItemStack> inventory, List<Ingredient> ingredients, Multiset<ItemStack> outputs, Multiset<ItemStack> used, int deepen) {
        HashMultiset itemCrafting = HashMultiset.create(inventory);
        HashMultiset itemOutputs = HashMultiset.create(outputs);
        HashMultiset itemUsed = HashMultiset.create(used);
        Object[] counts = new Boolean[ingredients.size()];
        Arrays.fill(counts, (Object)false);
        if (itemCrafting.isEmpty() && itemOutputs.isEmpty()) {
            return false;
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = ingredients.get(i);
            Optional<ItemStack> dat = itemCrafting.stream().filter(it -> CraftingHandler.matchItemStackInIngredient(ingredient, it)).findFirst();
            if (!dat.isPresent()) {
                Optional<ItemStack> datAddon = itemOutputs.stream().filter(it -> CraftingHandler.matchItemStackInIngredient(ingredient, it)).findFirst();
                if (!datAddon.isPresent()) continue;
                itemOutputs.remove((Object)datAddon.get(), 1);
                counts[i] = true;
                continue;
            }
            CraftingHandler.addItemStackToMultiset((Multiset<ItemStack>)itemUsed, dat.get(), -1);
            itemCrafting.remove((Object)dat.get(), 1);
            counts[i] = true;
        }
        HashSet<Integer> missed = new HashSet<Integer>(counts.length);
        for (int i = 0; i < counts.length; ++i) {
            if (((Boolean)counts[i]).booleanValue()) continue;
            missed.add(i);
        }
        if (missed.isEmpty()) {
            inventory.clear();
            inventory.addAll((Collection)itemCrafting);
            outputs.clear();
            outputs.addAll((Collection)itemOutputs);
            used.clear();
            used.addAll((Collection)itemUsed);
            return true;
        }
        if (deepen > 3) {
            return false;
        }
        for (Integer index : missed) {
            Ingredient ingredient = ingredients.get(index);
            Optional<ItemStack> datAddon = itemOutputs.stream().filter(it -> CraftingHandler.matchItemStackInIngredient(ingredient, it)).findFirst();
            if (datAddon.isPresent()) {
                itemOutputs.remove((Object)datAddon.get(), 1);
                counts[index.intValue()] = true;
                continue;
            }
            UnmodifiableIterator unmodifiableIterator = ingredient.getObj().iterator();
            if (!unmodifiableIterator.hasNext()) continue;
            ItemStack stack = (ItemStack)unmodifiableIterator.next();
            ImmutableMap<ImmutableList<Ingredient>, ItemStack> cache = CraftingHelper.findRecipeByItemStack(stack);
            for (Map.Entry entry : cache.entrySet()) {
                datAddon = itemOutputs.stream().filter(it -> CraftingHandler.matchItemStackInIngredient(ingredient, it)).findFirst();
                if (datAddon.isPresent()) {
                    itemOutputs.remove((Object)datAddon.get(), 1);
                    counts[index.intValue()] = true;
                    break;
                }
                boolean flag = CraftingHandler.checkUsageItems((Multiset<ItemStack>)itemCrafting, (List)entry.getKey(), (Multiset<ItemStack>)itemOutputs, (Multiset<ItemStack>)itemUsed, deepen + 1);
                if (!flag) continue;
                CraftingHandler.addItemStackToMultiset((Multiset<ItemStack>)itemOutputs, ((ItemStack)entry.getValue()).func_77946_l(), 1);
                counts[index.intValue()] = true;
                break;
            }
            if (((Boolean)counts[index]).booleanValue()) continue;
            return false;
        }
        inventory.clear();
        inventory.addAll((Collection)itemCrafting);
        outputs.clear();
        outputs.addAll((Collection)itemOutputs);
        used.clear();
        used.addAll((Collection)itemUsed);
        return true;
    }

    private static void create(TileEntityCrystalZ tile, IInventory inventory, Multiset<ItemStack> itemUsed, ItemStack output) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            Optional<ItemStack> opt;
            ItemStack stack = inventory.func_70301_a(slot);
            if (Objects.isNull(stack) || !(opt = itemUsed.stream().filter(it -> MMM.isItemStackEqual(it, stack)).findFirst()).isPresent()) continue;
            ItemStack data = stack.func_77946_l();
            int count = itemUsed.count((Object)opt.get());
            if (count > stack.field_77994_a) {
                itemUsed.remove((Object)data, stack.field_77994_a);
                inventory.func_70299_a(slot, null);
                continue;
            }
            itemUsed.remove((Object)data);
            inventory.func_70298_a(slot, count);
        }
        inventory.func_70296_d();
        EntityItem entityItem = new EntityItem(tile.func_145831_w(), (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.5, (double)tile.field_145849_e + 0.5, output.func_77946_l());
        tile.func_145831_w().func_72838_d((Entity)entityItem);
    }

    private static void setOutputsOrDrop(TileEntityCrystalZ tile, IInventory inventory, Multiset<ItemStack> outputs) {
        for (ItemStack output : outputs.elementSet()) {
            ItemStack item;
            int size;
            int count = outputs.count((Object)output);
            do {
                size = Math.min(output.func_77976_d(), count);
                count -= size;
                item = output.func_77946_l();
                item.field_77994_a = size;
                int less = MMM.insertItemStackToInventory(item, inventory);
                if (less <= 0) continue;
                count += less;
                break;
            } while (count > 0);
            do {
                size = Math.min(output.func_77976_d(), count);
                item = output.func_77946_l();
                item.field_77994_a = count -= size;
                EntityItem entityItem = new EntityItem(tile.func_145831_w(), (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.5, (double)tile.field_145849_e + 0.5, item);
                tile.func_145831_w().func_72838_d((Entity)entityItem);
            } while (count > 0);
        }
    }

    private static void addItemStackToMultiset(Multiset<ItemStack> multiset, ItemStack stack, int shrink) {
        Optional<ItemStack> opt = multiset.stream().filter(it -> MMM.isItemStackEqual(it, stack)).findFirst();
        if (opt.isPresent()) {
            multiset.add((Object)opt.get(), shrink == -1 ? 1 : stack.field_77994_a - shrink);
        } else {
            multiset.add((Object)stack.func_77946_l(), shrink == -1 ? 1 : stack.field_77994_a - shrink);
        }
    }

    public static boolean matchItemStackInIngredient(Ingredient ingredient, ItemStack itemStack) {
        if (ingredient == null || ingredient.getObj().isEmpty()) {
            return false;
        }
        return CraftingHandler.matchStackInList(ingredient.getObj(), itemStack);
    }

    public static boolean matchStackInList(List<ItemStack> array, ItemStack target) {
        return array.stream().anyMatch(it -> MMM.isItemStackEqual(it, target));
    }
}

