/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.autocrystal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.tuple.Pair;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.autocrystal.Ingredient;

public final class CraftingHelper {
    private CraftingHelper() {
    }

    public static ImmutableMap<ImmutableList<Ingredient>, ItemStack> findRecipeByItemStack(ItemStack recipeOut) {
        List recipeList = CraftingManager.func_77594_a().func_77592_b().stream().filter(it -> MMM.isItemStackEqual(it.func_77571_b(), recipeOut)).collect(Collectors.toList());
        if (recipeList.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder recipes = ImmutableMap.builder();
        recipeList.stream().map(CraftingHelper::getInputs).forEach(pair -> recipes.put(pair.getKey(), (Object)((ItemStack)pair.getValue()).func_77946_l()));
        return recipes.build();
    }

    @Nullable
    private static Ingredient getIngredientByOreDictionaryObject(Object item) {
        if (item instanceof ItemStack) {
            return new Ingredient((ItemStack)item);
        }
        if (!(item instanceof List)) {
            return null;
        }
        List list = (List)item;
        list.removeIf(Objects::isNull);
        ItemStack[] items = new ItemStack[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            items[i] = (ItemStack)list.get(i);
        }
        return new Ingredient(items);
    }

    private static Pair<ImmutableList<Ingredient>, ItemStack> getInputs(IRecipe recipeInput) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (recipeInput instanceof ShapedRecipes) {
            ShapedRecipes subRecipe = (ShapedRecipes)recipeInput;
            Arrays.stream(subRecipe.field_77574_d).forEach(item -> builder.add((Object)new Ingredient((ItemStack)item)));
            return Pair.of((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        if (recipeInput instanceof ShapelessRecipes) {
            ShapelessRecipes subRecipe = (ShapelessRecipes)recipeInput;
            subRecipe.field_77579_b.forEach(item -> builder.add((Object)new Ingredient((ItemStack)item)));
            return Pair.of((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        if (recipeInput instanceof ShapedOreRecipe) {
            ShapedOreRecipe subRecipe = (ShapedOreRecipe)recipeInput;
            Arrays.stream(subRecipe.getInput()).forEach(obj -> {
                Ingredient ingredient = CraftingHelper.getIngredientByOreDictionaryObject(obj);
                if (ingredient != null) {
                    builder.add((Object)ingredient);
                }
            });
            return Pair.of((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        if (recipeInput instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe subRecipe = (ShapelessOreRecipe)recipeInput;
            subRecipe.getInput().forEach(obj -> {
                Ingredient ingredient = CraftingHelper.getIngredientByOreDictionaryObject(obj);
                if (ingredient != null) {
                    builder.add((Object)ingredient);
                }
            });
            return Pair.of((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
        }
        return Pair.of((Object)builder.build(), (Object)recipeInput.func_77571_b().func_77946_l());
    }
}

