/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.chess;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.chess.AIChessMove;
import project.studio.manametalmod.chess.AIMain;
import project.studio.manametalmod.chess.ChessPos;
import project.studio.manametalmod.chess.ChessType;

public class AIChessPosition {
    public AIMain main;
    public static final int BLANK = 0;
    public static final int PAWN = 1;
    public static final int KNIGHT = 2;
    public static final int BISHOP = 3;
    public static final int ROOK = 4;
    public static final int QUEEN = 5;
    public static final int KING = 6;
    public int[] board = new int[80];
    boolean bWhiteKingMoved = false;
    boolean bBlackKingMoved = false;
    boolean bWhiteChecked = false;
    boolean bBlackChecked = false;
    int enPassantSquare = 0;
    private boolean isBlackTurn;

    public AIChessPosition(AIChessPosition p) {
        System.arraycopy(p.board, 0, this.board, 0, 80);
        this.bWhiteKingMoved = p.bWhiteKingMoved;
        this.bBlackKingMoved = p.bBlackKingMoved;
        this.bWhiteChecked = p.bWhiteChecked;
        this.bBlackChecked = p.bBlackChecked;
        this.isBlackTurn = p.isBlackTurn;
        this.main = p.main;
    }

    public AIChessPosition(AIMain main) {
        this.main = main;
        List<ChessPos> list = main.tile.list;
        for (int s = 0; s < list.size(); ++s) {
            ChessPos temp = list.get(s);
            int pieceValue = 0;
            if (temp.type == ChessType.Pawn) {
                pieceValue = 1;
            } else if (temp.type == ChessType.Bishop) {
                pieceValue = 3;
            } else if (temp.type == ChessType.Kinight) {
                pieceValue = 2;
            } else if (temp.type == ChessType.Rook) {
                pieceValue = 4;
            } else if (temp.type == ChessType.King) {
                pieceValue = 6;
            } else if (temp.type == ChessType.Queen) {
                pieceValue = 5;
            }
            if (temp.targetX + temp.targetZ * 10 >= this.board.length) continue;
            this.board[temp.targetX + temp.targetZ * 10] = temp.isBlack ? -pieceValue : pieceValue;
        }
        for (int i = 0; i < 8; ++i) {
            this.board[i * 10 + 8] = 7;
            this.board[i * 10 + 9] = 7;
        }
    }

    public void makeMove(AIChessMove move) {
        this.board[move.to] = this.board[move.from];
        this.board[move.from] = 0;
        if (move.to >= 70) {
            if (this.board[move.to] == 1) {
                this.board[move.to] = 5;
            }
        } else if (move.to < 8) {
            if (this.board[move.to] == -1) {
                this.board[move.to] = -5;
            }
        } else if (this.board[move.to] == 6 && !this.bWhiteKingMoved) {
            this.bWhiteKingMoved = true;
        } else if (this.board[move.to] == -6 && !this.bBlackKingMoved) {
            this.bBlackKingMoved = true;
        }
    }

    public void printBoard() {
        for (int i = 0; i < 80; ++i) {
            System.out.print("[" + this.board[i] + "] ");
            if (i % 10 != 9) continue;
            System.out.println();
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.board.length; ++i) {
            tag.func_74768_a("tile" + i, this.board[i]);
        }
        tag.func_74757_a("blackChecked", this.bBlackChecked);
        tag.func_74757_a("blackKingMoved", this.bBlackKingMoved);
        tag.func_74757_a("whiteChecked", this.bWhiteChecked);
        tag.func_74757_a("whiteKingMoved", this.bWhiteKingMoved);
        tag.func_74774_a("enPassantSquare", (byte)this.enPassantSquare);
        tag.func_74757_a("isBlackTurn", this.isBlackTurn);
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.board.length; ++i) {
            this.board[i] = tag.func_74762_e("tile" + i);
        }
        this.bBlackChecked = tag.func_74767_n("blackChecked");
        this.bBlackKingMoved = tag.func_74767_n("blackKingMoved");
        this.bWhiteChecked = tag.func_74767_n("whiteChecked");
        this.bWhiteKingMoved = tag.func_74767_n("whiteKingMoved");
        this.enPassantSquare = tag.func_74771_c("enPassantSquare");
        this.isBlackTurn = tag.func_74767_n("isBlackTurn");
    }

    public boolean isSame(AIChessPosition compare) {
        for (int i = 0; i < this.board.length; ++i) {
            if (this.board[i] == compare.board[i]) continue;
            return false;
        }
        if (this.bBlackChecked != compare.bBlackChecked || this.bBlackKingMoved != compare.bBlackKingMoved || this.bWhiteChecked != compare.bWhiteChecked || this.bWhiteKingMoved != compare.bWhiteKingMoved) {
            return false;
        }
        return this.enPassantSquare == compare.enPassantSquare && this.isBlackTurn == compare.isBlackTurn;
    }

    public boolean hasActiveDifference(AIChessPosition compare) {
        int thisPieceCount = 0;
        int comparePieceCount = 0;
        for (int i = 0; i < this.board.length; ++i) {
            if (this.board[i] == 1 && compare.board[i] != 1 || this.board[i] == -1 && compare.board[i] != -1) {
                return true;
            }
            if (this.board[i] != 0) {
                ++thisPieceCount;
            }
            if (compare.board[i] == 0) continue;
            ++comparePieceCount;
        }
        return thisPieceCount != comparePieceCount;
    }
}

