/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.command;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.blueprint.Schematic;
import project.studio.manametalmod.blueprint.SchematicBuild;
import project.studio.manametalmod.command.CommandBaseM3;
import project.studio.manametalmod.command.M3CommandLevel;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.dungeon.Dungeon;
import project.studio.manametalmod.event.EventEnemyFair;
import project.studio.manametalmod.pagan.BadGuyType;
import project.studio.manametalmod.world.core.ChunkProviderSkyMana;
import project.studio.manametalmod.world.generate.WorldGenDungeon;
import project.studio.manametalmod.world.generate.WorldGenDungeonDoor;

public class CommandM3Spawn
extends CommandBaseM3 {
    public String func_71517_b() {
        return "m3spawn";
    }

    @Override
    public M3CommandLevel getCommandLevel() {
        return M3CommandLevel.OP;
    }

    public void func_71515_b(ICommandSender send, String[] command) {
        if (command.length <= 0) {
            this.error();
        } else {
            String name;
            String s = command[0];
            EntityPlayerMP entityplayermp = CommandM3Spawn.func_71521_c((ICommandSender)send);
            int posX = (int)entityplayermp.field_70165_t;
            int YposTop = (int)entityplayermp.field_70163_u;
            int posZ = (int)entityplayermp.field_70161_v;
            World world = entityplayermp.field_70170_p;
            Random random = entityplayermp.func_70681_au();
            if (s.toLowerCase().equals("dungeon")) {
                int big;
                int averageHeight;
                Dungeon spawntype = Dungeon.values()[world.field_73012_v.nextInt(Dungeon.values().length)];
                name = "dungeon/" + spawntype.toString() + ".schematic";
                Schematic sh = null;
                if (WorldGenDungeon.dungeons.containsKey((Object)spawntype)) {
                    sh = WorldGenDungeon.dungeons.get((Object)spawntype);
                } else {
                    sh = new Schematic().loadSchematicFromJar(name);
                    WorldGenDungeon.dungeons.put(spawntype, sh);
                }
                int extra = 0;
                if (sh.width > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.width - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if (sh.length > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.length - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if ((averageHeight = WorldGenDungeonDoor.getAverageHeight(world, posX + (big = Math.max(sh.width, sh.length)) / 2, posZ + big / 2, big)) > 0) {
                    WorldGenDungeon.spawnDungeonSHBadGuy(world, posX, averageHeight, posZ, spawntype, sh, big);
                }
            }
            if (s.toLowerCase().equals("village")) {
                int big;
                int averageHeight;
                Schematic sh = null;
                name = "village/village" + (random.nextInt(12) + 1) + ".schematic";
                if (WorldGenDungeon.villages.containsKey(name)) {
                    sh = WorldGenDungeon.villages.get(name);
                } else {
                    sh = new Schematic().loadSchematicFromJar(name);
                    WorldGenDungeon.villages.put(name, sh);
                }
                int extra = 0;
                if (sh.width > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.width - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if (sh.length > M3Config.SpawnProbability_DungeonDoor_MinRange) {
                    extra += sh.length - M3Config.SpawnProbability_DungeonDoor_MinRange + 8;
                }
                if ((averageHeight = WorldGenDungeonDoor.getAverageHeight(world, posX + (big = Math.max(sh.width, sh.length)) / 2, posZ + big / 2, big)) > 0) {
                    WorldGenDungeon.spawnSchematicVillage(world, posX, averageHeight, posZ, sh, big);
                }
            }
            if (s.toLowerCase().equals("mana_spring")) {
                MMM.spawnSchematicManaS(world, posX, YposTop, posZ, "other/ManaSpring.schematic");
            }
            if (s.toLowerCase().equals("life_spring")) {
                MMM.spawnSchematicManaS2(world, posX, YposTop, posZ, "other/LifeSpring.schematic");
            }
            if (s.toLowerCase().equals("crystal_defense")) {
                MMM.spawnIDungeonGZIPNoTileEntity(world, posX, YposTop, posZ, "defensive_crystal_1");
            }
            if (s.toLowerCase().equals("pirate")) {
                SchematicBuild.spawnDungeonSHBadGuy(world, posX, YposTop, posZ, "badguy/01.schematic", BadGuyType.Pagan);
            }
            if (s.toLowerCase().equals("fortress")) {
                SchematicBuild.spawnDungeonSHBadGuy(world, posX, YposTop, posZ, "badguy/02.schematic", BadGuyType.Pirate);
            }
            if (s.toLowerCase().equals("mini_kit")) {
                MMM.spawnSchematicKit(world, posX, YposTop, posZ, "kit/" + world.field_73012_v.nextInt(51) + ".schematic");
            }
            if (s.toLowerCase().equals("laputa_castle")) {
                ChunkProviderSkyMana.spawnLaputaCastle(world, posX, YposTop, posZ);
            }
            if (s.toLowerCase().equals("newb_cun")) {
                EventEnemyFair.spawnIDungeonGZIP(world, posX, YposTop, posZ, "newcomer_village");
            }
        }
    }

    public List func_71516_a(ICommandSender ICommandSender2, String[] text) {
        return Arrays.asList("dungeon", "mana_spring", "life_spring", "village", "crystal_defense", "pirate", "fortress", "mini_kit", "laputa_castle", "newb_cun");
    }
}

