/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import project.studio.manametalmod.core.NBTHelp;

public class BingoItem {
    public Item item;
    public int metadata;
    public int count = 1;
    public boolean canAddCount = true;

    public BingoItem() {
    }

    public BingoItem setCanAddCount(boolean canAddCount) {
        this.canAddCount = canAddCount;
        return this;
    }

    public BingoItem setCount(int count) {
        this.count = count;
        return this;
    }

    public BingoItem(Item item, int metadata) {
        this.item = item;
        this.metadata = metadata;
    }

    public BingoItem(Block item, int metadata) {
        this.item = Item.func_150898_a((Block)item);
        this.metadata = metadata;
    }

    public BingoItem(ItemStack item) {
        this.item = item.func_77973_b();
        this.metadata = item.func_77960_j();
    }

    public int hashCode() {
        return Item.func_150891_b((Item)this.item) * this.metadata;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BingoItem) {
            BingoItem target = (BingoItem)obj;
            return target.item == this.item && target.metadata == this.metadata;
        }
        return super.equals(obj);
    }

    public BingoItem copy() {
        return new BingoItem(this.item, this.metadata);
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("item", Item.func_150891_b((Item)this.item));
        nbt.func_74768_a("metadata", this.metadata);
        nbt.func_74768_a("count", this.count);
        nbt.func_74757_a("canAddCount", this.canAddCount);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.item = Item.func_150899_d((int)nbt.func_74762_e("item"));
        this.metadata = nbt.func_74762_e("metadata");
        this.count = NBTHelp.getIntSafe("count", nbt, 1);
        this.canAddCount = NBTHelp.getBooleanSafe("canAddCount", nbt, true);
    }
}

