/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.ManaMetalAPI;
import project.studio.manametalmod.api.addon.SlashBladeCore;
import project.studio.manametalmod.battle.BattleType;
import project.studio.manametalmod.battle.WeaponType;
import project.studio.manametalmod.config.M3Config;
import project.studio.manametalmod.core.ItemEffect;
import project.studio.manametalmod.entity.nbt.ManaMetalModRoot;
import project.studio.manametalmod.instance_dungeon.IIncreaseWeapon;
import project.studio.manametalmod.items.ItemToolBlowingArrows;
import project.studio.manametalmod.items.ItemToolBowNew;
import project.studio.manametalmod.items.ItemToolDaggerBase;
import project.studio.manametalmod.items.ItemToolFan;
import project.studio.manametalmod.items.ItemToolHammer;
import project.studio.manametalmod.items.ItemToolJavelin;
import project.studio.manametalmod.items.ItemToolKatana;
import project.studio.manametalmod.items.ItemToolMagicBook;
import project.studio.manametalmod.items.ItemToolShortcane;
import project.studio.manametalmod.items.ItemToolSickle;
import project.studio.manametalmod.items.ItemToolSwordBase;
import project.studio.manametalmod.items.ItemToolWandMagic;
import project.studio.manametalmod.potion.PotionEffectM3;
import project.studio.manametalmod.potion.PotionM3;

public enum CareerCore {
    Swordsman,
    Ranger,
    Wizard,
    Assassin,
    Knight,
    Priest,
    Summoner,
    Curseman,
    BlowingArrows,
    Samurai,
    Hunter,
    BeastTrainer,
    Unknown;

    public static final int BaseEXP = 125;
    public static final int ExEXP = 50;
    public static final int MeleeBuffHP = 30;
    public static final float pointAgileMoveSpeed = 2.0E-4f;
    public static long[] LVneedXP;
    public static int[] LVMonsterXP;

    public int getLVUPaddHP() {
        switch (this) {
            case Swordsman: {
                return 100;
            }
            case Knight: {
                return 100;
            }
            case Priest: {
                return 90;
            }
            case BeastTrainer: {
                return 80;
            }
            case BlowingArrows: {
                return 80;
            }
            case Curseman: {
                return 80;
            }
            case Summoner: {
                return 80;
            }
            case Wizard: {
                return 70;
            }
            case Assassin: {
                return 70;
            }
            case Ranger: {
                return 70;
            }
            case Hunter: {
                return 70;
            }
            case Samurai: {
                return 70;
            }
            case Unknown: {
                return 0;
            }
        }
        return 0;
    }

    public static CareerCore getPlayerCarrer(EntityPlayer player) {
        int type = 0;
        ManaMetalModRoot root = MMM.getEntityNBT(player);
        type = root.carrer.getCareerType();
        return CareerCore.getPlayerCarrerFormID(type);
    }

    public static CareerCore getPlayerCarrer(ManaMetalModRoot root) {
        int type = root.carrer.getCareerType();
        return CareerCore.getPlayerCarrerFormID(type);
    }

    public static CareerCore getPlayerCarrerFormID(int ID) {
        switch (ID) {
            case 1: {
                return Swordsman;
            }
            case 2: {
                return Ranger;
            }
            case 3: {
                return Wizard;
            }
            case 4: {
                return Assassin;
            }
            case 5: {
                return Knight;
            }
            case 6: {
                return Summoner;
            }
            case 7: {
                return Curseman;
            }
            case 8: {
                return Priest;
            }
            case 9: {
                return BlowingArrows;
            }
            case 10: {
                return Samurai;
            }
            case 11: {
                return Hunter;
            }
            case 12: {
                return BeastTrainer;
            }
        }
        return Unknown;
    }

    public int getID() {
        switch (this) {
            case Swordsman: {
                return 1;
            }
            case Ranger: {
                return 2;
            }
            case Wizard: {
                return 3;
            }
            case Assassin: {
                return 4;
            }
            case Knight: {
                return 5;
            }
            case Summoner: {
                return 6;
            }
            case Curseman: {
                return 7;
            }
            case Priest: {
                return 8;
            }
            case BlowingArrows: {
                return 9;
            }
            case Samurai: {
                return 10;
            }
            case Hunter: {
                return 11;
            }
            case BeastTrainer: {
                return 12;
            }
        }
        return 0;
    }

    public static void removePoitnBase(EntityPlayer player, ManaMetalModRoot root, CareerPoint type, int count, boolean changePoint) {
        if (count > 0) {
            CareerCore.poitnBaseEffect(player, root, type, -count, changePoint);
        }
    }

    public static void addPoitnBase(EntityPlayer player, ManaMetalModRoot root, CareerPoint type, int count, boolean changePoint) {
        if (count > 0) {
            CareerCore.poitnBaseEffect(player, root, type, count, changePoint);
        }
    }

    public static void poitnBaseEffect(EntityPlayer player, ManaMetalModRoot root, CareerPoint type, int count, boolean changePoint) {
        switch (type) {
            case Power: {
                CareerCore.setModPointUseRanUUID(player, ItemEffect.HP, count * 40);
                root.carrer.addExtraHP(count * 40);
                root.carrer.addphysicalAttack(count * 2);
                root.carrer.addMAXdamage(count * 40);
                if (!changePoint) break;
                root.carrer.addPower(count);
                break;
            }
            case Agile: {
                CareerCore.setModPointUseRanUUID(player, ItemEffect.SPEED, (float)count * 2.0E-4f);
                root.carrer.addarrowAttack(count * 2);
                root.avoid.addAvoid(count);
                if (!changePoint) break;
                root.carrer.addAgile(count);
                break;
            }
            case Intelligence: {
                root.mana.addMagicMax(50 * count);
                root.carrer.addmagicAttack(count * 2);
                root.crit.addCrit(count);
                if (!changePoint) break;
                root.carrer.addWisdom(count);
                break;
            }
            case Con: {
                root.defe.addDefe(count);
                root.carrer.addHpReply((float)count * 5.0f);
                if (!changePoint) break;
                root.carrer.addConPoint(count);
                break;
            }
            case Wis: {
                if (!changePoint) break;
                root.carrer.addWisPoint(count);
            }
        }
    }

    public static boolean testPlayerWeapon(EntityPlayer player, CareerCore career) {
        if (player.func_71045_bC() != null) {
            Item weapon = player.func_71045_bC().func_77973_b();
            if (weapon instanceof IIncreaseWeapon) {
                return true;
            }
            switch (career) {
                case Assassin: {
                    if (!(weapon instanceof ItemToolDaggerBase)) break;
                    return true;
                }
                case BlowingArrows: {
                    if (!(weapon instanceof ItemToolBlowingArrows)) break;
                    return true;
                }
                case Curseman: {
                    if (!(weapon instanceof ItemToolFan)) break;
                    return true;
                }
                case Hunter: {
                    if (!(weapon instanceof ItemToolJavelin)) break;
                    return true;
                }
                case Knight: {
                    if (!(weapon instanceof ItemToolHammer)) break;
                    return true;
                }
                case Priest: {
                    if (!(weapon instanceof ItemToolMagicBook)) break;
                    return true;
                }
                case Ranger: {
                    if (!(weapon instanceof ItemToolBowNew)) break;
                    return weapon instanceof ItemToolBowNew;
                }
                case Summoner: {
                    if (!(weapon instanceof ItemToolSickle)) break;
                    return true;
                }
                case Swordsman: {
                    if (!(weapon instanceof ItemToolSwordBase)) break;
                    return true;
                }
                case BeastTrainer: {
                    if (!(weapon instanceof ItemToolShortcane)) break;
                    return true;
                }
                case Samurai: {
                    if (weapon instanceof ItemToolKatana) {
                        return true;
                    }
                    if (!MMM.isSlashBlade) break;
                    return SlashBladeCore.useSwordSlash(player.func_71045_bC());
                }
                case Wizard: {
                    if (!(weapon instanceof ItemToolWandMagic)) break;
                    return true;
                }
            }
        }
        return CareerCore.testPlayerWeaponModded(player, career);
    }

    public static boolean testPlayerWeaponModded(EntityPlayer player, CareerCore career) {
        Item weapon;
        BattleType BT;
        if (player.func_71045_bC() != null && (BT = ManaMetalAPI.ItemAttackBalance.get(weapon = player.func_71045_bC().func_77973_b())) != null) {
            switch (career) {
                case Swordsman: 
                case Knight: 
                case Assassin: 
                case Samurai: {
                    return BT.type == WeaponType.PhysicalMelee;
                }
                case BlowingArrows: 
                case Ranger: 
                case Hunter: {
                    return BT.type == WeaponType.PhysicalRange;
                }
                case Priest: 
                case BeastTrainer: 
                case Curseman: 
                case Summoner: 
                case Wizard: {
                    return BT.type == WeaponType.Magic;
                }
            }
        }
        return false;
    }

    public static void setPlayerCarrerModifier(EntityPlayer player, CareerCore type, boolean isRemove) {
        int data = 1;
        if (isRemove) {
            data = -1;
        }
        ManaMetalModRoot root = MMM.getEntityNBT(player);
        switch (type) {
            case Swordsman: 
            case Knight: 
            case Assassin: 
            case Samurai: {
                CareerCore.setModPointUseRanUUID(player, ItemEffect.HP, 200.0f * (float)data);
                root.carrer.addExtraHP(200 * data);
                root.carrer.addphysicalAttack(10.0f * (float)data);
                return;
            }
            case BlowingArrows: 
            case Ranger: 
            case Hunter: {
                CareerCore.setModPointUseRanUUID(player, ItemEffect.HP, 200.0f * (float)data);
                root.carrer.addExtraHP(200 * data);
                root.carrer.addarrowAttack(10.0f * (float)data);
                return;
            }
            case Priest: 
            case BeastTrainer: 
            case Curseman: 
            case Summoner: 
            case Wizard: {
                CareerCore.setModPointUseRanUUID(player, ItemEffect.HP, 200.0f * (float)data);
                root.carrer.addExtraHP(200 * data);
                root.carrer.addmagicAttack(10.0f * (float)data);
                return;
            }
            case Unknown: {
                return;
            }
        }
        player.func_70606_j(player.func_110138_aP());
    }

    public static void removePlayerCarrerModifier(EntityPlayer player, CareerCore type) {
        CareerCore.setPlayerCarrerModifier(player, type, true);
    }

    public static void setModPoint(EntityPlayer player, ItemEffect type, double ammo) {
        HashMultimap attributes = HashMultimap.create();
        attributes.clear();
        CareerCore.fillModifiers((Multimap<String, AttributeModifier>)attributes, type, ammo, player);
        player.func_110140_aT().func_111147_b((Multimap)attributes);
    }

    public static void setModPointUseRanUUID(EntityPlayer player, ItemEffect type, double ammo) {
        HashMultimap attributes = HashMultimap.create();
        attributes.clear();
        CareerCore.fillModifiersRanUUID((Multimap<String, AttributeModifier>)attributes, type, ammo, player);
        player.func_110140_aT().func_111147_b((Multimap)attributes);
    }

    public static void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemEffect type, double ammo, EntityPlayer player) {
        ManaMetalModRoot root;
        if (type == ItemEffect.HP) {
            attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.fromString(CareerCore.getModUUIDs(type)), "CareerType", ammo, 0));
        }
        if (type == ItemEffect.SPEED) {
            attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString(CareerCore.getModUUIDs(type)), "CareerType", ammo, 0));
        }
        if (type == ItemEffect.ATK) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(UUID.fromString(CareerCore.getModUUIDs(type)), "CareerType", ammo, 0));
        }
        if (type == ItemEffect.KNOCK) {
            attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(UUID.fromString(CareerCore.getModUUIDs(type)), "CareerType", ammo, 0));
        }
        if (type == ItemEffect.AVOID) {
            root = MMM.getEntityNBT(player);
            root.avoid.addAvoid((int)ammo);
        }
        if (type == ItemEffect.DEFE) {
            root = MMM.getEntityNBT(player);
            root.defe.addDefe((int)ammo);
        }
        if (type == ItemEffect.CRIT) {
            root = MMM.getEntityNBT(player);
            root.crit.addCrit((int)ammo);
        }
        if (type == ItemEffect.MAGIC) {
            root = MMM.getEntityNBT(player);
            root.mana.addRep((float)ammo);
        }
    }

    public static void mergeModifiers(ItemEffect type, EntityPlayer player) {
        if (type == ItemEffect.HP) {
            IAttributeInstance iAttributeInstance = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        }
    }

    public static void removeAttributeModifier(ItemEffect type, EntityPlayer player) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "PointEffect", 1.0, 0));
        player.func_110140_aT().func_111148_a((Multimap)attributes);
    }

    public static void correctPlayerHP(EntityPlayer player) {
    }

    public static void fillModifiersRanUUID(Multimap<String, AttributeModifier> attributes, ItemEffect type, double ammo, EntityPlayer player) {
        ManaMetalModRoot root;
        if (type == ItemEffect.HP) {
            attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "PointEffect", ammo, 0));
        }
        if (type == ItemEffect.SPEED) {
            attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "PointEffect", ammo, 0));
        }
        if (type == ItemEffect.ATK) {
            attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "PointEffect", ammo, 0));
        }
        if (type == ItemEffect.KNOCK) {
            attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(UUID.randomUUID(), "PointEffect", ammo, 0));
        }
        if (type == ItemEffect.AVOID) {
            root = MMM.getEntityNBT(player);
            root.avoid.addAvoid((int)ammo);
        }
        if (type == ItemEffect.DEFE) {
            root = MMM.getEntityNBT(player);
            root.defe.addDefe((int)ammo);
        }
        if (type == ItemEffect.CRIT) {
            root = MMM.getEntityNBT(player);
            root.crit.addCrit((int)ammo);
        }
        if (type == ItemEffect.MAGIC) {
            root = MMM.getEntityNBT(player);
            root.mana.addRep((float)ammo);
        }
    }

    public static String getModUUIDs(ItemEffect type) {
        if (type == ItemEffect.HP) {
            return "e3c31446-2bff-4181-a931-06e250603d75";
        }
        if (type == ItemEffect.SPEED) {
            return "3c4c25ec-f268-46a8-999e-42d26c0715ca";
        }
        if (type == ItemEffect.ATK) {
            return "2ce548ef-abe6-43ef-9685-1fbcb3682e23";
        }
        if (type == ItemEffect.KNOCK) {
            return "f26b6473-bedf-4d5a-bcd8-a8f974e1a50f";
        }
        return null;
    }

    public static long getLVneedEXPs(int LV2) {
        if (LV2 < LVneedXP.length) {
            return (long)((double)LVneedXP[LV2] * M3Config.need_exp_multiplier);
        }
        return 0L;
    }

    public static double getPlayerAttackSpeed(EntityPlayer player, ItemStack weapon) {
        if (PotionEffectM3.isPotion((EntityLivingBase)player, PotionM3.potionBloodRage)) {
            return 0.375;
        }
        return 0.75;
    }

    public static int getPlayerAttackRageWeaponSpeed(EntityPlayer player, ItemStack weapon) {
        return 15;
    }

    static {
        LVneedXP = new long[]{100L, 280L, 378L, 510L, 689L, 930L, 1256L, 1695L, 2288L, 3089L, 4170L, 5004L, 6005L, 7206L, 8647L, 10377L, 12452L, 14943L, 17931L, 21518L, 24745L, 28457L, 32726L, 37634L, 43280L, 49771L, 57237L, 65823L, 75696L, 87051L, 174101L, 191511L, 210662L, 231729L, 254901L, 280392L, 308431L, 339274L, 373201L, 410521L, 451573L, 496731L, 546404L, 601044L, 661149L, 694206L, 728916L, 765362L, 803630L, 843812L, 881783L, 921464L, 962930L, 1006261L, 1051543L, 1098863L, 1148311L, 1199985L, 1253985L, 1310414L, 1375935L, 1444732L, 1516968L, 1592817L, 1672457L, 1756080L, 1843884L, 1936078L, 2032882L, 2134526L, 2326634L, 2536031L, 2764274L, 3013058L, 3284234L, 3579815L, 3901998L, 4253178L, 4635964L, 5053200L, 5507988L, 6003707L, 6544041L, 7133005L, 7774975L, 8474723L, 9237448L, 10068818L, 10975012L, 11962763L, 13039412L, 14212959L, 15492125L, 16886416L, 18406194L, 20062751L, 21868399L, 23836555L, 26220210L, 0x1CC1A1AL, 33168566L, 36485423L, 40133965L, 0x2A1A2A1L, 48562098L, 53418307L, 58760138L, 64636152L, 71099767L, 78209744L, 86030718L, 94633790L, 104097169L, 114506886L, 125957575L, 138553332L, 152408665L, 167649532L, 184414485L, 202855933L, 223141527L, 245455679L, 270001247L, 297001372L, 326701509L, 359371660L, 395308826L, 434839709L, 478323680L, 526156048L, 578771653L, 601922519L, 625999420L, 651039396L, 677080972L, 704164211L, 732330780L, 761624011L, 792088971L, 823772530L, 856723431L, 890992368L, 926632063L, 963697346L, 1002245239L, 1042335049L, 1084028451L, 1127389589L, 1172485173L, 1219384580L, 1853464561L, 1946137789L, 2043444678L, 2145616912L, 2252897758L, 2365542646L, 2483819778L, 2608010767L, 2738411305L, 2875331871L, 3019098464L, 3170053387L, 3328556057L, 3494983860L, 3669733053L, 3853219705L, 4045880690L, 4248174725L, 4460583461L, 4683612634L, 4917793266L, 5163682929L, 5421867076L, 5692960430L, 5977608451L, 6276488874L, 6590313317L, 6919828983L, 7265820432L, 7629111454L, 8010567027L, 8411095378L, 8831650147L, 9273232654L, 9736894287L, 10223739001L, 10734925951L, 11271672249L, 11835255861L, 12427018654L, 13048369587L, 13700788067L, 14385827470L, 15105118843L, 15860374786L, 16653393525L, 17486063201L, 18360366361L, 19278384679L, 20242303913L, 21254419109L};
        LVMonsterXP = new int[]{20, 22, 24, 27, 29, 32, 35, 39, 43, 47, 118, 130, 143, 157, 173, 190, 209, 230, 253, 278, 306, 336, 370, 407, 448, 492, 542, 596, 673, 761, 1446, 1511, 1579, 1650, 1724, 1802, 1883, 1967, 2056, 2138, 2224, 2313, 2405, 2501, 2601, 2706, 2814, 2926, 3043, 3150, 3260, 3374, 3492, 3615, 3741, 3872, 4008, 4148, 4293, 4379, 4466, 4556, 4647, 4740, 4835, 4931, 5030, 5130, 5233, 5338, 5445, 5553, 5664, 5778, 5893, 6011, 6131, 6254, 6379, 6507, 6637, 6770, 6905, 7043, 7184, 7328, 7474, 7624, 7776, 7932, 8090, 8252, 8417, 8585, 8757, 8932, 9111, 9293, 9479, 10000, 10150, 10303, 10457, 10614, 10773, 10935, 11099, 11265, 11434, 11606, 11780, 11957, 12136, 12318, 12503, 12690, 12881, 13074, 13270, 13469, 13671, 13876, 14084, 14296, 14510, 14728, 14949, 15173, 15400, 15631, 15866, 16104, 16345, 16591, 16839, 17092, 17348, 17609, 17873, 18141, 18413, 18689, 18970, 19254, 19543, 19836, 20134, 20436, 20742, 21053, 21369, 21690, 22015, 22345, 22680, 23021, 23366, 23716, 24072, 24433, 24800, 25172, 25549, 25932, 26321, 26716, 27117, 27524, 27937, 28356, 28781, 29213, 29651, 30096, 30547, 31005, 31470, 31942, 32422, 32908, 33402, 33903, 34411, 34927, 35451, 35983, 36523, 37071, 37627, 38191, 38764, 39345, 39935, 40535, 41143, 41760, 42386, 43022, 43667, 44322};
    }

    public static enum CareerPoint {
        Power,
        Agile,
        Intelligence,
        Wis,
        Con;

    }
}

