/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core;

import net.minecraftforge.event.world.WorldEvent;
import project.studio.manametalmod.MMM;

public enum GameDifficult {
    Normal,
    Hard,
    Master,
    Expert,
    Elite,
    Difficult,
    Hell,
    Purgatory,
    Ultimate,
    Final;

    private static GameDifficult WorldDifficult;

    public static final void read(WorldEvent.Load event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0 && MMM.getWorldData(event.world).getData().func_150297_b("WorldDifficult", 3)) {
            GameDifficult.setWorldDifficult(GameDifficult.values()[MMM.getWorldData(event.world).getData().func_74762_e("WorldDifficult")]);
        }
    }

    public static final void save(WorldEvent.Save event) {
        if (!event.world.field_72995_K && MMM.getDimensionID(event.world) == 0) {
            MMM.getWorldData(event.world).getData().func_74768_a("WorldDifficult", WorldDifficult.ordinal());
            MMM.getWorldData(event.world).func_76185_a();
        }
    }

    public float getXPbuff() {
        switch (this) {
            case Normal: {
                return -0.5f;
            }
            case Hard: {
                return 0.1f;
            }
            case Master: {
                return 0.5f;
            }
            case Expert: {
                return 1.0f;
            }
            case Elite: {
                return 1.5f;
            }
            case Difficult: {
                return 2.0f;
            }
            case Hell: {
                return 3.0f;
            }
            case Purgatory: {
                return 4.0f;
            }
            case Ultimate: {
                return 5.0f;
            }
            case Final: {
                return 6.0f;
            }
        }
        return 1.0f;
    }

    public float getHPbuff() {
        switch (this) {
            case Normal: {
                return 1.0f;
            }
            case Hard: {
                return 1.5f;
            }
            case Master: {
                return 3.0f;
            }
            case Expert: {
                return 6.0f;
            }
            case Elite: {
                return 12.0f;
            }
            case Difficult: {
                return 24.0f;
            }
            case Hell: {
                return 48.0f;
            }
            case Purgatory: {
                return 128.0f;
            }
            case Ultimate: {
                return 256.0f;
            }
            case Final: {
                return 512.0f;
            }
        }
        return 1.0f;
    }

    public float getHPbuffBoss() {
        switch (this) {
            case Normal: {
                return 1.0f;
            }
            case Hard: {
                return 1.1f;
            }
            case Master: {
                return 1.2f;
            }
            case Expert: {
                return 1.3f;
            }
            case Elite: {
                return 1.5f;
            }
            case Difficult: {
                return 2.0f;
            }
            case Hell: {
                return 2.2f;
            }
            case Purgatory: {
                return 2.4f;
            }
            case Ultimate: {
                return 2.6f;
            }
            case Final: {
                return 3.0f;
            }
        }
        return 1.0f;
    }

    public float getAttackBuff() {
        switch (this) {
            case Normal: {
                return 1.0f;
            }
            case Hard: {
                return 1.25f;
            }
            case Master: {
                return 2.0f;
            }
            case Expert: {
                return 3.0f;
            }
            case Elite: {
                return 5.0f;
            }
            case Difficult: {
                return 6.0f;
            }
            case Hell: {
                return 9.0f;
            }
            case Purgatory: {
                return 12.0f;
            }
            case Ultimate: {
                return 24.0f;
            }
            case Final: {
                return 36.0f;
            }
        }
        return 1.0f;
    }

    public int getMaxBossBox() {
        switch (this) {
            case Normal: {
                return 0;
            }
            case Hard: {
                return 0;
            }
            case Master: {
                return 0;
            }
            case Expert: {
                return 2;
            }
            case Elite: {
                return 2;
            }
            case Difficult: {
                return 3;
            }
            case Hell: {
                return 3;
            }
            case Purgatory: {
                return 6;
            }
            case Ultimate: {
                return 8;
            }
            case Final: {
                return 10;
            }
        }
        return 1;
    }

    public String getName() {
        return MMM.getTranslateText("game.difficult." + this.ordinal());
    }

    public static int getTranslationID(String name) {
        for (int s = 0; s < GameDifficult.values().length; ++s) {
            if (!GameDifficult.values()[s].getName().equals(name)) continue;
            return GameDifficult.values()[s].ordinal();
        }
        return -1;
    }

    public static GameDifficult getWorldDifficult() {
        return WorldDifficult;
    }

    public static void setWorldDifficult(GameDifficult worldDifficult) {
        WorldDifficult = worldDifficult;
    }

    static {
        WorldDifficult = Normal;
    }
}

