/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.core.export_utils;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GLContext;
import project.studio.manametalmod.core.export_utils.EXUItemList;

public class ItemRenderM3 {
    public static final String MODID = "ItemRenderM3";
    public static final int DEFAULT_MAIN_BLOCK_SIZE = 128;
    public static final int DEFAULT_GRID_BLOCK_SIZE = 32;
    public static final int DEFAULT_MAIN_ENTITY_SIZE = 512;
    public static final int DEFAULT_GRID_ENTITY_SIZE = 128;
    public static final int DEFAULT_PLAYER_SIZE = 1024;
    @Mod.Instance(value="ItemRenderM3")
    public static ItemRenderM3 instance;
    public static Configuration cfg;
    public static boolean gl32_enabled;
    public static int mainBlockSize;
    public static int gridBlockSize;
    public static int mainEntitySize;
    public static int gridEntitySize;
    public static int playerSize;
    public static boolean exportVanillaItems;
    public static boolean debugMode;
    public static List<String> blacklist;
    public static float renderScale;
    public Logger log;

    public static void syncConfig() {
        mainBlockSize = cfg.get("general", "RenderBlockMain", 128, "Main size of export block image").getInt();
        gridBlockSize = cfg.get("general", "RenderBlockGrid", 32, "Grid size of export block image").getInt();
        mainEntitySize = cfg.get("general", "RenderEntityMain", 512, "Main size of export entity image").getInt();
        gridEntitySize = cfg.get("general", "RenderEntityGrid", 128, "Grid size of export entity image").getInt();
        playerSize = cfg.get("general", "RenderPlayer", 1024, "Size of export player image").getInt();
        exportVanillaItems = cfg.get("general", "ExportVanillaItems", false, "Export Vanilla Items").getBoolean();
        debugMode = cfg.get("general", "DebugMode", false, "Enable debug mode").getBoolean();
        blacklist = Arrays.asList(cfg.get("general", "BlackList", new String[0], "Export blacklist. Format: unlocalizedName@metadata").getStringList());
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.log = event.getModLog();
        if (event.getSide().isServer()) {
            this.log.error("Item Render is a client-only mod. Please remove this mod and restart your server.");
            return;
        }
        gl32_enabled = GLContext.getCapabilities().OpenGL32;
        cfg = new Configuration(event.getSuggestedConfigurationFile());
        ItemRenderM3.syncConfig();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            EXUItemList.updateList();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MODID)) {
            ItemRenderM3.syncConfig();
        }
    }

    static {
        gl32_enabled = false;
        mainBlockSize = 128;
        gridBlockSize = 32;
        mainEntitySize = 512;
        gridEntitySize = 128;
        playerSize = 1024;
        exportVanillaItems = false;
        debugMode = true;
        blacklist = new ArrayList<String>();
        renderScale = 1.0f;
    }
}

