/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.dark_magic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import project.studio.manametalmod.FXHelp;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.bosssummon.BossDarkKnightAbyss;
import project.studio.manametalmod.bosssummon.BossDeadAngelAbyss;
import project.studio.manametalmod.bosssummon.BossDestroyerAbyss;
import project.studio.manametalmod.bosssummon.BossDragonEvilAbyss;
import project.studio.manametalmod.bosssummon.BossDragonShadowAbyss;
import project.studio.manametalmod.bosssummon.BossLavaGiantAbyss;
import project.studio.manametalmod.bosssummon.BossRescuresAbyss;
import project.studio.manametalmod.bosssummon.BossSnakeWindAbyss;
import project.studio.manametalmod.bosssummon.BossWitheredDevilAbyss;
import project.studio.manametalmod.core.NBTHelp;
import project.studio.manametalmod.core.Particle;
import project.studio.manametalmod.dark_magic.DarkEnergy;
import project.studio.manametalmod.dark_magic.IDarkEnergyUse;
import project.studio.manametalmod.ender.EntityDragonClone;
import project.studio.manametalmod.multipleBlock.MultipleBlock;

public class TileEntityDarkSummon
extends TileEntity
implements IDarkEnergyUse {
    public int fxtime = 0;
    public int setID = -1;
    public DarkEnergy energy = new DarkEnergy(0);
    public boolean isStart = false;
    public int time = 0;
    public int timeMax = 0;
    public static final MultipleBlock tileMB = new MultipleBlock("TileEntityDarkSummon");

    public boolean isMultipleBlock() {
        return tileMB.testNoAir(this.field_145850_b, this.field_145851_c - 3, this.field_145848_d - 1, this.field_145849_e - 3);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.time = NBTHelp.getIntSafe("time", nbt, 0);
        this.setID = NBTHelp.getIntSafe("setID", nbt, -1);
        this.timeMax = NBTHelp.getIntSafe("timeMax", nbt, 1);
        this.isStart = NBTHelp.getBooleanSafe("isStart", nbt, false);
        this.energy.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("time", this.time);
        nbt.func_74768_a("setID", this.setID);
        nbt.func_74768_a("timeMax", this.timeMax);
        nbt.func_74757_a("isStart", this.isStart);
        this.energy.writeToNBT(nbt);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.isStart && this.energy.getEnergy() > 1) {
            this.energy.removeEnergy(2);
            ++this.time;
            if (this.time >= this.timeMax) {
                this.done();
                this.time = 0;
                this.timeMax = 0;
                this.isStart = false;
                this.setID = -1;
            }
        }
        if (this.isStart) {
            if (this.field_145850_b.field_72995_K) {
                FXHelp.spawnParticleTornado(this.field_145850_b, Particle.dark, this.fxtime, this.field_145851_c, this.field_145848_d, this.field_145849_e, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, 0.75f, 0.0, 0.35, 0.0);
            }
            if (this.fxtime % 80 == 0) {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, MMM.getMODID() + ":dark_Enchanting", 1.0f, 1.0f, true);
            }
            ++this.fxtime;
        }
    }

    public void done() {
        EntityLivingBase boss = this.getBoss(this.setID);
        if (boss != null) {
            this.playSound();
            boss.func_70080_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 0.0f, 0.0f);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)boss);
            }
        }
    }

    public void playSound() {
        this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "mob.zombie.remedy", 1.0f + this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat() * 0.7f + 0.3f, false);
        this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e));
        if (this.setID < 8) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, MMM.getMODID() + ":event.boss", 10.0f, 1.0f, false);
        } else {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, MMM.getMODID() + ":event.boss2", 10.0f, 1.0f, false);
        }
    }

    public void setStart(int id) {
        if (!this.isStart && this.canStart()) {
            this.time = 0;
            this.timeMax = TileEntityDarkSummon.getNeed(id)[0] / 2;
            this.isStart = true;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canStart() {
        if (this.setID > -1) {
            if (this.setID == 0) {
                return MMM.getDimensionID(this.field_145850_b) == 1;
            }
            return true;
        }
        return false;
    }

    public static final int[] getNeed(int id) {
        switch (id) {
            case 0: {
                return new int[]{1200, 10};
            }
            case 1: {
                return new int[]{160, 5};
            }
            case 2: {
                return new int[]{160, 5};
            }
            case 3: {
                return new int[]{160, 5};
            }
            case 4: {
                return new int[]{400, 5};
            }
            case 5: {
                return new int[]{400, 5};
            }
            case 6: {
                return new int[]{400, 5};
            }
            case 7: {
                return new int[]{800, 5};
            }
            case 8: {
                return new int[]{800, 10};
            }
            case 9: {
                return new int[]{1200, 10};
            }
            case 10: {
                return new int[]{1200, 10};
            }
        }
        return new int[]{1200, 5};
    }

    public EntityLivingBase getBoss(int id) {
        switch (id) {
            case 0: {
                return new EntityDragonClone(this.field_145850_b);
            }
            case 1: {
                return new EntityWither(this.field_145850_b);
            }
            case 2: {
                return new BossDestroyerAbyss(this.field_145850_b);
            }
            case 3: {
                return new BossRescuresAbyss(this.field_145850_b);
            }
            case 4: {
                return new BossDragonShadowAbyss(this.field_145850_b);
            }
            case 5: {
                return new BossLavaGiantAbyss(this.field_145850_b);
            }
            case 6: {
                return new BossDeadAngelAbyss(this.field_145850_b);
            }
            case 7: {
                return new BossWitheredDevilAbyss(this.field_145850_b);
            }
            case 8: {
                return new BossDarkKnightAbyss(this.field_145850_b);
            }
            case 9: {
                return new BossSnakeWindAbyss(this.field_145850_b);
            }
            case 10: {
                return new BossDragonEvilAbyss(this.field_145850_b);
            }
        }
        return null;
    }

    @Override
    public void onImportEnergy() {
    }

    @Override
    public void addEnergy(DarkEnergy energy) {
    }

    @Override
    public int getMaxEnergy() {
        return 500;
    }

    @Override
    public DarkEnergy getEnergy() {
        return this.energy;
    }

    @Override
    public boolean canImport() {
        return true;
    }

    @Override
    public boolean needEnergy() {
        return this.energy.getEnergy() < this.getMaxEnergy();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
        super.onDataPacket(net, packet);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
    }
}

