/*
 * Decompiled with CFR 0.152.
 */
package project.studio.manametalmod.defensive_tower;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import project.studio.manametalmod.MMM;
import project.studio.manametalmod.core.ProjectileHelp;
import project.studio.manametalmod.defensive_tower.TileEntityDefensiveTower;
import project.studio.manametalmod.magic.ManaElements;
import project.studio.manametalmod.mob.EntityMagicBallTrackTileEntity;
import project.studio.manametalmod.network.MessageFX;
import project.studio.manametalmod.network.PacketHandlerMana;

public enum DefensiveTowerType {
    Crystal,
    Arrow,
    Light,
    Lightning,
    Ice,
    Topaz,
    Dark,
    Fire;


    public void update(List<EntityLivingBase> list, TileEntityDefensiveTower tile) {
        switch (this) {
            case Arrow: {
                for (int s = 0; s < list.size(); ++s) {
                    if (!tile.canAttack(list.get(s))) continue;
                    ProjectileHelp.doArrowAttack(tile, list.get(s), tile.getAttack());
                    if (!tile.func_145831_w().field_72995_K) {
                        tile.renovePower(20);
                        MMM.playSoundFromServer(tile.func_145831_w(), "random.bow", tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                    }
                    return;
                }
                break;
            }
            case Crystal: 
            case Dark: 
            case Fire: 
            case Ice: {
                int s;
                for (s = 0; s < list.size(); ++s) {
                    if (!tile.canAttack(list.get(s))) continue;
                    EntityMagicBallTrackTileEntity ball = null;
                    switch (this) {
                        case Crystal: {
                            ball = new EntityMagicBallTrackTileEntity(tile.func_145831_w(), tile, tile.getAttack(), ManaElements.Magic, (Entity)list.get(s), tile.attackPlayer, 0);
                            break;
                        }
                        case Dark: {
                            ball = new EntityMagicBallTrackTileEntity(tile.func_145831_w(), tile, tile.getAttack(), ManaElements.Dark, (Entity)list.get(s), tile.attackPlayer, 2);
                            break;
                        }
                        case Fire: {
                            ball = new EntityMagicBallTrackTileEntity(tile.func_145831_w(), tile, tile.getAttack(), ManaElements.Fire, (Entity)list.get(s), tile.attackPlayer, 1);
                            break;
                        }
                        case Ice: {
                            ball = new EntityMagicBallTrackTileEntity(tile.func_145831_w(), tile, tile.getAttack(), ManaElements.Ice, (Entity)list.get(s), tile.attackPlayer, 0);
                        }
                    }
                    if (ball != null) {
                        ball.field_70181_x = 0.0;
                        ball.field_70159_w = 0.0;
                        ball.field_70179_y = 0.0;
                        ball.field_70163_u += 1.0;
                        ball.field_70165_t += 0.5;
                        ball.field_70161_v += 0.5;
                        if (!tile.func_145831_w().field_72995_K) {
                            tile.func_145831_w().func_72838_d((Entity)ball);
                            tile.renovePower(20);
                            switch (this) {
                                case Crystal: {
                                    MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Magic), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                                    break;
                                }
                                case Dark: {
                                    MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Dark), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                                    break;
                                }
                                case Fire: {
                                    MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Fire), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                                    break;
                                }
                                case Ice: {
                                    MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Ice), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                                }
                            }
                        }
                    }
                    return;
                }
            }
            case Light: {
                int s;
                for (s = 0; s < list.size(); ++s) {
                    EntityLivingBase target = list.get(s);
                    if (!tile.canAttack(target)) continue;
                    if (!tile.func_145831_w().field_72995_K) {
                        target.func_70097_a(new DamageSource("LightDamage"), tile.getAttack());
                        tile.renovePower(35);
                        MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Light), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(1, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O * 0.5f), target.field_70161_v, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e), new NetworkRegistry.TargetPoint(MMM.getDimensionID(tile.func_145831_w()), (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 16.0));
                    }
                    return;
                }
                break;
            }
            case Lightning: {
                for (int s = 0; s < list.size(); ++s) {
                    EntityLivingBase target = list.get(s);
                    if (!tile.canAttack(target)) continue;
                    target.func_70097_a(new DamageSource("LightningDamage"), tile.getAttack());
                    if (!tile.func_145831_w().field_72995_K) {
                        tile.renovePower(35);
                        MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Thunder), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
                        PacketHandlerMana.INSTANCE.sendToAllAround((IMessage)new MessageFX(51, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O * 0.5f), target.field_70161_v, (double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.7f), (double)((float)tile.field_145849_e + 0.5f)), new NetworkRegistry.TargetPoint(MMM.getDimensionID(tile.func_145831_w()), (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 16.0));
                    }
                    return;
                }
                break;
            }
            case Topaz: {
                if (tile.func_145831_w().field_72995_K) break;
                int attack = 0;
                for (int s = 0; s < list.size(); ++s) {
                    if (!tile.canAttack(list.get(s))) continue;
                    ++attack;
                    EntityMagicBallTrackTileEntity ball = new EntityMagicBallTrackTileEntity(tile.func_145831_w(), tile, tile.getAttack(), ManaElements.Light, (Entity)list.get(s), tile.attackPlayer, 2);
                    ball.field_70181_x = 0.0;
                    ball.field_70159_w = 0.0;
                    ball.field_70179_y = 0.0;
                    ball.field_70163_u += 1.0;
                    ball.field_70165_t += 0.5;
                    ball.field_70161_v += 0.5;
                    tile.func_145831_w().func_72838_d((Entity)ball);
                    if (attack >= 3) break;
                }
                if (attack <= 0) break;
                tile.renovePower(30);
                MMM.playSoundFromServer(tile.func_145831_w(), ManaElements.getElementsSounds(ManaElements.Light), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0, 1.0, 16.0);
            }
        }
    }

    public int getSpeed() {
        switch (this) {
            case Arrow: {
                return 30;
            }
            case Crystal: {
                return 60;
            }
            case Dark: {
                return 10;
            }
            case Fire: {
                return 60;
            }
            case Ice: {
                return 70;
            }
            case Light: {
                return 150;
            }
            case Lightning: {
                return 150;
            }
            case Topaz: {
                return 50;
            }
        }
        return 0;
    }

    public int getRange() {
        switch (this) {
            case Arrow: {
                return 48;
            }
            case Crystal: {
                return 32;
            }
            case Dark: {
                return 10;
            }
            case Fire: {
                return 16;
            }
            case Ice: {
                return 16;
            }
            case Light: {
                return 16;
            }
            case Lightning: {
                return 24;
            }
            case Topaz: {
                return 12;
            }
        }
        return 0;
    }

    public int getAttack() {
        switch (this) {
            case Arrow: {
                return 100;
            }
            case Crystal: {
                return 90;
            }
            case Dark: {
                return 50;
            }
            case Fire: {
                return 70;
            }
            case Ice: {
                return 70;
            }
            case Light: {
                return 200;
            }
            case Lightning: {
                return 200;
            }
            case Topaz: {
                return 80;
            }
        }
        return 0;
    }
}

